/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.detector.TileDetector;
import railcraft.common.carts.LinkageManager;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileDetectorTrain
extends TileDetector
implements IGuiReturnHandler {
    private short trainSize = (short)5;

    @Override
    public boolean testForCarts() {
        LinkageManager lm = LinkageManager.getInstance(this.k);
        List carts = CartTools.getMinecartsOnAllSides(this.k, this.l, this.m, this.n, 0.2f);
        for (py cart : carts) {
            if (lm.countCartsInTrain(cart) < this.getTrainSize()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected short updateInterval() {
        return 4;
    }

    @Override
    public boolean blockActivated(qx player) {
        GuiHandler.openGui(EnumGui.DETECTOR_TRAIN, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("size", this.getTrainSize());
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.setTrainSize(data.d("size"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeShort(this.getTrainSize());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.setTrainSize(data.readShort());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.getTrainSize());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.setTrainSize(data.readShort());
    }

    public short getTrainSize() {
        return this.trainSize;
    }

    public void setTrainSize(short trainSize) {
        this.trainSize = trainSize;
    }
}

