/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.detector.TileDetectorFilter;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.gui.slots.ISlotController;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileDetectorItem
extends TileDetectorFilter
implements IGuiReturnHandler {
    private PrimaryMode primaryMode = PrimaryMode.ANYTHING;
    private FilterMode filterMode = FilterMode.AT_LEAST;

    public TileDetectorItem() {
        super(9);
    }

    @Override
    public boolean testForCarts() {
        List carts = CartTools.getMinecartsOnAllSides(this.k, this.l, this.m, this.n, 0.2f);
        block7: for (py cart : carts) {
            if (cart.k_() <= 0) continue;
            switch (this.primaryMode) {
                case ANYTHING: {
                    return true;
                }
                case EMPTY: {
                    if (!InvTools.isInventoryEmpty((la)cart)) continue block7;
                    return true;
                }
                case FULL: {
                    if (!InvTools.isInventoryFull((la)cart)) continue block7;
                    return true;
                }
                case FILTERED: {
                    if (!this.matchesFilter(cart)) continue block7;
                    return true;
                }
                case NOT_EMPTY: {
                    if (InvTools.isInventoryEmpty((la)cart)) continue block7;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesFilter(py cart) {
        block5: for (int i = 0; i < this.getFilters().k_(); ++i) {
            ur filter = this.getFilters().a(i);
            if (filter == null) continue;
            int amountFilter = InvTools.countItems((la)this.getFilters(), filter);
            int amountCart = InvTools.countItems((la)cart, filter);
            switch (this.filterMode) {
                case EXACTLY: {
                    if (amountCart == amountFilter) continue block5;
                    return false;
                }
                case AT_LEAST: {
                    if (amountCart >= amountFilter) continue block5;
                    return false;
                }
                case AT_MOST: {
                    if (amountCart <= amountFilter) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("primaryMode", (byte)this.primaryMode.ordinal());
        data.a("filterMode", (byte)this.filterMode.ordinal());
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.primaryMode = PrimaryMode.values()[data.c("primaryMode")];
        this.filterMode = FilterMode.values()[data.c("filterMode")];
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.primaryMode.ordinal());
        data.writeByte((byte)this.filterMode.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.primaryMode = PrimaryMode.values()[data.readByte()];
        this.filterMode = FilterMode.values()[data.readByte()];
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte((byte)this.primaryMode.ordinal());
        data.writeByte((byte)this.filterMode.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.primaryMode = PrimaryMode.values()[data.readByte()];
        this.filterMode = FilterMode.values()[data.readByte()];
    }

    @Override
    public boolean blockActivated(qx player) {
        GuiHandler.openGui(EnumGui.DETECTOR_ITEM, player, this.k, this.l, this.m, this.n);
        return true;
    }

    public PrimaryMode getPrimaryMode() {
        return this.primaryMode;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public void setPrimaryMode(PrimaryMode primaryMode) {
        this.primaryMode = primaryMode;
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    public ISlotController getSlotController() {
        return new ISlotController(){

            @Override
            public boolean isSlotEnabled() {
                return TileDetectorItem.this.getPrimaryMode() == PrimaryMode.FILTERED;
            }
        };
    }

    public static enum FilterMode {
        AT_LEAST("At Least"),
        AT_MOST("At Most"),
        EXACTLY("Exactly");

        public final String name;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private FilterMode() {
            void name;
            this.name = name;
        }

        public String toString() {
            return RailcraftLanguage.translate("gui.detector.item." + this.name().toLowerCase());
        }
    }

    public static enum PrimaryMode {
        EMPTY("Empty"),
        FULL("Full"),
        ANYTHING("Anything"),
        FILTERED("Filtered"),
        NOT_EMPTY("Not Empty");

        public final String name;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private PrimaryMode() {
            void name;
            this.name = name;
        }

        public String toString() {
            return RailcraftLanguage.translate("gui.detector.item." + this.name().toLowerCase());
        }
    }
}

