/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.aesthetics.cube;

import java.util.ArrayList;
import java.util.List;
import railcraft.common.blocks.aesthetics.cube.BlockCube;
import railcraft.common.blocks.aesthetics.cube.ConcreteBlock;
import railcraft.common.blocks.aesthetics.cube.CrushedObsidian;
import railcraft.common.blocks.aesthetics.cube.CubeClass;
import railcraft.common.blocks.aesthetics.cube.InfernalBrick;
import railcraft.common.blocks.aesthetics.cube.SandyBrick;
import railcraft.common.blocks.aesthetics.cube.SteelBlock;
import railcraft.common.blocks.aesthetics.cube.WorldAnchor;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.modules.ModuleManager;

public enum EnumCube {
    WORLD_ANCHOR(ModuleManager.Module.AUTOMATION, "world.anchor", (CubeClass)new WorldAnchor(), 10.0f, 60.0f),
    CONCRETE_BLOCK(ModuleManager.Module.STRUCTURES, "concrete.block", (CubeClass)new ConcreteBlock(), 3.0f, 15.0f),
    STEEL_BLOCK(ModuleManager.Module.FACTORY, "steel.block", (CubeClass)new SteelBlock(), 5.0f, 15.0f),
    INFERNAL_BRICK(ModuleManager.Module.STRUCTURES, "brick.infernal", (CubeClass)new InfernalBrick(), 3.0f, 15.0f),
    CRUSHED_OBSIDIAN(ModuleManager.Module.FACTORY, "crushed.obsidian", (CubeClass)new CrushedObsidian(), 2.0f, 45.0f),
    SANDY_BRICK(ModuleManager.Module.STRUCTURES, "brick.sandy", (CubeClass)new SandyBrick(), 2.0f, 10.0f);

    public static final EnumCube[] VALUES;
    private final ModuleManager.Module module;
    private final String tag;
    private final CubeClass block;
    private final float hardness;
    private final float resistance;
    private static final List creativeList;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumCube(CubeClass module3, float tag, float block) {
        void resistance;
        void hardness;
        this.module = module3;
        this.tag = (String)tag;
        this.block = (CubeClass)block;
        this.hardness = hardness;
        this.resistance = resistance;
    }

    public static List getCreativeList() {
        return creativeList;
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    public String getTag() {
        return "rc.cube." + this.tag;
    }

    public CubeClass getBlock() {
        return this.block;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && BlockCube.getBlock() != null;
    }

    public static EnumCube fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public ur getItem() {
        return this.getItem(1);
    }

    public ur getItem(int qty) {
        return new ur((amq)BlockCube.getBlock(), qty, this.ordinal());
    }

    static {
        VALUES = EnumCube.values();
        creativeList = new ArrayList();
        creativeList.add(STEEL_BLOCK);
        creativeList.add(CONCRETE_BLOCK);
        creativeList.add(SANDY_BRICK);
        creativeList.add(INFERNAL_BRICK);
        creativeList.add(CRUSHED_OBSIDIAN);
    }
}

