/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render.carts;

import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import railcraft.client.render.LiquidRenderer;
import railcraft.client.render.RenderFakeBlock;
import railcraft.client.render.carts.SubRenderCart;
import railcraft.common.carts.EntityCartTank;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.misc.FakeBlockRenderInfo;

public class SubRenderCartTank
extends SubRenderCart {
    private static final int[] TANK_TEXTURE = new int[]{230, 230, 229, 229, 229, 229};
    private final FakeBlockRenderInfo fakeBlock = new FakeBlockRenderInfo();
    private final FakeBlockRenderInfo fillBlock = new FakeBlockRenderInfo(0.4f, 0.0f, 0.4f, 0.6f, 0.999f, 0.6f);
    private final FakeBlockRenderInfo bucketSign = new FakeBlockRenderInfo();
    private static final float FILTER_SCALE_X = 1.38f;
    private static final float FILTER_SCALE_Y = 0.5f;
    private static final float FILTER_SCALE_Z = 0.5f;

    public SubRenderCartTank() {
        this.bucketSign.template = amq.P;
        this.bucketSign.renderTop = false;
        this.bucketSign.renderBottom = false;
        this.bucketSign.renderEast = false;
        this.bucketSign.renderWest = false;
    }

    @Override
    public void render(py cart, float light, float time) {
        int[] displayLists;
        EntityCartTank cartTank = (EntityCartTank)cart;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        int x = (int)Math.floor(cart.t);
        int y = (int)Math.floor(cart.u);
        int z = (int)Math.floor(cart.v);
        StandardTank tank = cartTank.getTankManager().getTank(0);
        LiquidStack liquid = tank.getLiquid();
        if (liquid != null && liquid.amount > 0 && (displayLists = LiquidRenderer.getLiquidDisplayLists(liquid)) != null) {
            GL11.glPushMatrix();
            String textureFile = liquid.itemID < amq.p.length && amq.p[liquid.itemID] != null ? amq.p[liquid.itemID].getTextureFile() : up.e[liquid.itemID].getTextureFile();
            ForgeHooksClient.bindTexture((String)textureFile, (int)0);
            float cap = tank.getCapacity();
            float level = Math.min((float)liquid.amount, cap) / cap;
            GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
            if (cartTank.isFilling()) {
                this.fillBlock.texture[0] = liquid.itemID < amq.p.length && amq.p[liquid.itemID] != null ? amq.p[liquid.itemID].a(1, liquid.itemMeta) : up.e[liquid.itemID].b(liquid.itemMeta);
                RenderFakeBlock.renderBlockForEntity(this.fillBlock, (ym)cart.p, x, y, z, false, true);
            }
            GL11.glPopMatrix();
        }
        ForgeHooksClient.bindTexture((String)"/railcraft/client/textures/railcraft.png", (int)0);
        this.fakeBlock.texture = TANK_TEXTURE;
        RenderFakeBlock.renderBlockForEntity(this.fakeBlock, (ym)cart.p, x, y, z, true, true);
        ur bucket = cartTank.getFilterItem();
        if (bucket != null && bucket.c > 0) {
            ForgeHooksClient.bindTexture((String)bucket.b().getTextureFile(), (int)0);
            GL11.glPushMatrix();
            GL11.glScalef((float)1.38f, (float)0.5f, (float)0.5f);
            GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
            int meta = bucket.j();
            for (int pass = 0; pass < bucket.b().getRenderPasses(meta); ++pass) {
                int texture = bucket.b().a(meta, pass);
                int color = bucket.b().a(bucket, pass);
                float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float c3 = (float)(color & 0xFF) / 255.0f;
                float dim = 0.7f;
                GL11.glColor4f((float)(c1 * light * dim), (float)(c2 * light * dim), (float)(c3 * light * dim), (float)1.0f);
                baz tess = baz.a;
                tess.c(this.bucketSign.template.e((ym)cart.p, x, y, z));
                this.bucketSign.texture[0] = texture;
                RenderFakeBlock.renderBlockForEntity(this.bucketSign, (ym)cart.p, x, y, z, false, true);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

