/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render.carts;

import java.util.Random;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import railcraft.client.render.RenderFakeBlock;
import railcraft.client.render.carts.CartModelManager;
import railcraft.client.render.carts.SubRenderCartGift;
import railcraft.client.render.carts.SubRenderCartMaintance;
import railcraft.client.render.carts.SubRenderCartTNT;
import railcraft.client.render.carts.SubRenderCartTank;
import railcraft.common.api.carts.ICartRenderInterface;
import railcraft.common.api.carts.ICartTextureInterface;
import railcraft.common.api.carts.IExplosiveCart;
import railcraft.common.carts.EntityCartChest;
import railcraft.common.carts.EntityCartGift;
import railcraft.common.carts.EntityCartTank;
import railcraft.common.carts.IDirectionalCart;
import railcraft.common.carts.MaintanceCartBase;
import railcraft.common.util.misc.FakeBlockRenderInfo;

public class RenderCart
extends bbv {
    private final Random rand = new Random();
    private SubRenderCartTank renderCartTank = new SubRenderCartTank();
    private SubRenderCartTNT renderCartTNT = new SubRenderCartTNT(this);
    private SubRenderCartGift renderCartGift = new SubRenderCartGift(this);
    private SubRenderCartMaintance renderCartMaintance = new SubRenderCartMaintance(this);
    private final FakeBlockRenderInfo fakeBlock = new FakeBlockRenderInfo();

    public RenderCart() {
        this.d = 0.5f;
        this.fakeBlock.texture = new int[6];
    }

    public void renderCart(py cart, double x, double y, double z, float yaw, float time) {
        GL11.glPushMatrix();
        long var10 = (long)cart.k * 493286711L;
        var10 = var10 * var10 * 4392167121L + var10 * 98761L;
        float tx = (((float)(var10 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float ty = (((float)(var10 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float tz = (((float)(var10 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        GL11.glTranslatef((float)tx, (float)ty, (float)tz);
        double mx = cart.T + (cart.t - cart.T) * (double)time;
        double my = cart.U + (cart.u - cart.U) * (double)time;
        double mz = cart.V + (cart.v - cart.V) * (double)time;
        double d6 = 0.3;
        aoj vec3d = cart.a(mx, my, mz);
        float pitch = cart.C + (cart.A - cart.C) * time;
        if (vec3d != null) {
            aoj vec3d1 = cart.a(mx, my, mz, d6);
            aoj vec3d2 = cart.a(mx, my, mz, -d6);
            if (vec3d1 == null) {
                vec3d1 = vec3d;
            }
            if (vec3d2 == null) {
                vec3d2 = vec3d;
            }
            x += vec3d.c - mx;
            y += (vec3d1.d + vec3d2.d) / 2.0 - my;
            z += vec3d.e - mz;
            aoj vec3d3 = vec3d2.c(-vec3d1.c, -vec3d1.d, -vec3d1.e);
            if (vec3d3.b() != 0.0) {
                vec3d3 = vec3d3.a();
                yaw = (float)(Math.atan2(vec3d3.e, vec3d3.c) / Math.PI) * 180.0f;
                pitch = (float)(Math.atan(vec3d3.d) * 73.0);
            }
        }
        if (cart instanceof IDirectionalCart) {
            if ((yaw %= 360.0f) < 0.0f) {
                yaw += 360.0f;
            }
            yaw += 360.0f;
            double serverYaw = cart.z;
            serverYaw += 180.0;
            if ((serverYaw %= 360.0) < 0.0) {
                serverYaw += 360.0;
            }
            if (Math.abs((double)yaw - (serverYaw += 360.0)) > 90.0) {
                yaw += 180.0f;
                pitch = -pitch;
            }
            ((IDirectionalCart)cart).setRenderYaw(yaw);
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        float f3 = (float)cart.j() - time;
        float f4 = (float)cart.i() - time;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 0.0f) {
            float angle = ke.a((float)f3) * f3 * f4 / 10.0f;
            angle = Math.min(angle, 0.8f);
            angle = Math.copySign(angle, cart.k());
            GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float light = cart.c(time);
        light += (1.0f - light) * 0.4f;
        float f5 = 0.75f;
        GL11.glScalef((float)f5, (float)f5, (float)f5);
        GL11.glPushAttrib((int)64);
        if (cart instanceof EntityCartChest) {
            this.renderChestCart(light);
        } else if (cart instanceof EntityCartGift) {
            this.renderCartGift.render(cart, light, time);
        } else if (cart instanceof IExplosiveCart && cart instanceof ICartRenderInterface) {
            this.renderCartTNT.render(cart, light, time);
        } else if (cart instanceof ICartTextureInterface) {
            this.renderFakeBlockInCart((ICartTextureInterface)cart, light);
        } else if (cart instanceof ICartRenderInterface) {
            this.renderBlockInCart((ICartRenderInterface)cart, light);
        } else if (cart instanceof MaintanceCartBase) {
            this.renderCartMaintance.render(cart, light, time);
        } else if (cart instanceof EntityCartTank) {
            this.renderCartTank.render(cart, light, time);
        }
        GL11.glScalef((float)(1.0f / f5), (float)(1.0f / f5), (float)(1.0f / f5));
        GL11.glPopAttrib();
        CartModelManager.render(this, cart, light);
        GL11.glPopMatrix();
    }

    public void a(lq entity, double x, double y, double d2, float yaw, float time) {
        this.renderCart((py)entity, x, y, d2, yaw, time);
    }

    public void bindTexture(String texture) {
        this.a(texture);
    }

    public bbb renderBlocks() {
        return this.c;
    }

    public void renderChestCart(float light) {
        this.a("/terrain.png");
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        this.c.a(amq.ax, 0, light);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)-0.5f);
    }

    public void renderBlockInCart(ICartRenderInterface cart, float light) {
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        amq block = cart.getBlock();
        ForgeHooksClient.bindTexture((String)block.getTextureFile(), (int)0);
        this.c.a(block, cart.getBlockMetadata(), light);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)0.0f);
    }

    public void renderFakeBlockInCart(ICartTextureInterface cart, float light) {
        py entity = (py)cart;
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        GL11.glDisable((int)2896);
        amq block = cart.getBlock();
        ForgeHooksClient.bindTexture((String)block.getTextureFile(), (int)0);
        for (int side = 0; side < 6; ++side) {
            this.fakeBlock.texture[side] = cart.getBlockTextureOnSide(side);
        }
        RenderFakeBlock.renderBlockForEntity(this.fakeBlock, (ym)entity.p, (int)entity.t, (int)entity.u, (int)entity.v, true, true);
        GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)0.0f);
    }
}

