/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import java.util.Random;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import railcraft.common.carts.EntityCartTank;

public class RenderTankCartItem
implements IItemRenderer {
    bce renderItem = new bce();

    public boolean handleRenderType(ur stack, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ur stack, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ur stack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.render(IItemRenderer.ItemRenderType.INVENTORY, stack);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderAsEntity(stack);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glPushMatrix();
            this.renderEquiped(stack, (md)data[1]);
            ur filter = EntityCartTank.getFilterFromCartItem(stack);
            if (filter != null) {
                ForgeHooksClient.bindTexture((String)filter.b().getTextureFile(), (int)0);
                float scale = 0.6f;
                GL11.glScalef((float)scale, (float)scale, (float)1.1f);
                GL11.glTranslatef((float)0.7f, (float)0.0f, (float)0.001f);
                this.renderEquiped(filter, (md)data[1]);
            }
            GL11.glPopMatrix();
        }
    }

    private void renderEquiped(ur stack, md entity) {
        GL11.glPushMatrix();
        baz tessellator = baz.a;
        int meta = stack.j();
        for (int pass = 0; pass < stack.b().getRenderPasses(meta); ++pass) {
            int texture = stack.b().a(meta, pass);
            int color = stack.b().a(stack, pass);
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            if (this.renderItem.a) {
                GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
            }
            float uv1 = ((float)(texture % 16 * 16) + 0.0f) / 256.0f;
            float uv2 = ((float)(texture % 16 * 16) + 15.99f) / 256.0f;
            float uv3 = ((float)(texture / 16 * 16) + 0.0f) / 256.0f;
            float uv4 = ((float)(texture / 16 * 16) + 15.99f) / 256.0f;
            this.renderItemIn3D(tessellator, uv2, uv3, uv1, uv4);
        }
        GL11.glPopMatrix();
    }

    private void renderItemIn3D(baz par1Tessellator, float par2, float par3, float par4, float par5) {
        float var11;
        float var10;
        float var9;
        int var8;
        float var6 = 1.0f;
        float var7 = 0.0625f;
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 0.0f, 1.0f);
        par1Tessellator.a(0.0, 0.0, 0.0, (double)par2, (double)par5);
        par1Tessellator.a((double)var6, 0.0, 0.0, (double)par4, (double)par5);
        par1Tessellator.a((double)var6, 1.0, 0.0, (double)par4, (double)par3);
        par1Tessellator.a(0.0, 1.0, 0.0, (double)par2, (double)par3);
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 0.0f, -1.0f);
        par1Tessellator.a(0.0, 1.0, (double)(0.0f - var7), (double)par2, (double)par3);
        par1Tessellator.a((double)var6, 1.0, (double)(0.0f - var7), (double)par4, (double)par3);
        par1Tessellator.a((double)var6, 0.0, (double)(0.0f - var7), (double)par4, (double)par5);
        par1Tessellator.a(0.0, 0.0, (double)(0.0f - var7), (double)par2, (double)par5);
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(-1.0f, 0.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par2 + (par4 - par2) * var9 - 0.001953125f;
            var11 = var6 * var9;
            par1Tessellator.a((double)var11, 0.0, (double)(0.0f - var7), (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 0.0, 0.0, (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 1.0, 0.0, (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 1.0, (double)(0.0f - var7), (double)var10, (double)par3);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(1.0f, 0.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par2 + (par4 - par2) * var9 - 0.001953125f;
            var11 = var6 * var9 + 0.0625f;
            par1Tessellator.a((double)var11, 1.0, (double)(0.0f - var7), (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 1.0, 0.0, (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 0.0, 0.0, (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 0.0, (double)(0.0f - var7), (double)var10, (double)par5);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 1.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par5 + (par3 - par5) * var9 - 0.001953125f;
            var11 = var6 * var9 + 0.0625f;
            par1Tessellator.a(0.0, (double)var11, 0.0, (double)par2, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, 0.0, (double)par4, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, (double)(0.0f - var7), (double)par4, (double)var10);
            par1Tessellator.a(0.0, (double)var11, (double)(0.0f - var7), (double)par2, (double)var10);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, -1.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par5 + (par3 - par5) * var9 - 0.001953125f;
            var11 = var6 * var9;
            par1Tessellator.a((double)var6, (double)var11, 0.0, (double)par4, (double)var10);
            par1Tessellator.a(0.0, (double)var11, 0.0, (double)par2, (double)var10);
            par1Tessellator.a(0.0, (double)var11, (double)(0.0f - var7), (double)par2, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, (double)(0.0f - var7), (double)par4, (double)var10);
        }
        par1Tessellator.a();
    }

    private void renderAsEntity(ur item) {
        GL11.glPushMatrix();
        int iterations = item.a;
        if (iterations > 3) {
            iterations = 3;
        }
        Random rand = new Random(187L);
        for (int ii = 0; ii < iterations; ++ii) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f - bbu.a.i), (float)0.0f, (float)1.0f, (float)0.0f);
            if (ii > 0) {
                float var12 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var13 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var14 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                GL11.glTranslatef((float)var12, (float)var13, (float)var14);
            }
            GL11.glTranslatef((float)0.5f, (float)0.8f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
            this.render(IItemRenderer.ItemRenderType.ENTITY, item);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void render(IItemRenderer.ItemRenderType type, ur stack) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        ForgeHooksClient.bindTexture((String)stack.b().getTextureFile(), (int)0);
        int cartTexture = stack.c();
        this.renderItem.a(0, 0, cartTexture % 16 * 16, cartTexture / 16 * 16, 16, 16);
        ur filter = EntityCartTank.getFilterFromCartItem(stack);
        if (filter != null) {
            ForgeHooksClient.bindTexture((String)filter.b().getTextureFile(), (int)0);
            int meta = filter.j();
            float scale = 0.6f;
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)11.0f, (float)0.0f);
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            }
            for (int pass = 0; pass < filter.b().getRenderPasses(meta); ++pass) {
                int bucketTexture = filter.b().a(meta, pass);
                int color = filter.b().a(filter, pass);
                float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float c3 = (float)(color & 0xFF) / 255.0f;
                if (this.renderItem.a) {
                    GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
                }
                this.renderItem.a(0, 0, bucketTexture % 16 * 16, bucketTexture / 16 * 16, 16, 16);
            }
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

