/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import railcraft.client.render.ICombinedRenderer;
import railcraft.client.render.RenderTools;
import railcraft.common.api.tracks.ITrackSwitch;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.signals.BlockSignal;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.TileSwitchBase;

public class RenderSwitch
implements ICombinedRenderer {
    private static final float PIX = 0.0625f;
    private static final int LEVER_HEIGHT = 10;
    private EnumSignal type;

    public RenderSwitch(EnumSignal str) {
        this.type = str;
    }

    @Override
    public void renderBlock(bbb renderblocks, ym world, int x, int y, int z, amq block) {
        BlockSignal structure = (BlockSignal)block;
        TileSwitchBase tile = (TileSwitchBase)world.q(x, y, z);
        float f = 0.25f;
        float f1 = 0.75f;
        structure.a(f, 0.0f, f, f1, 0.3125f, f1);
        RenderTools.renderStandardBlock(renderblocks, (amq)structure, x, y, z);
        f = 0.4375f;
        f1 = 0.5625f;
        structure.a(f, 0.0f, f, f1, 0.5f, f1);
        RenderTools.renderStandardBlock(renderblocks, (amq)structure, x, y, z);
        structure.a(f, 0.6875f, f, f1, 0.75f, f1);
        RenderTools.renderStandardBlock(renderblocks, (amq)structure, x, y, z);
        if (tile.getFacing() == 2 || tile.getFacing() == 3) {
            structure.a(0.375f, 0.0f, 0.0f, 0.625f, 0.1875f, 1.0f);
            RenderTools.renderStandardBlock(renderblocks, (amq)structure, x, y, z);
        } else {
            structure.a(0.0f, 0.0f, 0.375f, 1.0f, 0.1875f, 0.625f);
            RenderTools.renderStandardBlock(renderblocks, (amq)structure, x, y, z);
        }
        ITrackSwitch track = tile.getSwitchTrack();
        if (track == null) {
            this.type.setUseAltTextures(true);
            this.type.setAltTextureOffset(1);
            this.renderTargetNorthSouth(renderblocks, (amq)structure, x, y, z);
            this.type.setAltTextureOffset(2);
            this.renderTargetEastWest(renderblocks, (amq)structure, x, y, z);
            this.type.setUseAltTextures(false);
            return;
        }
        this.type.setUseAltTextures(true);
        this.type.setAltTextureOffset(1);
        ITrackSwitch.ArrowDirection whiteArrow = track.getWhiteSignDirection();
        this.renderTarget(whiteArrow, renderblocks, block, x, y, z);
        this.type.setAltTextureOffset(2);
        ITrackSwitch.ArrowDirection redArrow = track.getRedSignDirection();
        this.renderTarget(redArrow, renderblocks, block, x, y, z);
        this.type.setUseAltTextures(false);
        if (this.type == EnumSignal.SWITCH_LEVER) {
            switch (tile.getFacing()) {
                case 2: {
                    structure.a(0.4375f, 0.0f, 0.875f, 0.5625f, 0.625f, 1.0f);
                    break;
                }
                case 3: {
                    structure.a(0.4375f, 0.0f, 0.0f, 0.5625f, 0.625f, 0.125f);
                    break;
                }
                case 4: {
                    structure.a(0.875f, 0.0f, 0.4375f, 1.0f, 0.625f, 0.5625f);
                    break;
                }
                case 5: {
                    structure.a(0.0f, 0.0f, 0.4375f, 0.125f, 0.625f, 0.5625f);
                }
            }
            RenderTools.renderStandardBlock(renderblocks, (amq)structure, x, y, z);
        }
        structure.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderTarget(ITrackSwitch.ArrowDirection arrow, bbb renderblocks, amq block, int x, int y, int z) {
        switch (arrow) {
            case NORTH: {
                this.renderTargetNorth(renderblocks, block, x, y, z);
                break;
            }
            case SOUTH: {
                this.renderTargetSouth(renderblocks, block, x, y, z);
                break;
            }
            case EAST: {
                this.renderTargetEast(renderblocks, block, x, y, z);
                break;
            }
            case WEST: {
                this.renderTargetWest(renderblocks, block, x, y, z);
                break;
            }
            case NORTH_SOUTH: {
                this.renderTargetNorthSouth(renderblocks, block, x, y, z);
                break;
            }
            case EAST_WEST: {
                this.renderTargetEastWest(renderblocks, block, x, y, z);
            }
        }
    }

    private void renderTargetNorthSouth(bbb renderblocks, amq block, int i, int j, int k) {
        block.a(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
    }

    private void renderTargetEastWest(bbb renderblocks, amq block, int i, int j, int k) {
        block.a(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
    }

    private void renderTargetNorth(bbb renderblocks, amq block, int i, int j, int k) {
        block.a(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.5f, 0.5625f, 0.1875f, 0.5625f, 0.625f, 0.25f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.4375f, 0.5f, 0.75f, 0.5f, 0.5625f, 0.8125f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.4375f, 0.625f, 0.75f, 0.5f, 0.6875f, 0.8125f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
    }

    private void renderTargetSouth(bbb renderblocks, amq block, int i, int j, int k) {
        block.a(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.4375f, 0.5625f, 0.75f, 0.5f, 0.625f, 0.8125f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.5f, 0.5f, 0.1875f, 0.5625f, 0.5625f, 0.25f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.5f, 0.625f, 0.1875f, 0.5625f, 0.6875f, 0.25f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
    }

    private void renderTargetEast(bbb renderblocks, amq block, int i, int j, int k) {
        block.a(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.1875f, 0.5625f, 0.4375f, 0.25f, 0.625f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.75f, 0.5f, 0.5f, 0.8125f, 0.5625f, 0.5625f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.75f, 0.625f, 0.5f, 0.8125f, 0.6875f, 0.5625f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
    }

    private void renderTargetWest(bbb renderblocks, amq block, int i, int j, int k) {
        block.a(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.75f, 0.5625f, 0.5f, 0.8125f, 0.625f, 0.5625f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.1875f, 0.5f, 0.4375f, 0.25f, 0.5625f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        block.a(0.1875f, 0.625f, 0.4375f, 0.25f, 0.6875f, 0.5f);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
    }

    @Override
    public void renderItem(bbb renderblocks, ur item, IItemRenderer.ItemRenderType renderType) {
        switch (renderType) {
            case EQUIPPED: 
            case ENTITY: {
                float scale = 1.5f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
            }
        }
        BlockSignal block = (BlockSignal)RailcraftBlocks.getBlockSignal();
        float f = 0.25f;
        float f1 = 0.75f;
        block.a(f, 0.0f, f, f1, 0.3125f, f1);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        f = 0.4375f;
        f1 = 0.5625f;
        block.a(f, 0.0f, f, f1, 0.5f, f1);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        block.a(f, 0.6875f, f, f1, 0.75f, f1);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        block.a(0.375f, 0.0f, 0.0f, 0.625f, 0.1875f, 1.0f);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        this.type.setUseAltTextures(true);
        this.type.setAltTextureOffset(2);
        block.a(0.25f, 0.5f, 0.4375f, 0.5f, 0.6875f, 0.5f);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        block.a(0.5f, 0.5f, 0.5f, 0.75f, 0.6875f, 0.5625f);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        block.a(0.75f, 0.5625f, 0.5f, 0.8125f, 0.625f, 0.5625f);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        block.a(0.1875f, 0.5f, 0.4375f, 0.25f, 0.5625f, 0.5f);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        block.a(0.1875f, 0.625f, 0.4375f, 0.25f, 0.6875f, 0.5f);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        this.type.setUseAltTextures(false);
        this.type.setUseAltTextures(true);
        this.type.setAltTextureOffset(1);
        block.a(0.5f, 0.5f, 0.25f, 0.5625f, 0.6875f, 0.5f);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        block.a(0.4375f, 0.5f, 0.5f, 0.5f, 0.6875f, 0.75f);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        this.type.setUseAltTextures(false);
        if (this.type == EnumSignal.SWITCH_LEVER) {
            block.a(0.4375f, 0.0f, 0.0f, 0.5625f, 0.625f, 0.125f);
            RenderTools.renderBlockOnInventory(renderblocks, (amq)block, this.type.ordinal(), 1.0f);
        }
        block.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

