/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import railcraft.client.render.IInvRenderer;
import railcraft.client.render.models.engine.ModelEngineBase;
import railcraft.client.render.models.engine.ModelEngineFrame;
import railcraft.client.render.models.engine.ModelEnginePiston;
import railcraft.client.render.models.engine.ModelEngineTrunk;
import railcraft.common.blocks.machine.beta.TileEngine;

public class RenderPneumaticEngine
extends bdx
implements IInvRenderer {
    private ModelEngineFrame frame = new ModelEngineFrame();
    private ModelEngineBase base = new ModelEngineBase();
    private ModelEngineTrunk trunk = new ModelEngineTrunk();
    private ModelEnginePiston piston = new ModelEnginePiston();
    private String texture;
    private static float[] angleMap = new float[6];

    public RenderPneumaticEngine(String texture) {
        this.texture = texture;
    }

    @Override
    public void renderItem(bbb render, ur item, IItemRenderer.ItemRenderType renderType) {
        this.render(TileEngine.EnergyStage.BLUE, 0.25f, ForgeDirection.UP, 0.0, 0.0, 0.0);
    }

    public void a(any tileentity, double x, double y, double z, float f) {
        TileEngine engine = (TileEngine)tileentity;
        if (engine != null) {
            this.render(engine.getEnergyStage(), engine.getProgress(), engine.getOrientation(), x, y, z);
        }
    }

    private void render(TileEngine.EnergyStage energy, float progress, ForgeDirection orientation, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{orientation.offsetX, orientation.offsetY, orientation.offsetZ};
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                angle[2] = angleMap[orientation.ordinal()];
                break;
            }
            case SOUTH: 
            case NORTH: {
                angle[0] = angleMap[orientation.ordinal()];
            }
        }
        this.base.rotate(angle[0], angle[1], angle[2]);
        this.trunk.rotate(angle[0], angle[1], angle[2]);
        this.frame.rotate(angle[0], angle[1], angle[2]);
        this.piston.rotate(angle[0], angle[1], angle[2]);
        float factor = 0.0625f;
        ForgeHooksClient.bindTexture((String)this.texture, (int)0);
        this.trunk.render(energy, factor);
        this.base.render(factor);
        float step = (double)progress > 0.5 ? 7.99f - (progress - 0.5f) * 2.0f * 7.99f : progress * 2.0f * 7.99f;
        float frameTrans = step / 16.0f;
        GL11.glTranslatef((float)(translate[0] * frameTrans), (float)(translate[1] * frameTrans), (float)(translate[2] * frameTrans));
        this.frame.render(factor);
        GL11.glTranslatef((float)(-translate[0] * frameTrans), (float)(-translate[1] * frameTrans), (float)(-translate[2] * frameTrans));
        float pistonPrep = 0.01f;
        GL11.glTranslatef((float)(-translate[0] * pistonPrep), (float)(-translate[1] * pistonPrep), (float)(-translate[2] * pistonPrep));
        float pistonTrans = 0.125f;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.piston.render(factor);
            GL11.glTranslatef((float)(translate[0] * pistonTrans), (float)(translate[1] * pistonTrans), (float)(translate[2] * pistonTrans));
            i += 2;
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    static {
        RenderPneumaticEngine.angleMap[ForgeDirection.EAST.ordinal()] = -1.5707964f;
        RenderPneumaticEngine.angleMap[ForgeDirection.WEST.ordinal()] = 1.5707964f;
        RenderPneumaticEngine.angleMap[ForgeDirection.UP.ordinal()] = 0.0f;
        RenderPneumaticEngine.angleMap[ForgeDirection.DOWN.ordinal()] = (float)Math.PI;
        RenderPneumaticEngine.angleMap[ForgeDirection.SOUTH.ordinal()] = 1.5707964f;
        RenderPneumaticEngine.angleMap[ForgeDirection.NORTH.ordinal()] = -1.5707964f;
    }
}

