/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import railcraft.client.render.LiquidRenderer;
import railcraft.client.render.RenderFakeBlock;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.beta.TileTankIron;
import railcraft.common.blocks.machine.beta.TileTankIronValve;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.misc.FakeBlockRenderInfo;

public class RenderIronTank
extends bdx {
    private static final FakeBlockRenderInfo fillBlock = new FakeBlockRenderInfo();

    public RenderIronTank() {
        float pix = 0.0625f;
        RenderIronTank.fillBlock.minX = 5.0f * pix;
        RenderIronTank.fillBlock.minZ = 5.0f * pix;
        RenderIronTank.fillBlock.maxX = 11.0f * pix;
        RenderIronTank.fillBlock.maxZ = 11.0f * pix;
    }

    private int bindLiquidTexture(LiquidStack liquid) {
        RenderIronTank.fillBlock.texture = new int[]{liquid.asItemStack().c()};
        return LiquidRenderer.bindLiquidTexture(liquid);
    }

    private float getVerticalScaleSide(TileMultiBlock tile) {
        int y = tile.getPatternPositionY();
        if (!RailcraftConfig.allowTankStacking()) {
            --y;
        }
        return (float)y - 0.3125f;
    }

    private int getTankHeight(TileMultiBlock tile) {
        int height = tile.getPattern().getPatternHeight();
        if (!RailcraftConfig.allowTankStacking()) {
            height -= 2;
        }
        return height;
    }

    private void draw() {
        this.preGL();
        RenderFakeBlock.renderBlockForEntity(fillBlock, null, 0, 0, 0, false, true);
        this.postGL();
    }

    private void preGL() {
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
    }

    private void postGL() {
        GL11.glPopAttrib();
    }

    public void a(any tile, double x, double y, double z, float f) {
        TileTankIron ironTank;
        TileTankIronValve valve;
        if (!((TileMultiBlock)tile).isStructureValid()) {
            return;
        }
        if (tile instanceof TileTankIronValve && (valve = (TileTankIronValve)tile).isFilling()) {
            TankManager tMan = valve.getTankManager();
            LiquidStack liquid = null;
            if (tMan != null) {
                liquid = tMan.getTank(0).getLiquid();
            }
            if (liquid != null && liquid.amount > 0 && up.e[liquid.itemID] != null) {
                float yOffset;
                GL11.glPushMatrix();
                GL11.glDisable((int)2896);
                if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY() - 1, valve.getPatternPositionZ()) == 'A') {
                    this.bindLiquidTexture(liquid);
                    int height = this.getTankHeight(valve);
                    yOffset = (float)height / 2.0f;
                    float vScale = (float)height - 2.0f;
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset - (float)height + 1.0f), (float)((float)z + 0.5f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX() - 1, valve.getPatternPositionY(), valve.getPatternPositionZ()) == 'A') {
                    this.bindLiquidTexture(liquid);
                    float vScale = this.getVerticalScaleSide(valve);
                    yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                    GL11.glTranslatef((float)((float)x - 0.5f + 0.3125f), (float)((float)y + yOffset), (float)((float)z + 0.5f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX() + 1, valve.getPatternPositionY(), valve.getPatternPositionZ()) == 'A') {
                    this.bindLiquidTexture(liquid);
                    float vScale = this.getVerticalScaleSide(valve);
                    yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                    GL11.glTranslatef((float)((float)x + 1.5f - 0.3125f), (float)((float)y + yOffset), (float)((float)z + 0.5f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY(), valve.getPatternPositionZ() - 1) == 'A') {
                    this.bindLiquidTexture(liquid);
                    float vScale = this.getVerticalScaleSide(valve);
                    yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset), (float)((float)z - 0.5f + 0.3125f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY(), valve.getPatternPositionZ() + 1) == 'A') {
                    this.bindLiquidTexture(liquid);
                    float vScale = this.getVerticalScaleSide(valve);
                    yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset), (float)((float)z + 1.5f - 0.3125f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                }
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
            }
        }
        if (!(ironTank = (TileTankIron)tile).isMaster() || ironTank.r()) {
            return;
        }
        int height = this.getTankHeight(ironTank);
        float yOffset = (float)height / 2.0f;
        float vScale = height - 2;
        float hScale = ironTank.getPattern().getPatternWidthX() - 2;
        TankManager tankManager = ironTank.getTankManager();
        if (tankManager == null) {
            return;
        }
        StandardTank tank = tankManager.getTank(0);
        if (tank == null) {
            return;
        }
        LiquidStack liquid = tank.getLiquid();
        if (liquid != null && liquid.amount > 0 && up.e[liquid.itemID] != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset + 0.01f), (float)((float)z + 0.5f));
            this.preGL();
            GL11.glScalef((float)hScale, (float)vScale, (float)hScale);
            int[] displayLists = LiquidRenderer.getLiquidDisplayLists(liquid);
            if (displayLists != null) {
                GL11.glPushMatrix();
                this.bindLiquidTexture(liquid);
                float cap = tank.getCapacity();
                float level = Math.min((float)liquid.amount, cap) / cap;
                GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
                GL11.glPopMatrix();
            }
            this.postGL();
            GL11.glPopMatrix();
        }
    }
}

