/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import railcraft.client.render.RenderTools;
import railcraft.common.blocks.aesthetics.cube.BlockCube;
import railcraft.common.util.misc.FakeBlockRenderInfo;

public class RenderFakeBlock {
    public static void renderBlockForEntity(FakeBlockRenderInfo info, ym blockAccess, int i, int j, int k, boolean doLight, boolean doTessellating) {
        RenderFakeBlock.renderBlock(info, blockAccess, -0.5, -0.5, -0.5, i, j, k, doLight, doTessellating);
    }

    public static void renderAsBlock(FakeBlockRenderInfo info, bbb render, ym blockAccess, double x, double y, double z) {
        BlockCube block = BlockCube.getBlock();
        if (block != null) {
            block.setTextureOveride(info);
            block.a(info.minX, info.minY, info.minZ, info.maxX, info.maxY, info.maxZ);
            RenderTools.renderStandardBlock(render, block, (int)x, (int)y, (int)z);
            block.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            block.setTextureOveride(null);
        } else {
            RenderFakeBlock.renderBlock(info, blockAccess, x, y, z, true, false);
        }
    }

    public static void renderBlock(FakeBlockRenderInfo info, ym blockAccess, double x, double y, double z, boolean doLight, boolean doTessellating) {
        RenderFakeBlock.renderBlock(info, blockAccess, x, y, z, (int)x, (int)y, (int)z, doLight, doTessellating);
    }

    public static void renderBlock(FakeBlockRenderInfo info, ym blockAccess, double x, double y, double z, int lightX, int lightY, int lightZ, boolean doLight, boolean doTessellating) {
        float lightBottom = 0.5f;
        float lightTop = 1.0f;
        float lightEastWest = 0.8f;
        float lightNorthSouth = 0.6f;
        baz tessellator = baz.a;
        if (blockAccess == null) {
            doLight = false;
        }
        if (doTessellating && !tessellator.z) {
            tessellator.b();
        }
        if (info.brightness >= 0) {
            tessellator.c(info.brightness);
        }
        float light = 0.0f;
        if (doLight) {
            if (info.light < 0.0f) {
                light = info.template.f(blockAccess, lightX, lightY, lightZ);
                light += (1.0f - light) * 0.4f;
            } else {
                light = info.light;
            }
            int brightness = 0;
            brightness = info.brightness < 0 ? info.template.e(blockAccess, lightX, lightY, lightZ) : info.brightness;
            tessellator.c(brightness);
            tessellator.a(lightBottom * light, lightBottom * light, lightBottom * light);
        }
        if (info.renderBottom) {
            RenderFakeBlock.renderBottomFace(info, x, y, z, info.getBlockTextureFromSide(0));
        }
        if (doLight) {
            tessellator.a(lightTop * light, lightTop * light, lightTop * light);
        }
        if (info.renderTop) {
            RenderFakeBlock.renderTopFace(info, x, y, z, info.getBlockTextureFromSide(1));
        }
        if (doLight) {
            tessellator.a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderWest) {
            RenderFakeBlock.renderEastFace(info, x, y, z, info.getBlockTextureFromSide(2));
        }
        if (doLight) {
            tessellator.a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderEast) {
            RenderFakeBlock.renderWestFace(info, x, y, z, info.getBlockTextureFromSide(3));
        }
        if (doLight) {
            tessellator.a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderNorth) {
            RenderFakeBlock.renderNorthFace(info, x, y, z, info.getBlockTextureFromSide(4));
        }
        if (doLight) {
            tessellator.a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSouth) {
            RenderFakeBlock.renderSouthFace(info, x, y, z, info.getBlockTextureFromSide(5));
        }
        if (doTessellating && tessellator.z) {
            tessellator.a();
        }
    }

    public static void renderBottomFace(FakeBlockRenderInfo info, double d, double d1, double d2, int i) {
        baz tessellator = baz.a;
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + (double)info.minX * 16.0) / 256.0;
        double d4 = ((double)j + (double)info.maxX * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + (double)info.minZ * 16.0) / 256.0;
        double d6 = ((double)k + (double)info.maxZ * 16.0 - 0.01) / 256.0;
        if ((double)info.minX < 0.0 || (double)info.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if ((double)info.minZ < 0.0 || (double)info.maxZ > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d7 = d + (double)info.minX;
        double d8 = d + (double)info.maxX;
        double d9 = d1 + (double)info.minY;
        double d10 = d2 + (double)info.minZ;
        double d11 = d2 + (double)info.maxZ;
        tessellator.a(d7, d9, d11, d3, d6);
        tessellator.a(d7, d9, d10, d3, d5);
        tessellator.a(d8, d9, d10, d4, d5);
        tessellator.a(d8, d9, d11, d4, d6);
    }

    public static void renderTopFace(FakeBlockRenderInfo info, double d, double d1, double d2, int i) {
        baz tessellator = baz.a;
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + (double)info.minX * 16.0) / 256.0;
        double d4 = ((double)j + (double)info.maxX * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + (double)info.minZ * 16.0) / 256.0;
        double d6 = ((double)k + (double)info.maxZ * 16.0 - 0.01) / 256.0;
        if ((double)info.minX < 0.0 || (double)info.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if ((double)info.minZ < 0.0 || (double)info.maxZ > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d7 = d + (double)info.minX;
        double d8 = d + (double)info.maxX;
        double d9 = d1 + (double)info.maxY;
        double d10 = d2 + (double)info.minZ;
        double d11 = d2 + (double)info.maxZ;
        tessellator.a(d8, d9, d11, d4, d6);
        tessellator.a(d8, d9, d10, d4, d5);
        tessellator.a(d7, d9, d10, d3, d5);
        tessellator.a(d7, d9, d11, d3, d6);
    }

    public static void renderEastFace(FakeBlockRenderInfo info, double d, double d1, double d2, int i) {
        baz tessellator = baz.a;
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + (double)info.minX * 16.0) / 256.0;
        double d4 = ((double)j + (double)info.maxX * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + (double)info.minY * 16.0) / 256.0;
        double d6 = ((double)k + (double)info.maxY * 16.0 - 0.01) / 256.0;
        if ((double)info.minX < 0.0 || (double)info.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if ((double)info.minY < 0.0 || (double)info.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + (double)info.minX;
        double d9 = d + (double)info.maxX;
        double d10 = d1 + (double)info.minY;
        double d11 = d1 + (double)info.maxY;
        double d12 = d2 + (double)info.minZ;
        tessellator.a(d8, d11, d12, d4, d5);
        tessellator.a(d9, d11, d12, d3, d5);
        tessellator.a(d9, d10, d12, d3, d6);
        tessellator.a(d8, d10, d12, d4, d6);
    }

    public static void renderWestFace(FakeBlockRenderInfo info, double d, double d1, double d2, int i) {
        baz tessellator = baz.a;
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + (double)info.minX * 16.0) / 256.0;
        double d4 = ((double)j + (double)info.maxX * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + (double)info.minY * 16.0) / 256.0;
        double d6 = ((double)k + (double)info.maxY * 16.0 - 0.01) / 256.0;
        if ((double)info.minX < 0.0 || (double)info.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if ((double)info.minY < 0.0 || (double)info.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + (double)info.minX;
        double d9 = d + (double)info.maxX;
        double d10 = d1 + (double)info.minY;
        double d11 = d1 + (double)info.maxY;
        double d12 = d2 + (double)info.maxZ;
        tessellator.a(d8, d11, d12, d3, d5);
        tessellator.a(d8, d10, d12, d3, d6);
        tessellator.a(d9, d10, d12, d4, d6);
        tessellator.a(d9, d11, d12, d4, d5);
    }

    public static void renderNorthFace(FakeBlockRenderInfo info, double d, double d1, double d2, int i) {
        baz tessellator = baz.a;
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + (double)info.minZ * 16.0) / 256.0;
        double d4 = ((double)j + (double)info.maxZ * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + (double)info.minY * 16.0) / 256.0;
        double d6 = ((double)k + (double)info.maxY * 16.0 - 0.01) / 256.0;
        if ((double)info.minZ < 0.0 || (double)info.maxZ > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if ((double)info.minY < 0.0 || (double)info.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + (double)info.minX;
        double d9 = d1 + (double)info.minY;
        double d10 = d1 + (double)info.maxY;
        double d11 = d2 + (double)info.minZ;
        double d12 = d2 + (double)info.maxZ;
        tessellator.a(d8, d10, d12, d4, d5);
        tessellator.a(d8, d10, d11, d3, d5);
        tessellator.a(d8, d9, d11, d3, d6);
        tessellator.a(d8, d9, d12, d4, d6);
    }

    public static void renderSouthFace(FakeBlockRenderInfo info, double d, double d1, double d2, int i) {
        baz tessellator = baz.a;
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + (double)info.minZ * 16.0) / 256.0;
        double d4 = ((double)j + (double)info.maxZ * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + (double)info.minY * 16.0) / 256.0;
        double d6 = ((double)k + (double)info.maxY * 16.0 - 0.01) / 256.0;
        if ((double)info.minZ < 0.0 || (double)info.maxZ > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if ((double)info.minY < 0.0 || (double)info.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + (double)info.maxX;
        double d9 = d1 + (double)info.minY;
        double d10 = d1 + (double)info.maxY;
        double d11 = d2 + (double)info.minZ;
        double d12 = d2 + (double)info.maxZ;
        tessellator.a(d8, d9, d12, d3, d6);
        tessellator.a(d8, d9, d11, d4, d6);
        tessellator.a(d8, d10, d11, d4, d5);
        tessellator.a(d8, d10, d12, d3, d5);
    }
}

