/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import java.util.Map;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import railcraft.client.render.RenderFakeBlock;
import railcraft.common.util.inventory.ItemStackMap;
import railcraft.common.util.misc.FakeBlockRenderInfo;

public class LiquidRenderer {
    private static Map stage = new ItemStackMap();
    public static final int DISPLAY_STAGES = 100;
    private static final FakeBlockRenderInfo liquidBlock = new FakeBlockRenderInfo();

    public static int bindLiquidTexture(LiquidStack liquid) {
        int textureIndex;
        String textureFile;
        if (liquid == null || liquid.amount <= 0 || liquid.itemID <= 0) {
            return -1;
        }
        if (liquid.itemID < amq.p.length && amq.p[liquid.itemID] != null) {
            textureFile = amq.p[liquid.itemID].getTextureFile();
            textureIndex = amq.p[liquid.itemID].a(1, liquid.itemMeta);
        } else if (up.e[liquid.itemID] != null) {
            textureFile = up.e[liquid.itemID].getTextureFile();
            textureIndex = up.e[liquid.itemID].b(liquid.itemMeta);
        } else {
            return -1;
        }
        ForgeHooksClient.bindTexture((String)textureFile, (int)0);
        return textureIndex;
    }

    public static int[] getLiquidDisplayLists(LiquidStack liquid) {
        if (liquid == null) {
            return null;
        }
        ur stack = liquid.asItemStack();
        int[] diplayLists = (int[])stage.get(stack);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        if (liquid.itemID < amq.p.length && amq.p[liquid.itemID] != null) {
            LiquidRenderer.liquidBlock.texture[0] = amq.p[liquid.itemID].a(1, liquid.itemMeta);
        } else if (up.e[liquid.itemID] != null) {
            LiquidRenderer.liquidBlock.texture[0] = stack.c();
        } else {
            return null;
        }
        stage.put(stack, diplayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        int color = stack.b().a(stack, 0);
        float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float c3 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = arx.a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            LiquidRenderer.liquidBlock.minX = 0.01f;
            LiquidRenderer.liquidBlock.minY = 0.0f;
            LiquidRenderer.liquidBlock.minZ = 0.01f;
            LiquidRenderer.liquidBlock.maxX = 0.99f;
            LiquidRenderer.liquidBlock.maxY = (float)s / 100.0f;
            LiquidRenderer.liquidBlock.maxZ = 0.99f;
            RenderFakeBlock.renderBlockForEntity(liquidBlock, null, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return diplayLists;
    }
}

