/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.gui;

import java.util.ArrayList;
import railcraft.client.gui.EntityGui;
import railcraft.client.gui.GuiTools;
import railcraft.client.gui.buttons.GuiToggleButtonSmall;
import railcraft.common.carts.EntityLocomotive;
import railcraft.common.carts.EntityLocomotiveSteam;
import railcraft.common.gui.containers.ContainerLocomotiveSteam;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.network.PacketBuilder;

public class GuiLocomotiveSteam
extends EntityGui {
    private final EntityLocomotiveSteam loco;
    private GuiToggleButtonSmall running;
    private GuiToggleButtonSmall idle;
    private GuiToggleButtonSmall shutdown;
    private GuiToggleButtonSmall slowest;
    private GuiToggleButtonSmall slower;
    private GuiToggleButtonSmall slow;
    private GuiToggleButtonSmall max;
    private EntityLocomotive.LocoMode mode;
    private EntityLocomotive.LocoSpeed speed;

    public GuiLocomotiveSteam(qw inv, EntityLocomotiveSteam loco) {
        super((lq)loco, new ContainerLocomotiveSteam(inv, loco), "/railcraft/client/textures/gui/gui_locomotive_steam.png");
        this.c = 205;
        this.loco = loco;
        this.mode = loco.getMode();
        this.speed = loco.getSpeed();
    }

    public void A_() {
        super.A_();
        if (this.loco == null) {
            return;
        }
        this.i.clear();
        int w = (this.g - this.b) / 2;
        int h = (this.h - this.c) / 2;
        ArrayList<GuiToggleButtonSmall> buttons = new ArrayList<GuiToggleButtonSmall>();
        this.running = new GuiToggleButtonSmall(0, 0, h + 76, 55, RailcraftLanguage.translate("gui.locomotive.mode.running"), this.mode == EntityLocomotive.LocoMode.RUNNING);
        buttons.add(this.running);
        this.idle = new GuiToggleButtonSmall(1, 0, h + 76, 45, RailcraftLanguage.translate("gui.locomotive.mode.idle"), this.mode == EntityLocomotive.LocoMode.IDLE);
        buttons.add(this.idle);
        this.shutdown = new GuiToggleButtonSmall(2, 0, h + 76, 55, RailcraftLanguage.translate("gui.locomotive.mode.shutdown"), this.mode == EntityLocomotive.LocoMode.SHUTDOWN);
        buttons.add(this.shutdown);
        GuiTools.newButtonRowAuto(this.i, w + 3, 171, buttons);
        ArrayList<GuiToggleButtonSmall> speedButtons = new ArrayList<GuiToggleButtonSmall>();
        this.slowest = new GuiToggleButtonSmall(3, 0, h + 93, 12, ">", this.speed == EntityLocomotive.LocoSpeed.SLOWEST);
        speedButtons.add(this.slowest);
        this.slower = new GuiToggleButtonSmall(4, 0, h + 93, 17, ">>", this.speed == EntityLocomotive.LocoSpeed.SLOWER);
        speedButtons.add(this.slower);
        this.slow = new GuiToggleButtonSmall(5, 0, h + 93, 22, ">>>", this.speed == EntityLocomotive.LocoSpeed.SLOW);
        speedButtons.add(this.slow);
        this.max = new GuiToggleButtonSmall(6, 0, h + 93, 27, ">>>>", this.speed == EntityLocomotive.LocoSpeed.MAX);
        speedButtons.add(this.max);
        GuiTools.newButtonRow(this.i, w + 44, 4, speedButtons);
    }

    protected void a(atb guibutton) {
        if (this.loco == null) {
            return;
        }
        switch (guibutton.f) {
            case 0: {
                this.mode = EntityLocomotive.LocoMode.RUNNING;
                break;
            }
            case 1: {
                this.mode = EntityLocomotive.LocoMode.IDLE;
                break;
            }
            case 2: {
                this.mode = EntityLocomotive.LocoMode.SHUTDOWN;
                break;
            }
            case 3: {
                this.speed = EntityLocomotive.LocoSpeed.SLOWEST;
                break;
            }
            case 4: {
                this.speed = EntityLocomotive.LocoSpeed.SLOWER;
                break;
            }
            case 5: {
                this.speed = EntityLocomotive.LocoSpeed.SLOW;
                break;
            }
            case 6: {
                this.speed = EntityLocomotive.LocoSpeed.MAX;
            }
        }
        this.updateButtons();
        this.sendUpdatePacket();
    }

    private void updateButtons() {
        this.running.active = this.mode == EntityLocomotive.LocoMode.RUNNING;
        this.idle.active = this.mode == EntityLocomotive.LocoMode.IDLE;
        this.shutdown.active = this.mode == EntityLocomotive.LocoMode.SHUTDOWN;
        this.slowest.active = this.speed == EntityLocomotive.LocoSpeed.SLOWEST;
        this.slower.active = this.speed == EntityLocomotive.LocoSpeed.SLOWER;
        this.slow.active = this.speed == EntityLocomotive.LocoSpeed.SLOW;
        this.max.active = this.speed == EntityLocomotive.LocoSpeed.MAX;
    }

    public void b() {
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        this.loco.clientMode = this.mode;
        this.loco.clientSpeed = this.speed;
        PacketBuilder.getInstance().sendGuiReturnPacket(this.loco);
    }

    protected void b(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.l, this.loco.b(), 6);
        this.l.b(bm.a((String)"container.inventory"), 8, this.c - 96 + 2, 0x404040);
    }

    @Override
    protected void a(float par1, int par2, int par3) {
        super.a(par1, par3, par3);
        int x = (this.g - this.b) / 2;
        int y = (this.h - this.c) / 2;
        if (this.loco.burnTime > 0.0f) {
            int scale = this.loco.getBurnProgressScaled(12);
            this.b(x + 62, y + 34 - scale, 176, 59 - scale, 14, scale + 2);
        }
    }
}

