/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import railcraft.client.gui.GuiTools;
import railcraft.client.gui.TileGui;
import railcraft.client.gui.buttons.GuiButtonSmall;
import railcraft.common.blocks.detector.TileDetectorItem;
import railcraft.common.gui.containers.ContainerDetectorItem;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.PacketGuiReturn;

public class GuiDetectorItem
extends TileGui {
    private static final String label = RailcraftLanguage.translate("detector.item");
    private final TileDetectorItem tile;
    private atb filterLeft;
    private atb filterRight;

    public GuiDetectorItem(qw inv, TileDetectorItem tile) {
        super(tile, new ContainerDetectorItem(inv, tile), "/railcraft/client/textures/gui/gui_detector_item.png");
        this.tile = tile;
        this.b = 176;
        this.c = 166;
    }

    public void A_() {
        super.A_();
        if (this.tile == null) {
            return;
        }
        this.i.clear();
        int w = (this.g - this.b) / 2;
        int h = (this.h - this.c) / 2;
        this.i.add(new GuiButtonSmall(0, w + 10, h + 20, 20, "<"));
        this.i.add(new GuiButtonSmall(1, w + 146, h + 20, 20, ">"));
        this.filterLeft = new GuiButtonSmall(2, w + 10, h + 40, 20, "<");
        this.i.add(this.filterLeft);
        this.filterRight = new GuiButtonSmall(3, w + 146, h + 40, 20, ">");
        this.i.add(this.filterRight);
    }

    protected void a(atb button) {
        if (this.tile == null) {
            return;
        }
        int primary = this.tile.getPrimaryMode().ordinal();
        int filter = this.tile.getFilterMode().ordinal();
        switch (button.f) {
            case 0: {
                --primary;
                break;
            }
            case 1: {
                ++primary;
                break;
            }
            case 2: {
                --filter;
                break;
            }
            case 3: {
                ++filter;
            }
        }
        if (primary < 0) {
            primary = TileDetectorItem.PrimaryMode.values().length - 1;
        }
        if (primary >= TileDetectorItem.PrimaryMode.values().length) {
            primary = 0;
        }
        this.tile.setPrimaryMode(TileDetectorItem.PrimaryMode.values()[primary]);
        if (filter < 0) {
            filter = TileDetectorItem.FilterMode.values().length - 1;
        }
        if (filter >= TileDetectorItem.FilterMode.values().length) {
            filter = 0;
        }
        this.tile.setFilterMode(TileDetectorItem.FilterMode.values()[filter]);
        if (Game.isNotHost(this.tile.getWorld())) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
        }
    }

    @Override
    protected void a(float f, int i, int j) {
        this.filterLeft.h = this.tile.getPrimaryMode() == TileDetectorItem.PrimaryMode.FILTERED;
        this.filterRight.h = this.tile.getPrimaryMode() == TileDetectorItem.PrimaryMode.FILTERED;
        super.a(f, i, j);
    }

    protected void b(int mouseX, int mouseY) {
        int sWidth = this.l.a(label);
        int sPos = this.b / 2 - sWidth / 2;
        this.l.b(label, sPos, 6, 0x404040);
        GuiTools.drawCenteredString(this.l, this.tile.getPrimaryMode().toString(), 25);
        if (this.tile.getPrimaryMode() != TileDetectorItem.PrimaryMode.FILTERED) {
            Color color = new Color(0, 0, 0, 80);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            for (int slotNum = 0; slotNum < 9; ++slotNum) {
                sr slot = (sr)this.d.c.get(slotNum);
                int displayX = slot.h;
                int displayY = slot.i;
                this.a(displayX, displayY, displayX + 16, displayY + 16, color.getRGB(), color.getRGB());
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        } else {
            GuiTools.drawCenteredString(this.l, this.tile.getFilterMode().toString(), 45);
        }
    }
}

