/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLLog;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.EventBus;
import net.minecraftforge.oredict.OreDictionary;

public class MinecraftForge {
    public static final EventBus EVENT_BUS = new EventBus();
    public static final EventBus TERRAIN_GEN_BUS = new EventBus();
    public static final EventBus ORE_GEN_BUS = new EventBus();
    @Deprecated
    public static boolean SPAWNER_ALLOW_ON_INVERTED = false;
    private static final ForgeInternalHandler INTERNAL_HANDLER = new ForgeInternalHandler();

    public static void addGrassPlant(amq block, int metadata, int weight) {
        ForgeHooks.grassList.add(new ForgeHooks.GrassEntry(block, metadata, weight));
    }

    public static void addGrassSeed(ur seed, int weight) {
        ForgeHooks.seedList.add(new ForgeHooks.SeedEntry(seed, weight));
    }

    public static void setToolClass(up tool, String toolClass, int harvestLevel) {
        ForgeHooks.toolClasses.put(tool, Arrays.asList(toolClass, harvestLevel));
    }

    public static void setBlockHarvestLevel(amq block, int metadata, String toolClass, int harvestLevel) {
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        ForgeHooks.toolHarvestLevels.put(key, harvestLevel);
        ForgeHooks.toolEffectiveness.add(key);
    }

    public static void removeBlockEffectiveness(amq block, int metadata, String toolClass) {
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        ForgeHooks.toolEffectiveness.remove(key);
    }

    public static void setBlockHarvestLevel(amq block, String toolClass, int harvestLevel) {
        for (int metadata = 0; metadata < 16; ++metadata) {
            List<Object> key = Arrays.asList(block, metadata, toolClass);
            ForgeHooks.toolHarvestLevels.put(key, harvestLevel);
            ForgeHooks.toolEffectiveness.add(key);
        }
    }

    public static int getBlockHarvestLevel(amq block, int metadata, String toolClass) {
        ForgeHooks.initTools();
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        Integer harvestLevel = ForgeHooks.toolHarvestLevels.get(key);
        return harvestLevel == null ? -1 : harvestLevel;
    }

    public static void removeBlockEffectiveness(amq block, String toolClass) {
        for (int metadata = 0; metadata < 16; ++metadata) {
            List<Object> key = Arrays.asList(block, metadata, toolClass);
            ForgeHooks.toolEffectiveness.remove(key);
        }
    }

    public static void initialize() {
        System.out.printf("MinecraftForge v%s Initialized\n", ForgeVersion.getVersion());
        FMLLog.info("MinecraftForge v%s Initialized", ForgeVersion.getVersion());
        amq filler = new amq(0, agi.a);
        amq.p[0] = null;
        amq.q[0] = false;
        amq.r[0] = 0;
        for (int x2 = 256; x2 < 4096; ++x2) {
            if (up.e[x2] == null) continue;
            amq.p[x2] = filler;
        }
        boolean[] temp = new boolean[4096];
        System.arraycopy(qd.d, 0, temp, 0, qd.d.length);
        qd.d = temp;
        EVENT_BUS.register(INTERNAL_HANDLER);
        OreDictionary.getOreName(0);
    }

    public static String getBrandingVersion() {
        return "Minecraft Forge " + ForgeVersion.getVersion();
    }
}

