/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.liquid.LiquidUtils;
import codechicken.core.render.CCRenderState;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.Vector3;
import cpw.mods.fml.client.TextureFXManager;
import java.awt.Dimension;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];

    static {
        int i = 0;
        while (i < vectors.length) {
            RenderUtils.vectors[i] = new Vector3();
            ++i;
        }
    }

    public static void addVecWithUV(Vector3 vec, double u2, double v) {
        baz.a.a(vec.x, vec.y, vec.z, u2, v);
    }

    public static int bindLiquidTexture(int liquidID, int liquidMeta) {
        if (liquidID < amq.p.length && amq.p[liquidID] != null) {
            amq liquidBlock = amq.p[liquidID];
            CCRenderState.changeTexture(liquidBlock.getTextureFile());
            return liquidBlock.a(0, liquidMeta);
        }
        up liquidItem = up.e[liquidID];
        if (liquidItem == null) {
            return 0;
        }
        CCRenderState.changeTexture(liquidItem.getTextureFile());
        return liquidItem.b(liquidMeta);
    }

    public static void renderLiquidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, int texIndex, double res) {
        double tx1 = (double)(texIndex % 16) / 16.0;
        double ty1 = (double)(texIndex / 16) / 16.0;
        double ty2 = ty1 + 0.0625;
        Vector3 wide = vectors[0].set(point4).subtract(point1);
        Vector3 high = vectors[1].set(point1).subtract(point2);
        baz t = baz.a;
        double wlen = wide.mag();
        double hlen = high.mag();
        double x2 = 0.0;
        while (x2 < wlen) {
            double rx = wlen - x2;
            if (rx > res) {
                rx = res;
            }
            double y2 = 0.0;
            while (y2 < hlen) {
                double ry = hlen - y2;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x2 / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x2 + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y2 / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y2 + ry) / hlen);
                t.a(point2.x + dx1.x + dy2.x, point2.y + dx1.y + dy2.y, point2.z + dx1.z + dy2.z, tx1, ty2 - ry / res * 0.0625);
                t.a(point2.x + dx1.x + dy1.x, point2.y + dx1.y + dy1.y, point2.z + dx1.z + dy1.z, tx1, ty2);
                t.a(point2.x + dx2.x + dy1.x, point2.y + dx2.y + dy1.y, point2.z + dx2.z + dy1.z, tx1 + rx / res * 0.0625, ty2);
                t.a(point2.x + dx2.x + dy2.x, point2.y + dx2.y + dy2.y, point2.z + dx2.z + dy2.z, tx1 + rx / res * 0.0625, ty2 - ry / res * 0.0625);
                y2 += ry;
            }
            x2 += rx;
        }
    }

    public static void translateToWorldCoords(lq entity, float frame) {
        double interpPosX = entity.T + (entity.t - entity.T) * (double)frame;
        double interpPosY = entity.U + (entity.u - entity.U) * (double)frame;
        double interpPosZ = entity.V + (entity.v - entity.V) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawOutlinedBoundingBox(aoe par1AxisAlignedBB) {
        baz var2 = baz.a;
        var2.b(3);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a();
        var2.b(3);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a();
        var2.b(1);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a();
    }

    public static void renderLiquidCuboid(Cuboid6 bound, int texIndex, double res) {
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), texIndex, res);
    }

    public static void renderBlockOverlaySide(int x2, int y2, int z2, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x2 - 0.009, (double)x2 + 1.009, (double)y2 - 0.009, (double)y2 + 1.009, (double)z2 - 0.009, (double)z2 + 1.009};
        baz tessellator = baz.a;
        switch (side) {
            case 0: {
                tessellator.a(points[0], points[2], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx2, ty1);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty2);
                tessellator.a(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                tessellator.a(points[0], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                tessellator.a(points[1], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty1);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                tessellator.a(points[0], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[5], tx1, ty1);
                tessellator.a(points[1], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }

    public static boolean shouldRenderLiquid(LiquidStack liquid) {
        return liquid.amount > 0 && liquid.asItemStack().b() != null;
    }

    public static void renderLiquidCuboid(LiquidStack liquid, Cuboid6 bound, double res) {
        if (!RenderUtils.shouldRenderLiquid(liquid)) {
            return;
        }
        GL11.glDisable((int)2896);
        if (liquid.isLiquidEqual(LiquidUtils.water)) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        CCRenderState.setColourOpaque(liquid.asItemStack().b().a(liquid.asItemStack(), 0));
        int tex = RenderUtils.bindLiquidTexture(liquid.itemID, liquid.itemMeta);
        CCRenderState.startDrawing(7);
        RenderUtils.renderLiquidCuboid(bound, tex, res);
        CCRenderState.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static void renderQuad3D(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, int tx1, int ty1, int tx2, int ty2, int tw, int th, double depth) {
        double d;
        double u1 = (double)tx1 / (double)tw;
        double v1 = (double)ty1 / (double)th;
        double u2 = (double)tx2 / (double)tw;
        double v2 = (double)ty2 / (double)th;
        int d_tw = tx2 - tx1;
        int d_th = ty2 - ty1;
        double d_u = u2 - u1;
        double d_v = v2 - v1;
        Vector3 width = point4.copy().subtract(point1);
        Vector3 height = point2.copy().subtract(point1);
        Vector3 normal = width.copy().crossProduct(height).normalize();
        Vector3 vd = normal.copy().multiply(-depth);
        Vector3 n_width = width.copy().normalize();
        Vector3 n_height = height.copy().normalize();
        Vector3 point1d = point1.copy().add(vd);
        Vector3 point2d = point2.copy().add(vd);
        Vector3 point3d = point3.copy().add(vd);
        Vector3 point4d = point4.copy().add(vd);
        baz t = baz.a;
        t.b((float)normal.x, (float)normal.y, (float)normal.z);
        t.a(point1.x, point1.y, point1.z, u1, v1);
        t.a(point2.x, point2.y, point2.z, u1, v2);
        t.a(point3.x, point3.y, point3.z, u2, v2);
        t.a(point4.x, point4.y, point4.z, u2, v1);
        t.b((float)(-normal.x), (float)(-normal.y), (float)(-normal.z));
        t.a(point4d.x, point4d.y, point4d.z, u2, v1);
        t.a(point3d.x, point3d.y, point3d.z, u2, v2);
        t.a(point2d.x, point2d.y, point2d.z, u1, v2);
        t.a(point1d.x, point1d.y, point1d.z, u1, v1);
        Vector3 dv = new Vector3();
        int i = 0;
        while (i <= d_tw) {
            d = (double)i / (double)d_tw;
            double u3 = u1 + d * d_u;
            dv.set(width).multiply(d);
            t.b((float)n_width.x, (float)n_width.y, (float)n_width.z);
            t.a(point1.x + dv.x, point1.y + dv.y, point1.z + dv.z, u3, v1);
            t.a(point2.x + dv.x, point2.y + dv.y, point2.z + dv.z, u3, v2);
            t.a(point2d.x + dv.x, point2d.y + dv.y, point2d.z + dv.z, u3, v2);
            t.a(point1d.x + dv.x, point1d.y + dv.y, point1d.z + dv.z, u3, v1);
            t.b((float)(-n_width.x), (float)(-n_width.y), (float)(-n_width.z));
            t.a(point1d.x + dv.x, point1d.y + dv.y, point1d.z + dv.z, u3, v1);
            t.a(point2d.x + dv.x, point2d.y + dv.y, point2d.z + dv.z, u3, v2);
            t.a(point2.x + dv.x, point2.y + dv.y, point2.z + dv.z, u3, v2);
            t.a(point1.x + dv.x, point1.y + dv.y, point1.z + dv.z, u3, v1);
            ++i;
        }
        i = 0;
        while (i <= d_th) {
            d = (double)i / (double)d_th;
            double v = v1 + d * d_v;
            dv.set(height).multiply(d);
            t.b((float)n_height.x, (float)n_height.y, (float)n_height.z);
            t.a(point1.x + dv.x, point1.y + dv.y, point1.z + dv.z, u1, v);
            t.a(point4.x + dv.x, point4.y + dv.y, point4.z + dv.z, u2, v);
            t.a(point4d.x + dv.x, point4d.y + dv.y, point4d.z + dv.z, u2, v);
            t.a(point1d.x + dv.x, point1d.y + dv.y, point1d.z + dv.z, u1, v);
            t.b((float)(-n_height.x), (float)(-n_height.y), (float)(-n_height.z));
            t.a(point1d.x + dv.x, point1d.y + dv.y, point1d.z + dv.z, u1, v);
            t.a(point4d.x + dv.x, point4d.y + dv.y, point4d.z + dv.z, u2, v);
            t.a(point4.x + dv.x, point4.y + dv.y, point4.z + dv.z, u2, v);
            t.a(point1.x + dv.x, point1.y + dv.y, point1.z + dv.z, u1, v);
            ++i;
        }
    }

    public void render3DItem(int tex, int texIndex) {
        Dimension d = TextureFXManager.instance().getTextureDimensions(tex);
        int tx1 = texIndex % 16 * d.width / 16;
        int ty1 = texIndex / 16 * d.width / 16;
        RenderUtils.renderQuad3D(new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, 0.0), new Vector3(1.0, 1.0, 0.0), new Vector3(1.0, 0.0, 0.0), tx1, ty1, tx1 + d.width / 16, ty1 + d.height / 16, d.width, d.height, 0.0625);
    }
}

