/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.vec.Vector3;
import com.google.common.base.Objects;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISpecialSlotInventory;

public class InventoryUtils {
    public static final ForgeDirection[] chestSides = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH};

    public static ur decrStackSize(la inv, int slot, int size) {
        ur item = inv.a(slot);
        if (item != null) {
            if (item.a <= size) {
                ur itemstack = item;
                inv.a(slot, null);
                inv.d();
                return itemstack;
            }
            ur itemstack1 = item.a(size);
            if (item.a == 0) {
                inv.a(slot, null);
            }
            inv.d();
            return itemstack1;
        }
        return null;
    }

    public static ur getStackInSlotOnClosing(la inv, int slot) {
        ur stack = inv.a(slot);
        inv.a(slot, null);
        return stack;
    }

    public static int incrStackSize(ur base, ur addition) {
        if (InventoryUtils.canStack(base, addition)) {
            return InventoryUtils.incrStackSize(base, addition.a);
        }
        return 0;
    }

    public static int incrStackSize(ur base, int addition) {
        int totalSize = base.a + addition;
        if (totalSize <= base.d()) {
            return addition;
        }
        if (base.a < base.d()) {
            return base.d() - base.a;
        }
        return 0;
    }

    public static by writeItemStacksToTag(ur[] items) {
        by tagList = new by();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                bq tag = new bq();
                tag.a("Slot", (short)i);
                items[i].b(tag);
                tagList.a((cd)tag);
            }
            ++i;
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ur[] items, by tagList) {
        int i = 0;
        while (i < tagList.c()) {
            bq tag = (bq)tagList.b(i);
            items[tag.d((String)"Slot")] = ur.a((bq)tag);
            ++i;
        }
    }

    public static void dropItem(ur stack, yc world, Vector3 dropLocation) {
        px item = new px(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.w = world.t.nextGaussian() * 0.05;
        item.x = world.t.nextGaussian() * 0.05 + (double)0.2f;
        item.y = world.t.nextGaussian() * 0.05;
        world.d((lq)item);
    }

    public static ur copyStack(ur stack, int quantity) {
        stack = stack.l();
        stack.a = quantity;
        return stack;
    }

    public static boolean areStacksSameTypeCrafting(ur stack1, ur stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.c == stack2.c && (stack1.j() == stack2.j() || stack1.j() == -1 || stack2.j() == -1 || stack1.b().n());
    }

    public static int getInsertableQuantity(la inv, int fslot, int lslot, ur stack) {
        int quantity = 0;
        stack = InventoryUtils.copyStack(stack, Integer.MAX_VALUE);
        int slot = fslot;
        while (slot < lslot) {
            quantity += InventoryUtils.fitStackInSlot(inv, slot, stack);
            ++slot;
        }
        return quantity;
    }

    public static int fitStackInSlot(la inv, int slot, ur stack) {
        ur base = inv.a(slot);
        if (!InventoryUtils.canStack(base, stack)) {
            return 0;
        }
        int fit = inv instanceof ISpecialSlotInventory ? ((ISpecialSlotInventory)inv).getSlotAcceptedStackSize(slot, stack) : (base != null ? InventoryUtils.incrStackSize(base, inv.c() - base.a) : inv.c());
        return Math.min(fit, stack.a);
    }

    public static boolean mergeItemStack(la inv, int fslot, int lslot, ur stack, boolean doMerge) {
        if (doMerge && !InventoryUtils.mergeItemStack(inv, fslot, lslot, stack, false)) {
            return false;
        }
        stack = stack.l();
        int pass = 0;
        while (pass < 2) {
            int slot = fslot;
            while (slot < lslot) {
                ur base = inv.a(slot);
                int fit = InventoryUtils.fitStackInSlot(inv, slot, stack);
                if (fit != 0) {
                    if (base != null) {
                        stack.a -= fit;
                        if (doMerge) {
                            base.a += fit;
                            inv.a(slot, base);
                        }
                    } else if (pass == 1) {
                        if (doMerge) {
                            inv.a(slot, InventoryUtils.copyStack(stack, fit));
                        }
                        stack.a -= fit;
                    }
                    if (stack.a == 0) {
                        return true;
                    }
                }
                ++slot;
            }
            ++pass;
        }
        return false;
    }

    public static boolean areStacksIdentical(ur stack1, ur stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.c == stack2.c && stack1.j() == stack2.j() && stack1.a == stack2.a && Objects.equal((Object)stack1.p(), (Object)stack2.p());
    }

    public static la getInventory(yc world, int x2, int y2, int z2) {
        any tile = world.q(x2, y2, z2);
        if (!(tile instanceof la)) {
            return null;
        }
        if (tile instanceof anm) {
            return InventoryUtils.getChest((anm)tile);
        }
        return (la)tile;
    }

    public static la getChest(anm chest) {
        ForgeDirection[] forgeDirectionArray = chestSides;
        int n = chestSides.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeDirection fside = forgeDirectionArray[n2];
            if (chest.k.a(chest.l + fside.offsetX, chest.m + fside.offsetY, chest.n + fside.offsetZ) == chest.q().cm) {
                return new kz("container.chestDouble", (la)((anm)chest.k.q(chest.l + fside.offsetX, chest.m + fside.offsetY, chest.n + fside.offsetZ)), (la)chest);
            }
            ++n2;
        }
        return chest;
    }

    public static boolean canStack(ur stack1, ur stack2) {
        return stack1 == null || stack2 == null || stack1.c == stack2.c && (!stack2.g() || stack2.j() == stack1.j()) && ur.a((ur)stack2, (ur)stack1);
    }

    public static void consumeItem(la inv, int slot) {
        ur stack = inv.a(slot);
        up item = stack.b();
        if (item.s()) {
            ur container = item.getContainerItemStack(stack);
            inv.a(slot, container);
        } else {
            inv.a(slot, 1);
        }
    }

    public static boolean inventoriesEqual(la inv1, la inv2) {
        if (inv1 == null || inv2 == null) {
            return inv1 == inv2;
        }
        if (inv1 instanceof kz) {
            if (!(inv2 instanceof kz)) {
                return false;
            }
            kz chest1 = (kz)inv1;
            kz chest2 = (kz)inv2;
            return chest1.b == chest2.b && chest1.c == chest2.c;
        }
        return inv1.equals(inv2);
    }

    public static int stackSize(la inv, int slot) {
        ur stack = inv.a(slot);
        return stack == null ? 0 : stack.a;
    }

    public static ur getRemovableStack(la inv, int slot) {
        ur stack = inv.a(slot);
        if (stack == null) {
            return null;
        }
        if (inv instanceof ISpecialSlotInventory) {
            return InventoryUtils.copyStack(stack, ((ISpecialSlotInventory)inv).getSlotAvailableStackSize(slot));
        }
        return stack;
    }
}

