/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.renderer;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Settings;
import lunatrius.schematica.renderer.RendererTileEntity;
import lunatrius.schematica.util.Vector3f;
import lunatrius.schematica.util.Vector3i;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RendererSchematicChunk {
    public static final int CHUNK_WIDTH = 16;
    public static final int CHUNK_HEIGHT = 16;
    public static final int CHUNK_LENGTH = 16;
    private static boolean canUpdate = false;
    public boolean isInFrustrum = false;
    public final Vector3i centerPosition = new Vector3i();
    private final Settings settings = Settings.instance();
    private final kh profiler;
    private final SchematicWorld schematic;
    private final List tileEntities;
    private final aoe boundingBox;
    private static final int initialSize = 1152;
    private final List textures;
    private final BufferedImage missingTextureImage;
    private Field fieldTextureMap;
    private Field fieldSingleIntBuffer;
    private int quadSize;
    private float[] quadColorBuffer;
    private float[] quadVertexBuffer;
    private int quadColorIndex;
    private int quadVertexIndex;
    private int quadCount;
    private int lineSize;
    private float[] lineColorBuffer;
    private float[] lineVertexBuffer;
    private int lineColorIndex;
    private int lineVertexIndex;
    private int lineCount;
    private boolean needsUpdate;
    private int glList;

    public RendererSchematicChunk(SchematicWorld schematicWorld, int baseX, int baseY, int baseZ) {
        this.profiler = this.settings.minecraft.I;
        this.tileEntities = new ArrayList();
        this.boundingBox = aoe.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.textures = new ArrayList();
        this.missingTextureImage = new BufferedImage(64, 64, 2);
        this.fieldTextureMap = null;
        this.fieldSingleIntBuffer = null;
        this.quadSize = 1152;
        this.quadColorBuffer = null;
        this.quadVertexBuffer = null;
        this.quadColorIndex = -1;
        this.quadVertexIndex = -1;
        this.quadCount = -1;
        this.lineSize = 1152;
        this.lineColorBuffer = null;
        this.lineVertexBuffer = null;
        this.lineColorIndex = -1;
        this.lineVertexIndex = -1;
        this.lineCount = -1;
        this.needsUpdate = true;
        this.glList = -1;
        this.initTexture();
        this.initReflection();
        this.schematic = schematicWorld;
        this.boundingBox.b((double)(baseX * 16), (double)(baseY * 16), (double)(baseZ * 16), (double)((baseX + 1) * 16), (double)((baseY + 1) * 16), (double)((baseZ + 1) * 16));
        this.centerPosition.x = (int)(((double)baseX + 0.5) * 16.0);
        this.centerPosition.y = (int)(((double)baseY + 0.5) * 16.0);
        this.centerPosition.z = (int)(((double)baseZ + 0.5) * 16.0);
        for (any tileEntity : this.schematic.getTileEntities()) {
            int x = tileEntity.l;
            int y = tileEntity.m;
            int z = tileEntity.n;
            if ((double)x < this.boundingBox.a || (double)x >= this.boundingBox.d || (double)z < this.boundingBox.c || (double)z >= this.boundingBox.f || (double)y < this.boundingBox.b || (double)y >= this.boundingBox.e) continue;
            this.tileEntities.add(tileEntity);
        }
        this.glList = GL11.glGenLists((int)3);
    }

    private void initTexture() {
        Graphics graphics = this.missingTextureImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(Color.BLACK);
        graphics.drawString("missingtex", 1, 10);
        graphics.dispose();
    }

    private void initReflection() {
        try {
            this.fieldTextureMap = ReflectionHelper.findField(bba.class, (String[])new String[]{"c", "textureMap"});
            this.fieldSingleIntBuffer = ReflectionHelper.findField(bba.class, (String[])new String[]{"f", "singleIntBuffer"});
        }
        catch (Exception e) {
            this.fieldTextureMap = null;
            this.fieldSingleIntBuffer = null;
            Settings.logger.log(e);
        }
    }

    public void delete() {
        GL11.glDeleteLists((int)this.glList, (int)3);
    }

    public aoe getBoundingBox() {
        return this.boundingBox;
    }

    public static void setCanUpdate(boolean parCanUpdate) {
        canUpdate = parCanUpdate;
    }

    public static boolean getCanUpdate() {
        return canUpdate;
    }

    public void setDirty() {
        this.needsUpdate = true;
    }

    public boolean getDirty() {
        return this.needsUpdate;
    }

    public float distanceToPoint(Vector3f vector) {
        float x = vector.x - (float)this.centerPosition.x;
        float y = vector.y - (float)this.centerPosition.y;
        float z = vector.z - (float)this.centerPosition.z;
        return x * x + y * y + z * z;
    }

    public void updateRenderer() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            RendererSchematicChunk.setCanUpdate(false);
            this.quadVertexBuffer = new float[this.quadSize * 3];
            this.quadColorBuffer = new float[this.quadSize * 4];
            this.lineVertexBuffer = new float[this.lineSize * 3];
            this.lineColorBuffer = new float[this.lineSize * 4];
            for (int pass = 0; pass < 3; ++pass) {
                this.quadColorIndex = 0;
                this.quadVertexIndex = 0;
                this.quadCount = 0;
                this.lineColorIndex = 0;
                this.lineVertexIndex = 0;
                this.lineCount = 0;
                int minX = 0;
                int maxX = 0;
                int minY = 0;
                int maxY = 0;
                int minZ = 0;
                int maxZ = 0;
                minX = (int)this.boundingBox.a;
                maxX = Math.min((int)this.boundingBox.d, this.schematic.width());
                minY = (int)this.boundingBox.b;
                maxY = Math.min((int)this.boundingBox.e, this.schematic.height());
                minZ = (int)this.boundingBox.c;
                maxZ = Math.min((int)this.boundingBox.f, this.schematic.length());
                if (this.settings.renderingLayer >= 0) {
                    if (this.settings.renderingLayer >= minY && this.settings.renderingLayer < maxY) {
                        minY = this.settings.renderingLayer;
                        maxY = this.settings.renderingLayer + 1;
                    } else {
                        maxY = 0;
                        minY = 0;
                    }
                }
                GL11.glNewList((int)(this.glList + pass), (int)4864);
                this.renderBlocks(pass, minX, minY, minZ, maxX, maxY, maxZ);
                if (this.quadCount > 0 || this.lineCount > 0) {
                    FloatBuffer vertexBuffer;
                    FloatBuffer colorBuffer;
                    GL11.glDisable((int)3553);
                    GL11.glLineWidth((float)1.5f);
                    GL11.glEnableClientState((int)32884);
                    GL11.glEnableClientState((int)32886);
                    if (this.quadCount > 0) {
                        colorBuffer = BufferUtils.createFloatBuffer((int)this.quadColorBuffer.length).put(this.quadColorBuffer);
                        vertexBuffer = BufferUtils.createFloatBuffer((int)this.quadVertexBuffer.length).put(this.quadVertexBuffer);
                        colorBuffer.flip();
                        vertexBuffer.flip();
                        GL11.glColorPointer((int)4, (int)0, (FloatBuffer)colorBuffer);
                        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)vertexBuffer);
                        GL11.glDrawArrays((int)7, (int)0, (int)this.quadCount);
                    }
                    if (this.lineCount > 0) {
                        colorBuffer = BufferUtils.createFloatBuffer((int)this.lineColorBuffer.length).put(this.lineColorBuffer);
                        vertexBuffer = BufferUtils.createFloatBuffer((int)this.lineVertexBuffer.length).put(this.lineVertexBuffer);
                        colorBuffer.flip();
                        vertexBuffer.flip();
                        GL11.glColorPointer((int)4, (int)0, (FloatBuffer)colorBuffer);
                        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)vertexBuffer);
                        GL11.glDrawArrays((int)1, (int)0, (int)this.lineCount);
                    }
                    GL11.glDisableClientState((int)32886);
                    GL11.glDisableClientState((int)32884);
                    GL11.glEnable((int)3553);
                }
                GL11.glEndList();
            }
            this.quadVertexBuffer = null;
            this.quadColorBuffer = null;
            this.lineVertexBuffer = null;
            this.lineColorBuffer = null;
        }
    }

    public void render(int renderPass) {
        if (!this.isInFrustrum) {
            return;
        }
        this.profiler.a("blocks");
        GL11.glCallList((int)(this.glList + renderPass));
        this.profiler.c("tileEntities");
        this.renderTileEntities(renderPass);
        this.profiler.b();
    }

    public void renderBlocks(int renderPass, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        ys mcWorld = this.settings.mcWorldCache;
        bbb renderBlocks = this.settings.renderBlocks;
        int blockId = 0;
        int mcBlockId = 0;
        int sides = 0;
        amq block = null;
        String lastTexture = "";
        boolean ambientOcclusion = this.settings.minecraft.y.k;
        this.settings.minecraft.y.k = false;
        baz.a.b();
        for (int y = minY; y < maxY; ++y) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    try {
                        Vector3i tmp;
                        blockId = this.schematic.a(x, y, z);
                        block = amq.p[blockId];
                        mcBlockId = mcWorld.a(x + this.settings.offset.x, y + this.settings.offset.y, z + this.settings.offset.z);
                        sides = 0;
                        if (block != null) {
                            if (block.a((ym)this.schematic, x, y - 1, z, 0)) {
                                sides |= 1;
                            }
                            if (block.a((ym)this.schematic, x, y + 1, z, 1)) {
                                sides |= 2;
                            }
                            if (block.a((ym)this.schematic, x, y, z - 1, 2)) {
                                sides |= 4;
                            }
                            if (block.a((ym)this.schematic, x, y, z + 1, 3)) {
                                sides |= 8;
                            }
                            if (block.a((ym)this.schematic, x - 1, y, z, 4)) {
                                sides |= 0x10;
                            }
                            if (block.a((ym)this.schematic, x + 1, y, z, 5)) {
                                sides |= 0x20;
                            }
                        }
                        if (mcBlockId != 0) {
                            if (!this.settings.highlight || renderPass != 2) continue;
                            if (blockId == 0 && this.settings.highlightAir) {
                                tmp = new Vector3i(x, y, z);
                                this.drawCuboidSurface(tmp, tmp.clone().add(1), 63, 0.75f, 0.0f, 0.75f, 0.25f);
                                this.drawCuboidOutline(tmp, tmp.clone().add(1), 63, 0.75f, 0.0f, 0.75f, 0.25f);
                                continue;
                            }
                            if (blockId != mcBlockId) {
                                tmp = new Vector3i(x, y, z);
                                this.drawCuboidSurface(tmp, tmp.clone().add(1), sides, 1.0f, 0.0f, 0.0f, 0.25f);
                                this.drawCuboidOutline(tmp, tmp.clone().add(1), sides, 1.0f, 0.0f, 0.0f, 0.25f);
                                continue;
                            }
                            if (this.schematic.h(x, y, z) == mcWorld.h(x + this.settings.offset.x, y + this.settings.offset.y, z + this.settings.offset.z)) continue;
                            tmp = new Vector3i(x, y, z);
                            this.drawCuboidSurface(tmp, tmp.clone().add(1), sides, 0.75f, 0.35f, 0.0f, 0.25f);
                            this.drawCuboidOutline(tmp, tmp.clone().add(1), sides, 0.75f, 0.35f, 0.0f, 0.25f);
                            continue;
                        }
                        if (mcBlockId != 0 || blockId <= 0 || blockId >= 4096) continue;
                        if (this.settings.highlight && renderPass == 2) {
                            tmp = new Vector3i(x, y, z);
                            this.drawCuboidSurface(tmp, tmp.clone().add(1), sides, 0.0f, 0.75f, 1.0f, 0.25f);
                            this.drawCuboidOutline(tmp, tmp.clone().add(1), sides, 0.0f, 0.75f, 1.0f, 0.25f);
                        }
                        if (block == null) continue;
                        if (!lastTexture.equals(block.getTextureFile())) {
                            ForgeHooksClient.bindTexture((String)this.getTextureName(block.getTextureFile()), (int)0);
                            lastTexture = block.getTextureFile();
                        }
                        if (!block.canRenderInPass(renderPass)) continue;
                        renderBlocks.b(block, x, y, z);
                        continue;
                    }
                    catch (Exception e) {
                        Settings.logger.log(e);
                    }
                }
            }
        }
        baz.a.a();
        this.settings.minecraft.y.k = ambientOcclusion;
    }

    public void renderTileEntities(int renderPass) {
        ys mcWorld = this.settings.mcWorldCache;
        RendererTileEntity rendererTileEntity = this.settings.rendererTileEntity;
        int mcBlockId = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.settings.alpha);
        try {
            for (any tileEntity : this.tileEntities) {
                bdx tileEntitySpecialRenderer;
                int x = tileEntity.l;
                int y = tileEntity.m;
                int z = tileEntity.n;
                if (this.settings.renderingLayer >= 0 && y != this.settings.renderingLayer || (mcBlockId = mcWorld.a(x + this.settings.offset.x, y + this.settings.offset.y, z + this.settings.offset.z)) != 0) continue;
                if (tileEntity instanceof anv) {
                    rendererTileEntity.renderTileEntitySignAt((anv)tileEntity);
                    continue;
                }
                if (tileEntity instanceof anm) {
                    rendererTileEntity.renderTileEntityChestAt((anm)tileEntity);
                    continue;
                }
                if (tileEntity instanceof anq) {
                    rendererTileEntity.renderTileEntityEnderChestAt((anq)tileEntity);
                    continue;
                }
                if (tileEntity instanceof ans || (tileEntitySpecialRenderer = bdw.a.b(tileEntity)) == null) continue;
                try {
                    tileEntitySpecialRenderer.a(tileEntity, (double)x, (double)y, (double)z, 0.0f);
                }
                catch (Exception e) {
                    Settings.logger.log(e);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.settings.alpha);
            }
        }
        catch (Exception ex) {
            Settings.logger.log(ex);
        }
    }

    private float[] createAndCopyBuffer(int newSize, float[] oldBuffer) {
        float[] tempBuffer = new float[newSize];
        System.arraycopy(oldBuffer, 0, tempBuffer, 0, oldBuffer.length);
        return tempBuffer;
    }

    private void drawCuboidSurface(Vector3i a, Vector3i b, int sides, float red, float green, float blue, float alpha) {
        Vector3f zero = new Vector3f(a.x, a.y, a.z).sub(this.settings.blockDelta);
        Vector3f size = new Vector3f(b.x, b.y, b.z).add(this.settings.blockDelta);
        if (this.quadCount + 24 >= this.quadSize) {
            this.quadSize *= 2;
            this.quadVertexBuffer = this.createAndCopyBuffer(this.quadSize * 3, this.quadVertexBuffer);
            this.quadColorBuffer = this.createAndCopyBuffer(this.quadSize * 4, this.quadColorBuffer);
        }
        int total = 0;
        if ((sides & 0x10) != 0) {
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            total += 4;
        }
        if ((sides & 0x20) != 0) {
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            total += 4;
        }
        if ((sides & 4) != 0) {
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            total += 4;
        }
        if ((sides & 8) != 0) {
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            total += 4;
        }
        if ((sides & 1) != 0) {
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            total += 4;
        }
        if ((sides & 2) != 0) {
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = zero.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.x;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.y;
            this.quadVertexBuffer[this.quadVertexIndex++] = size.z;
            ++this.quadCount;
            total += 4;
        }
        for (int i = 0; i < total; ++i) {
            this.quadColorBuffer[this.quadColorIndex++] = red;
            this.quadColorBuffer[this.quadColorIndex++] = green;
            this.quadColorBuffer[this.quadColorIndex++] = blue;
            this.quadColorBuffer[this.quadColorIndex++] = alpha;
        }
    }

    private void drawCuboidOutline(Vector3i a, Vector3i b, int sides, float red, float green, float blue, float alpha) {
        Vector3f zero = new Vector3f(a.x, a.y, a.z).sub(this.settings.blockDelta);
        Vector3f size = new Vector3f(b.x, b.y, b.z).add(this.settings.blockDelta);
        if (this.lineCount + 24 >= this.lineSize) {
            this.lineSize *= 2;
            this.lineVertexBuffer = this.createAndCopyBuffer(this.lineSize * 3, this.lineVertexBuffer);
            this.lineColorBuffer = this.createAndCopyBuffer(this.lineSize * 4, this.lineColorBuffer);
        }
        int total = 0;
        if ((sides & 0x11) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 0x12) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 0x21) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 0x22) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 5) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 6) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 9) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 0xA) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 0x14) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 0x24) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 0x18) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            total += 2;
        }
        if ((sides & 0x28) != 0) {
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = zero.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.x;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.y;
            this.lineVertexBuffer[this.lineVertexIndex++] = size.z;
            ++this.lineCount;
            total += 2;
        }
        for (int i = 0; i < total; ++i) {
            this.lineColorBuffer[this.lineColorIndex++] = red;
            this.lineColorBuffer[this.lineColorIndex++] = green;
            this.lineColorBuffer[this.lineColorIndex++] = blue;
            this.lineColorBuffer[this.lineColorIndex++] = alpha;
        }
    }

    private String getTextureName(String texture) {
        if (!this.settings.enableAlpha) {
            return texture;
        }
        String textureName = "/" + (int)(this.settings.alpha * 255.0f) + texture.replace('/', '-');
        if (this.textures.contains(textureName)) {
            return textureName;
        }
        try {
            bem texturePackBase = this.settings.minecraft.C.e();
            File newTextureFile = new File(Settings.textureDirectory, texturePackBase.c().replace(".zip", "") + textureName);
            if (!newTextureFile.exists()) {
                BufferedImage bufferedImage = this.readTextureImage(texturePackBase.a(texture));
                if (bufferedImage == null) {
                    return texture;
                }
                for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                    for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                        int color = bufferedImage.getRGB(x, y);
                        bufferedImage.setRGB(x, y, (int)((float)(color >> 24 & 0xFF) * this.settings.alpha) << 24 | color & 0xFFFFFF);
                    }
                }
                if (!newTextureFile.getParentFile().exists() && !newTextureFile.getParentFile().mkdirs()) {
                    return texture;
                }
                ImageIO.write((RenderedImage)bufferedImage, "png", newTextureFile);
            }
            this.loadTexture(textureName, this.readTextureImage(new BufferedInputStream(new FileInputStream(newTextureFile))));
            this.textures.add(textureName);
            return textureName;
        }
        catch (IOException e) {
            Settings.logger.log(e);
        }
        catch (IllegalArgumentException e) {
            Settings.logger.log(e);
        }
        catch (IllegalAccessException e) {
            Settings.logger.log(e);
        }
        return texture;
    }

    private int loadTexture(String texture, BufferedImage textureImage) throws IllegalArgumentException, IllegalAccessException {
        HashMap textureMap = (HashMap)this.fieldTextureMap.get(this.settings.minecraft.o);
        IntBuffer singleIntBuffer = (IntBuffer)this.fieldSingleIntBuffer.get(this.settings.minecraft.o);
        Integer textureId = (Integer)textureMap.get(texture);
        if (textureId != null) {
            return textureId;
        }
        try {
            singleIntBuffer.clear();
            arx.a((IntBuffer)singleIntBuffer);
            int glTextureId = singleIntBuffer.get(0);
            this.settings.minecraft.o.a(textureImage, glTextureId);
            textureMap.put(texture, glTextureId);
            return glTextureId;
        }
        catch (Exception e) {
            Settings.logger.log(e);
            arx.a((IntBuffer)singleIntBuffer);
            int glTextureId = singleIntBuffer.get(0);
            this.settings.minecraft.o.a(this.missingTextureImage, glTextureId);
            textureMap.put(texture, glTextureId);
            return glTextureId;
        }
    }

    private BufferedImage readTextureImage(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        inputStream.close();
        return bufferedImage;
    }
}

