/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import lunatrius.schematica.KeyBindingHandler;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Settings;
import lunatrius.schematica.Ticker;
import lunatrius.schematica.renderer.RendererSchematicChunk;
import lunatrius.schematica.renderer.RendererSchematicGlobal;
import lunatrius.schematica.util.Config;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Schematica")
public class Schematica {
    private final Settings settings = Settings.instance();
    private final kh profiler;
    @Mod.Instance(value="Schematica")
    public static Schematica instance;
    private Field sortedWorldRenderers;

    public Schematica() {
        this.profiler = this.settings.minecraft.I;
        this.sortedWorldRenderers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.settings.enableAlpha = Config.getBoolean(config, "alphaEnabled", "general", this.settings.enableAlpha, "Enable transparent textures.");
        this.settings.alpha = (float)Config.getInt(config, "alpha", "general", (int)(this.settings.alpha * 255.0f), 0, 255, "Alpha value used when rendering the schematic.") / 255.0f;
        this.settings.highlight = Config.getBoolean(config, "highlight", "general", this.settings.highlight, "Highlight invalid placed blocks and to be placed blocks.");
        this.settings.highlightAir = Config.getBoolean(config, "highlightAir", "general", this.settings.highlightAir, "Highlight invalid placed blocks (where there should be no block).");
        this.settings.blockDelta = Config.getFloat(config, "blockDelta", "general", this.settings.blockDelta, 0.0f, 0.5f, "Delta value used for highlighting (if you're having issue with overlapping textures try setting this value higher).");
        config.save();
        try {
            String assetsDir = "lunatrius/schematica/assets/";
            String langDir = assetsDir + "lang/";
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream stream = classLoader.getResourceAsStream(langDir + "lang.txt");
            BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            try {
                String lang = "";
                while ((lang = input.readLine()) != null) {
                    if (lang.length() <= 0) continue;
                    Settings.logger.info("Loading language file: " + lang);
                    LanguageRegistry.instance().loadLocalization(classLoader.getResource(langDir + lang + ".lang"), lang, false);
                }
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            Settings.logger.log(Level.SEVERE, "Could not load language files - corrupted installation detected!", e);
            throw new RuntimeException(e);
        }
        List blockListIgnoreID = SchematicWorld.blockListIgnoreID;
        blockListIgnoreID.add(amq.ad.cm);
        blockListIgnoreID.add(amq.af.cm);
        blockListIgnoreID.add(amq.bh.cm);
        blockListIgnoreID.add(amq.bK.cm);
        List blockListIgnoreMetadata = SchematicWorld.blockListIgnoreMetadata;
        blockListIgnoreMetadata.add(amq.D.cm);
        blockListIgnoreMetadata.add(amq.E.cm);
        blockListIgnoreMetadata.add(amq.F.cm);
        blockListIgnoreMetadata.add(amq.G.cm);
        blockListIgnoreMetadata.add(amq.S.cm);
        blockListIgnoreMetadata.add(amq.V.cm);
        blockListIgnoreMetadata.add(amq.W.cm);
        blockListIgnoreMetadata.add(amq.X.cm);
        blockListIgnoreMetadata.add(amq.Y.cm);
        blockListIgnoreMetadata.add(amq.ac.cm);
        blockListIgnoreMetadata.add(amq.an.cm);
        blockListIgnoreMetadata.add(amq.at.cm);
        blockListIgnoreMetadata.add(amq.aw.cm);
        blockListIgnoreMetadata.add(amq.ax.cm);
        blockListIgnoreMetadata.add(amq.ay.cm);
        blockListIgnoreMetadata.add(amq.aC.cm);
        blockListIgnoreMetadata.add(amq.aD.cm);
        blockListIgnoreMetadata.add(amq.aE.cm);
        blockListIgnoreMetadata.add(amq.aF.cm);
        blockListIgnoreMetadata.add(amq.aG.cm);
        blockListIgnoreMetadata.add(amq.aH.cm);
        blockListIgnoreMetadata.add(amq.aI.cm);
        blockListIgnoreMetadata.add(amq.aJ.cm);
        blockListIgnoreMetadata.add(amq.aK.cm);
        blockListIgnoreMetadata.add(amq.aL.cm);
        blockListIgnoreMetadata.add(amq.aM.cm);
        blockListIgnoreMetadata.add(amq.aN.cm);
        blockListIgnoreMetadata.add(amq.aO.cm);
        blockListIgnoreMetadata.add(amq.aP.cm);
        blockListIgnoreMetadata.add(amq.aS.cm);
        blockListIgnoreMetadata.add(amq.aT.cm);
        blockListIgnoreMetadata.add(amq.aU.cm);
        blockListIgnoreMetadata.add(amq.bd.cm);
        blockListIgnoreMetadata.add(amq.bh.cm);
        blockListIgnoreMetadata.add(amq.bi.cm);
        blockListIgnoreMetadata.add(amq.bj.cm);
        blockListIgnoreMetadata.add(amq.bk.cm);
        blockListIgnoreMetadata.add(amq.bl.cm);
        blockListIgnoreMetadata.add(amq.bn.cm);
        blockListIgnoreMetadata.add(amq.bx.cm);
        blockListIgnoreMetadata.add(amq.by.cm);
        blockListIgnoreMetadata.add(amq.bz.cm);
        blockListIgnoreMetadata.add(amq.bA.cm);
        blockListIgnoreMetadata.add(amq.bC.cm);
        blockListIgnoreMetadata.add(amq.bF.cm);
        blockListIgnoreMetadata.add(amq.bG.cm);
        blockListIgnoreMetadata.add(amq.bL.cm);
        blockListIgnoreMetadata.add(amq.bO.cm);
        blockListIgnoreMetadata.add(amq.bP.cm);
        blockListIgnoreMetadata.add(amq.bR.cm);
        blockListIgnoreMetadata.add(amq.bT.cm);
        blockListIgnoreMetadata.add(amq.bV.cm);
        blockListIgnoreMetadata.add(amq.bW.cm);
        blockListIgnoreMetadata.add(amq.bX.cm);
        blockListIgnoreMetadata.add(amq.bZ.cm);
        blockListIgnoreMetadata.add(amq.ca.cm);
        blockListIgnoreMetadata.add(amq.cb.cm);
        blockListIgnoreMetadata.add(amq.cf.cm);
        blockListIgnoreMetadata.add(amq.cg.cm);
        blockListIgnoreMetadata.add(amq.ch.cm);
        blockListIgnoreMetadata.add(amq.ci.cm);
        blockListIgnoreMetadata.add(amq.ck.cm);
        Map blockListMapping = SchematicWorld.blockListMapping;
        blockListMapping.put(amq.D.cm, up.ax.cj);
        blockListMapping.put(amq.E.cm, up.ax.cj);
        blockListMapping.put(amq.F.cm, up.ay.cj);
        blockListMapping.put(amq.G.cm, up.ay.cj);
        blockListMapping.put(amq.V.cm, up.ba.cj);
        blockListMapping.put(amq.ay.cm, up.aC.cj);
        blockListMapping.put(amq.aC.cm, up.S.cj);
        blockListMapping.put(amq.aF.cm, amq.aE.cm);
        blockListMapping.put(amq.aG.cm, up.au.cj);
        blockListMapping.put(amq.aH.cm, up.av.cj);
        blockListMapping.put(amq.aL.cm, up.au.cj);
        blockListMapping.put(amq.aS.cm, amq.aT.cm);
        blockListMapping.put(amq.bk.cm, up.bb.cj);
        blockListMapping.put(amq.bl.cm, up.bb.cj);
        blockListMapping.put(amq.bv.cm, up.bg.cj);
        blockListMapping.put(amq.bw.cm, up.bh.cj);
        blockListMapping.put(amq.bG.cm, up.br.cj);
        blockListMapping.put(amq.bI.cm, up.by.cj);
        blockListMapping.put(amq.bJ.cm, up.bz.cj);
        blockListMapping.put(amq.bP.cm, amq.bO.cm);
        blockListMapping.put(amq.bS.cm, up.aW.cj);
        blockListMapping.put(amq.bX.cm, up.K.cj);
        blockListMapping.put(amq.cf.cm, up.bJ.cj);
        blockListMapping.put(amq.cg.cm, up.bK.cj);
        blockListMapping.put(amq.ch.cm, up.bL.cj);
        blockListMapping.put(amq.cj.cm, up.bQ.cj);
        if (!Settings.schematicDirectory.exists() && !Settings.schematicDirectory.mkdirs()) {
            System.out.println("Could not create schematic directory!");
        }
        if (!Settings.textureDirectory.exists() && !Settings.textureDirectory.mkdirs()) {
            System.out.println("Could not create texture directory!");
        }
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        try {
            MinecraftForge.EVENT_BUS.register((Object)new RendererSchematicGlobal());
            KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyBindingHandler(this.settings.keyBindings, new boolean[this.settings.keyBindings.length]));
            TickRegistry.registerTickHandler((ITickHandler)new Ticker(EnumSet.of(TickType.CLIENT)), (Side)Side.CLIENT);
            this.initReflection();
        }
        catch (Exception e) {
            Settings.logger.log(Level.SEVERE, "Could not initialize the mod!", e);
            throw new RuntimeException(e);
        }
    }

    public void keyboardEvent(arv keyBinding, boolean down) {
        if (down) {
            this.settings.keyboardEvent(keyBinding);
        }
    }

    public boolean onTick(TickType tick, boolean start) {
        if (start) {
            return true;
        }
        this.profiler.a("schematica");
        if (tick == TickType.CLIENT && this.settings.minecraft.g != null && this.settings.isRenderingSchematic && this.settings.schematic != null) {
            this.profiler.a("checkDirty");
            this.checkDirty();
            this.profiler.c("canUpdate");
            RendererSchematicChunk.setCanUpdate(true);
            this.profiler.b();
        }
        this.profiler.b();
        return true;
    }

    public void initReflection() {
        try {
            this.sortedWorldRenderers = ReflectionHelper.findField(bav.class, (String[])new String[]{"k", "sortedWorldRenderers"});
        }
        catch (Exception e) {
            this.sortedWorldRenderers = null;
            Settings.logger.log(e);
        }
    }

    private void checkDirty() {
        if (this.sortedWorldRenderers != null) {
            try {
                baj[] renderers = (baj[])this.sortedWorldRenderers.get(this.settings.minecraft.f);
                if (renderers != null) {
                    int count = 0;
                    for (baj worldRenderer : renderers) {
                        if (!worldRenderer.q || count++ >= 125) continue;
                        aoe worldRendererBoundingBox = worldRenderer.r.c((double)(-this.settings.offset.x), (double)(-this.settings.offset.y), (double)(-this.settings.offset.z));
                        for (RendererSchematicChunk renderer : this.settings.sortedRendererSchematicChunk) {
                            if (renderer.getDirty() || !renderer.getBoundingBox().a(worldRendererBoundingBox)) continue;
                            renderer.setDirty();
                        }
                    }
                }
            }
            catch (Exception e) {
                Settings.logger.log(e);
            }
        }
    }
}

