/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lunatrius.schematica.Settings;
import net.minecraft.client.Minecraft;

public class SchematicWorld
extends yc {
    private static final ahr anvilSaveHandler = new ahr(Minecraft.b(), "mods/saves-schematica-dummy", false);
    private static final yk worldSettings = new yk(0L, yl.c, false, false, yn.c);
    private static final Comparator blockListComparator = new Comparator(){

        public int compare(ur itemStackA, ur itemStackB) {
            return itemStackA.c * 16 + itemStackA.j() - (itemStackB.c * 16 + itemStackB.j());
        }
    };
    protected static final List blockListIgnoreID = new ArrayList();
    protected static final List blockListIgnoreMetadata = new ArrayList();
    protected static final Map blockListMapping = new HashMap();
    private final Settings settings = Settings.instance();
    private ur icon;
    private int[][][] blocks = null;
    private int[][][] metadata = null;
    private final List tileEntities = new ArrayList();
    private final List blockList = new ArrayList();
    private short width;
    private short length;
    private short height;

    public SchematicWorld() {
        super((aih)anvilSaveHandler, "", null, worldSettings, null);
        this.icon = Settings.defaultIcon.l();
        this.tileEntities.clear();
        this.width = 0;
        this.length = 0;
        this.height = 0;
    }

    public SchematicWorld(String icon, int[][][] blocks, int[][][] metadata, List tileEntities, short width, short height, short length) {
        this();
        try {
            String[] parts = icon.split(":");
            if (parts.length == 1) {
                this.icon = new ur(Integer.parseInt(parts[0]), 1, 0);
            } else if (parts.length == 2) {
                this.icon = new ur(Integer.parseInt(parts[0]), 1, Integer.parseInt(parts[1]));
            }
        }
        catch (Exception e) {
            Settings.logger.log(e);
            this.icon = Settings.defaultIcon.l();
        }
        this.blocks = (int[][][])blocks.clone();
        this.metadata = (int[][][])metadata.clone();
        if (tileEntities != null) {
            this.tileEntities.addAll(tileEntities);
        }
        this.width = width;
        this.length = length;
        this.height = height;
        this.generateBlockList();
    }

    public void readFromNBT(bq tagCompound) {
        if (tagCompound.b("Icon")) {
            this.icon.c(tagCompound.l("Icon"));
        } else {
            this.icon = Settings.defaultIcon.l();
        }
        byte[] localBlocks = tagCompound.j("Blocks");
        byte[] localMetadata = tagCompound.j("Data");
        boolean extra = false;
        byte[] extraBlocks = null;
        extra = tagCompound.b("Add");
        if (extra) {
            extraBlocks = tagCompound.j("Add");
        }
        this.width = tagCompound.d("Width");
        this.length = tagCompound.d("Length");
        this.height = tagCompound.d("Height");
        this.blocks = new int[this.width][this.height][this.length];
        this.metadata = new int[this.width][this.height][this.length];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    this.blocks[x][y][z] = localBlocks[x + (y * this.length + z) * this.width] & 0xFF;
                    this.metadata[x][y][z] = localMetadata[x + (y * this.length + z) * this.width] & 0xFF;
                    if (!extra) continue;
                    int[] nArray = this.blocks[x][y];
                    int n = z;
                    nArray[n] = nArray[n] | (extraBlocks[x + (y * this.length + z) * this.width] & 0xFF) << 8;
                }
            }
        }
        this.tileEntities.clear();
        by tileEntitiesList = tagCompound.m("TileEntities");
        for (int i = 0; i < tileEntitiesList.c(); ++i) {
            any tileEntity = any.c((bq)((bq)tileEntitiesList.b(i)));
            if (tileEntity == null) continue;
            tileEntity.k = this;
            this.tileEntities.add(tileEntity);
        }
        this.refreshChests();
        this.generateBlockList();
    }

    public void writeToNBT(bq tagCompound) {
        bq tagCompoundIcon = new bq();
        this.icon.b(tagCompoundIcon);
        tagCompound.a("Icon", tagCompoundIcon);
        tagCompound.a("Width", this.width);
        tagCompound.a("Length", this.length);
        tagCompound.a("Height", this.height);
        byte[] localBlocks = new byte[this.width * this.length * this.height];
        byte[] localMetadata = new byte[this.width * this.length * this.height];
        byte[] extraBlocks = new byte[this.width * this.length * this.height];
        boolean extra = false;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    localBlocks[x + (y * this.length + z) * this.width] = (byte)this.blocks[x][y][z];
                    localMetadata[x + (y * this.length + z) * this.width] = (byte)this.metadata[x][y][z];
                    extraBlocks[x + (y * this.length + z) * this.width] = (byte)(this.blocks[x][y][z] >> 8);
                    if (extraBlocks[x + (y * this.length + z) * this.width] <= 0) continue;
                    extra = true;
                }
            }
        }
        tagCompound.a("Materials", "Alpha");
        tagCompound.a("Blocks", localBlocks);
        tagCompound.a("Data", localMetadata);
        if (extra) {
            tagCompound.a("Add", extraBlocks);
        }
        tagCompound.a("Entities", (cd)new by());
        by tileEntitiesList = new by();
        for (any tileEntity : this.tileEntities) {
            bq tileEntityTagCompound = new bq();
            tileEntity.b(tileEntityTagCompound);
            tileEntitiesList.a((cd)tileEntityTagCompound);
        }
        tagCompound.a("TileEntities", (cd)tileEntitiesList);
    }

    private void generateBlockList() {
        this.blockList.clear();
        ur itemStack = null;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    int itemID = this.blocks[x][y][z];
                    int itemDamage = this.metadata[x][y][z];
                    if (itemID == 0 || blockListIgnoreID.contains(itemID)) continue;
                    if (blockListIgnoreMetadata.contains(itemID)) {
                        itemDamage = 0;
                    }
                    if (blockListMapping.containsKey(itemID)) {
                        itemID = (Integer)blockListMapping.get(itemID);
                    }
                    if (itemID == amq.M.cm || itemID == amq.N.cm) {
                        itemDamage &= 3;
                    }
                    if (itemID == amq.an.cm || itemID == amq.bR.cm) {
                        itemDamage &= 7;
                    }
                    if (itemID >= 256) {
                        itemDamage = 0;
                    }
                    if (itemID - 256 == amq.bS.cm) {
                        itemDamage = 3;
                    }
                    if (itemID == up.bQ.cj) {
                        itemDamage = this.metadata[x][y][z];
                    }
                    itemStack = null;
                    for (ur block : this.blockList) {
                        if (block.c != itemID || block.j() != itemDamage) continue;
                        itemStack = block;
                        ++itemStack.a;
                        break;
                    }
                    if (itemStack != null) continue;
                    this.blockList.add(new ur(itemID, 1, itemDamage));
                }
            }
        }
        Collections.sort(this.blockList, blockListComparator);
    }

    public int a(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length) {
            return 0;
        }
        return this.blocks[x][y][z] & 0xFFF;
    }

    public any q(int x, int y, int z) {
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            if (((any)this.tileEntities.get((int)i)).l != x || ((any)this.tileEntities.get((int)i)).m != y || ((any)this.tileEntities.get((int)i)).n != z) continue;
            return (any)this.tileEntities.get(i);
        }
        return null;
    }

    public int i(int var1, int var2, int var3, int var4) {
        return 15;
    }

    public float j(int var1, int var2, int var3, int var4) {
        return 1.0f;
    }

    public float p(int x, int y, int z) {
        return 1.0f;
    }

    public int h(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length) {
            return 0;
        }
        return this.metadata[x][y][z];
    }

    public agi g(int x, int y, int z) {
        return this.getBlock(x, y, z) != null ? this.getBlock((int)x, (int)y, (int)z).cB : agi.a;
    }

    public boolean s(int x, int y, int z) {
        if (this.settings.renderingLayer != -1 && this.settings.renderingLayer != y) {
            return false;
        }
        return this.getBlock(x, y, z) != null && this.getBlock(x, y, z).c();
    }

    public boolean t(int x, int y, int z) {
        return this.g(x, y, z).k() && this.getBlock(x, y, z) != null && this.getBlock(x, y, z).b();
    }

    public boolean c(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length) {
            return true;
        }
        return this.blocks[x][y][z] == 0;
    }

    public yy a(int var1, int var2) {
        return yy.f;
    }

    public int O() {
        return this.height + 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean Q() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean v(int var1, int var2, int var3) {
        return false;
    }

    protected zw j() {
        return null;
    }

    public lq a(int var1) {
        return null;
    }

    public boolean f(int x, int y, int z) {
        return false;
    }

    public void setBlockMetadata(int x, int y, int z, byte metadata) {
        this.metadata[x][y][z] = metadata;
    }

    public amq getBlock(int x, int y, int z) {
        return amq.p[this.a(x, y, z)];
    }

    public void setTileEntities(List tileEntities) {
        this.tileEntities.clear();
        this.tileEntities.addAll(tileEntities);
    }

    public List getTileEntities() {
        return this.tileEntities;
    }

    public List getBlockList() {
        return this.blockList;
    }

    public void refreshChests() {
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            any tileEntity = (any)this.tileEntities.get(i);
            if (!(tileEntity instanceof anm)) continue;
            this.checkForAdjacentChests((anm)tileEntity);
        }
    }

    private void checkForAdjacentChests(anm tileEntityChest) {
        tileEntityChest.a = true;
        tileEntityChest.b = null;
        tileEntityChest.c = null;
        tileEntityChest.d = null;
        tileEntityChest.e = null;
        if (this.a(tileEntityChest.l - 1, tileEntityChest.m, tileEntityChest.n) == amq.ax.cm) {
            tileEntityChest.d = (anm)this.q(tileEntityChest.l - 1, tileEntityChest.m, tileEntityChest.n);
        }
        if (this.a(tileEntityChest.l + 1, tileEntityChest.m, tileEntityChest.n) == amq.ax.cm) {
            tileEntityChest.c = (anm)this.q(tileEntityChest.l + 1, tileEntityChest.m, tileEntityChest.n);
        }
        if (this.a(tileEntityChest.l, tileEntityChest.m, tileEntityChest.n - 1) == amq.ax.cm) {
            tileEntityChest.b = (anm)this.q(tileEntityChest.l, tileEntityChest.m, tileEntityChest.n - 1);
        }
        if (this.a(tileEntityChest.l, tileEntityChest.m, tileEntityChest.n + 1) == amq.ax.cm) {
            tileEntityChest.e = (anm)this.q(tileEntityChest.l, tileEntityChest.m, tileEntityChest.n + 1);
        }
    }

    public void flip() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < (this.length + 1) / 2; ++z) {
                    int tmp = this.blocks[x][y][z];
                    this.blocks[x][y][z] = this.blocks[x][y][this.length - 1 - z];
                    this.blocks[x][y][this.length - 1 - z] = tmp;
                    if (z == this.length - 1 - z) {
                        this.metadata[x][y][z] = this.flipMetadataZ(this.metadata[x][y][z], this.blocks[x][y][z]);
                        continue;
                    }
                    tmp = this.metadata[x][y][z];
                    this.metadata[x][y][z] = this.flipMetadataZ(this.metadata[x][y][this.length - 1 - z], this.blocks[x][y][z]);
                    this.metadata[x][y][this.length - 1 - z] = this.flipMetadataZ(tmp, this.blocks[x][y][this.length - 1 - z]);
                }
            }
        }
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            any tileEntity = (any)this.tileEntities.get(i);
            tileEntity.n = this.length - 1 - tileEntity.n;
            tileEntity.p = this.metadata[tileEntity.l][tileEntity.m][tileEntity.n];
            if (!(tileEntity instanceof anw) || tileEntity.p != 1) continue;
            anw skullTileEntity = (anw)tileEntity;
            int angle = skullTileEntity.b();
            int base = 0;
            base = angle <= 7 ? 4 : 12;
            skullTileEntity.a(2 * base - angle & 0xF);
        }
        this.refreshChests();
    }

    private int flipMetadataZ(int blockMetadata, int blockId) {
        if (blockId == amq.at.cm || blockId == amq.aT.cm || blockId == amq.aS.cm) {
            switch (blockMetadata) {
                case 3: {
                    return 4;
                }
                case 4: {
                    return 3;
                }
            }
        } else if (blockId == amq.aJ.cm) {
            switch (blockMetadata) {
                case 4: {
                    return 5;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 9;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 7;
                }
                case 9: {
                    return 6;
                }
            }
        } else if (blockId == amq.X.cm || blockId == amq.W.cm) {
            switch (blockMetadata & 7) {
                case 4: {
                    return (byte)(5 | blockMetadata & 8);
                }
                case 5: {
                    return (byte)(4 | blockMetadata & 8);
                }
            }
        } else if (blockId == amq.aK.cm || blockId == amq.aw.cm || blockId == amq.bz.cm || blockId == amq.bF.cm || blockId == amq.bA.cm || blockId == amq.bT.cm || blockId == amq.bZ.cm || blockId == amq.ca.cm || blockId == amq.cb.cm) {
            switch (blockMetadata & 3) {
                case 2: {
                    return (byte)(3 | blockMetadata & 4);
                }
                case 3: {
                    return (byte)(2 | blockMetadata & 4);
                }
            }
        } else if (blockId == amq.aM.cm) {
            switch (blockMetadata & 7) {
                case 3: {
                    return (byte)(4 | blockMetadata & 8);
                }
                case 4: {
                    return (byte)(3 | blockMetadata & 8);
                }
            }
        } else if (blockId == amq.aH.cm || blockId == amq.aO.cm) {
            if ((blockMetadata & 8) == 8) {
                return (byte)(blockMetadata ^ 1);
            }
            switch (blockMetadata & 3) {
                case 1: {
                    return (byte)(3 | blockMetadata & 0xC);
                }
                case 3: {
                    return (byte)(1 | blockMetadata & 0xC);
                }
            }
        } else if (blockId == amq.aU.cm || blockId == amq.ci.cm) {
            switch (blockMetadata & 7) {
                case 3: {
                    return (byte)(4 | blockMetadata & 8);
                }
                case 4: {
                    return (byte)(3 | blockMetadata & 8);
                }
            }
        } else if (blockId == amq.aG.cm) {
            switch (blockMetadata) {
                case 0: {
                    return 8;
                }
                case 1: {
                    return 7;
                }
                case 2: {
                    return 6;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 3;
                }
                case 6: {
                    return 2;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 0;
                }
                case 9: {
                    return 15;
                }
                case 10: {
                    return 14;
                }
                case 11: {
                    return 13;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 11;
                }
                case 14: {
                    return 10;
                }
                case 15: {
                    return 9;
                }
            }
        } else if (blockId == amq.aI.cm || blockId == amq.aL.cm || blockId == amq.aF.cm || blockId == amq.aE.cm || blockId == amq.S.cm || blockId == amq.ax.cm || blockId == amq.bV.cm) {
            switch (blockMetadata) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 2;
                }
            }
        } else if (blockId == amq.bd.cm || blockId == amq.bi.cm) {
            switch (blockMetadata) {
                case 0: {
                    return 2;
                }
                case 2: {
                    return 0;
                }
            }
        } else if (blockId == amq.V.cm) {
            switch (blockMetadata & 3) {
                case 0: {
                    return (byte)(2 | blockMetadata & 0xC);
                }
                case 2: {
                    return (byte)(0 | blockMetadata & 0xC);
                }
            }
        } else if (blockId == amq.bl.cm || blockId == amq.bk.cm) {
            switch (blockMetadata & 3) {
                case 0: {
                    return (byte)(2 | blockMetadata & 0xC);
                }
                case 2: {
                    return (byte)(0 | blockMetadata & 0xC);
                }
            }
        } else if (blockId == amq.bn.cm) {
            switch (blockMetadata) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
            }
        } else if (blockId == amq.ac.cm || blockId == amq.Y.cm || blockId == amq.ad.cm) {
            switch (blockMetadata & 7) {
                case 2: {
                    return (byte)(3 | blockMetadata & 8);
                }
                case 3: {
                    return (byte)(2 | blockMetadata & 8);
                }
            }
        } else {
            if (blockId == amq.bx.cm) {
                return (byte)(blockMetadata & 0xA | (blockMetadata & 1) << 2 | (blockMetadata & 4) >> 2);
            }
            if (blockId == amq.by.cm) {
                switch (blockMetadata & 3) {
                    case 0: {
                        return (byte)(2 | blockMetadata & 4);
                    }
                    case 2: {
                        return (byte)(0 | blockMetadata & 4);
                    }
                }
            } else if (blockId == amq.bW.cm) {
                switch (blockMetadata & 3) {
                    case 0: {
                        return (byte)(2 | blockMetadata & 0xC);
                    }
                    case 1: {
                        return (byte)(3 | blockMetadata & 0xC);
                    }
                    case 2: {
                        return (byte)(0 | blockMetadata & 0xC);
                    }
                    case 3: {
                        return (byte)(1 | blockMetadata & 0xC);
                    }
                }
            } else if (blockId == amq.bS.cm) {
                switch (blockMetadata & 3) {
                    case 0: {
                        return (byte)(2 | blockMetadata & 0xC);
                    }
                    case 1: {
                        return (byte)(3 | blockMetadata & 0xC);
                    }
                    case 2: {
                        return (byte)(0 | blockMetadata & 0xC);
                    }
                    case 3: {
                        return (byte)(1 | blockMetadata & 0xC);
                    }
                }
            } else if (blockId == amq.ck.cm) {
                switch (blockMetadata & 3) {
                    case 1: {
                        return 3 | blockMetadata & 0xC;
                    }
                    case 3: {
                        return 1 | blockMetadata & 0xC;
                    }
                    case 0: {
                        return 2 | blockMetadata & 0xC;
                    }
                    case 2: {
                        return 0 | blockMetadata & 0xC;
                    }
                }
            } else if (blockId == amq.cj.cm) {
                System.out.println(blockMetadata);
                switch (blockMetadata) {
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 4;
                    }
                }
            }
        }
        return blockMetadata;
    }

    public void rotate() {
        int[][][] localBlocks = new int[this.length][this.height][this.width];
        int[][][] localMetadata = new int[this.length][this.height][this.width];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    localBlocks[z][y][x] = this.blocks[this.width - 1 - x][y][z];
                    localMetadata[z][y][x] = this.rotateMetadata(this.metadata[this.width - 1 - x][y][z], this.blocks[this.width - 1 - x][y][z]);
                }
            }
        }
        this.blocks = localBlocks;
        this.metadata = localMetadata;
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            any tileEntity = (any)this.tileEntities.get(i);
            int coord = tileEntity.l;
            tileEntity.l = tileEntity.n;
            tileEntity.n = this.width - 1 - coord;
            tileEntity.p = this.metadata[tileEntity.l][tileEntity.m][tileEntity.n];
            if (!(tileEntity instanceof anw) || tileEntity.p != 1) continue;
            anw skullTileEntity = (anw)tileEntity;
            skullTileEntity.a(skullTileEntity.b() + 12 & 0xF);
        }
        this.refreshChests();
        short tmp = this.width;
        this.width = this.length;
        this.length = tmp;
    }

    private int rotateMetadata(int blockMetadata, int blockId) {
        if (blockId == amq.at.cm || blockId == amq.aT.cm || blockId == amq.aS.cm) {
            switch (blockMetadata) {
                case 1: {
                    return 4;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
            }
        } else if (blockId == amq.aJ.cm) {
            switch (blockMetadata) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 9;
                }
                case 7: {
                    return 6;
                }
                case 8: {
                    return 7;
                }
                case 9: {
                    return 8;
                }
            }
        } else if (blockId == amq.X.cm || blockId == amq.W.cm) {
            switch (blockMetadata & 7) {
                case 0: {
                    return (byte)(1 | blockMetadata & 8);
                }
                case 1: {
                    return (byte)(0 | blockMetadata & 8);
                }
                case 2: {
                    return (byte)(4 | blockMetadata & 8);
                }
                case 3: {
                    return (byte)(5 | blockMetadata & 8);
                }
                case 4: {
                    return (byte)(3 | blockMetadata & 8);
                }
                case 5: {
                    return (byte)(2 | blockMetadata & 8);
                }
            }
        } else if (blockId == amq.aK.cm || blockId == amq.aw.cm || blockId == amq.bz.cm || blockId == amq.bF.cm || blockId == amq.bA.cm || blockId == amq.bT.cm || blockId == amq.bZ.cm || blockId == amq.ca.cm || blockId == amq.cb.cm) {
            switch (blockMetadata & 3) {
                case 0: {
                    return (byte)(3 | blockMetadata & 4);
                }
                case 1: {
                    return (byte)(2 | blockMetadata & 4);
                }
                case 2: {
                    return (byte)(0 | blockMetadata & 4);
                }
                case 3: {
                    return (byte)(1 | blockMetadata & 4);
                }
            }
        } else if (blockId == amq.aM.cm) {
            switch (blockMetadata & 7) {
                case 1: {
                    return (byte)(4 | blockMetadata & 8);
                }
                case 2: {
                    return (byte)(3 | blockMetadata & 8);
                }
                case 3: {
                    return (byte)(1 | blockMetadata & 8);
                }
                case 4: {
                    return (byte)(2 | blockMetadata & 8);
                }
                case 5: {
                    return (byte)(6 | blockMetadata & 8);
                }
                case 6: {
                    return (byte)(5 | blockMetadata & 8);
                }
            }
        } else if (blockId == amq.aH.cm || blockId == amq.aO.cm) {
            if ((blockMetadata & 8) == 8) {
                return blockMetadata;
            }
            switch (blockMetadata & 3) {
                case 0: {
                    return (byte)(3 | blockMetadata & 0xC);
                }
                case 1: {
                    return (byte)(0 | blockMetadata & 0xC);
                }
                case 2: {
                    return (byte)(1 | blockMetadata & 0xC);
                }
                case 3: {
                    return (byte)(2 | blockMetadata & 0xC);
                }
            }
        } else if (blockId == amq.aU.cm || blockId == amq.ci.cm) {
            switch (blockMetadata & 7) {
                case 1: {
                    return (byte)(4 | blockMetadata & 8);
                }
                case 2: {
                    return (byte)(3 | blockMetadata & 8);
                }
                case 3: {
                    return (byte)(1 | blockMetadata & 8);
                }
                case 4: {
                    return (byte)(2 | blockMetadata & 8);
                }
            }
        } else {
            if (blockId == amq.aG.cm) {
                return (byte)((blockMetadata + 12) % 16);
            }
            if (blockId == amq.aI.cm || blockId == amq.aL.cm || blockId == amq.aF.cm || blockId == amq.aE.cm || blockId == amq.S.cm || blockId == amq.ax.cm || blockId == amq.bV.cm) {
                switch (blockMetadata) {
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 5;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                }
            } else if (blockId == amq.bd.cm || blockId == amq.bi.cm) {
                switch (blockMetadata) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                }
            } else if (blockId == amq.V.cm) {
                switch (blockMetadata & 3) {
                    case 0: {
                        return (byte)(3 | blockMetadata & 0xC);
                    }
                    case 1: {
                        return (byte)(0 | blockMetadata & 0xC);
                    }
                    case 2: {
                        return (byte)(1 | blockMetadata & 0xC);
                    }
                    case 3: {
                        return (byte)(2 | blockMetadata & 0xC);
                    }
                }
            } else if (blockId == amq.bl.cm || blockId == amq.bk.cm) {
                switch (blockMetadata & 3) {
                    case 0: {
                        return (byte)(3 | blockMetadata & 0xC);
                    }
                    case 1: {
                        return (byte)(0 | blockMetadata & 0xC);
                    }
                    case 2: {
                        return (byte)(1 | blockMetadata & 0xC);
                    }
                    case 3: {
                        return (byte)(2 | blockMetadata & 0xC);
                    }
                }
            } else if (blockId == amq.bn.cm) {
                switch (blockMetadata) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else if (blockId == amq.ac.cm || blockId == amq.Y.cm || blockId == amq.ad.cm) {
                switch (blockMetadata & 7) {
                    case 0: {
                        return (byte)(0 | blockMetadata & 8);
                    }
                    case 1: {
                        return (byte)(1 | blockMetadata & 8);
                    }
                    case 2: {
                        return (byte)(4 | blockMetadata & 8);
                    }
                    case 3: {
                        return (byte)(5 | blockMetadata & 8);
                    }
                    case 4: {
                        return (byte)(3 | blockMetadata & 8);
                    }
                    case 5: {
                        return (byte)(2 | blockMetadata & 8);
                    }
                }
            } else {
                if (blockId == amq.bx.cm) {
                    return (byte)(blockMetadata >> 1 | (blockMetadata & 1) << 3);
                }
                if (blockId == amq.by.cm) {
                    switch (blockMetadata & 3) {
                        case 0: {
                            return (byte)(3 | blockMetadata & 4);
                        }
                        case 1: {
                            return (byte)(0 | blockMetadata & 4);
                        }
                        case 2: {
                            return (byte)(1 | blockMetadata & 4);
                        }
                        case 3: {
                            return (byte)(2 | blockMetadata & 4);
                        }
                    }
                } else if (blockId == amq.bW.cm) {
                    switch (blockMetadata & 3) {
                        case 0: {
                            return (byte)(3 | blockMetadata & 0xC);
                        }
                        case 1: {
                            return (byte)(0 | blockMetadata & 0xC);
                        }
                        case 2: {
                            return (byte)(1 | blockMetadata & 0xC);
                        }
                        case 3: {
                            return (byte)(2 | blockMetadata & 0xC);
                        }
                    }
                } else if (blockId == amq.bS.cm) {
                    switch (blockMetadata & 3) {
                        case 0: {
                            return (byte)(3 | blockMetadata & 0xC);
                        }
                        case 1: {
                            return (byte)(0 | blockMetadata & 0xC);
                        }
                        case 2: {
                            return (byte)(1 | blockMetadata & 0xC);
                        }
                        case 3: {
                            return (byte)(2 | blockMetadata & 0xC);
                        }
                    }
                } else if (blockId == amq.M.cm) {
                    switch (blockMetadata & 0xC) {
                        case 4: {
                            return (byte)(8 | blockMetadata & 3);
                        }
                        case 8: {
                            return (byte)(4 | blockMetadata & 3);
                        }
                    }
                } else if (blockId == amq.ck.cm) {
                    switch (blockMetadata & 3) {
                        case 0: {
                            return 3 | blockMetadata & 0xC;
                        }
                        case 1: {
                            return 0 | blockMetadata & 0xC;
                        }
                        case 2: {
                            return 1 | blockMetadata & 0xC;
                        }
                        case 3: {
                            return 2 | blockMetadata & 0xC;
                        }
                    }
                } else if (blockId == amq.cj.cm) {
                    switch (blockMetadata) {
                        case 5: {
                            return 2;
                        }
                        case 2: {
                            return 4;
                        }
                        case 4: {
                            return 3;
                        }
                        case 3: {
                            return 5;
                        }
                    }
                }
            }
        }
        return blockMetadata;
    }

    public int width() {
        return this.width;
    }

    public int length() {
        return this.length;
    }

    public int height() {
        return this.height;
    }
}

