/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

public class ElectricInfo {
    public static double getJoules(double watts, double seconds) {
        return watts * seconds;
    }

    public static double getJoules(double amps, double voltage, double seconds) {
        return amps * voltage * seconds;
    }

    public static double getWattsFromJoules(double joules, double seconds) {
        return joules / seconds;
    }

    public static double getAmps(double watts, double voltage) {
        return watts / voltage;
    }

    public static double getAmps(double ampHours) {
        return ampHours * 3600.0;
    }

    public static double getAmpsFromWattHours(double wattHours, double voltage) {
        return ElectricInfo.getWatts(wattHours) / voltage;
    }

    public static double getWattHoursFromAmpHours(double ampHours, double voltage) {
        return ampHours * voltage;
    }

    public static double getAmpHours(double amps) {
        return amps / 3600.0;
    }

    public static double getWatts(double amps, double voltage) {
        return amps * voltage;
    }

    public static double getWatts(double wattHours) {
        return wattHours * 3600.0;
    }

    public static double getWattHours(double watts) {
        return watts / 3600.0;
    }

    public static double getWattHours(double amps, double voltage) {
        return ElectricInfo.getWattHours(ElectricInfo.getWatts(amps, voltage));
    }

    public static double getResistance(double amps, double voltage) {
        return voltage / amps;
    }

    public static double getConductance(double amps, double voltage) {
        return amps / voltage;
    }

    public static String getDisplay(double value, ElectricUnit unit, int decimalPlaces, boolean isShort) {
        String unitName = unit.name;
        if (isShort) {
            unitName = unit.symbol;
        } else if (value > 1.0) {
            unitName = unit.getPlural();
        }
        if (value == 0.0) {
            return value + " " + unitName;
        }
        if (value <= MeasurementUnit.MILLI.value) {
            return ElectricInfo.roundDecimals(MeasurementUnit.MICRO.process(value), decimalPlaces) + " " + MeasurementUnit.MICRO.getName(isShort) + unitName;
        }
        if (value < 1.0) {
            return ElectricInfo.roundDecimals(MeasurementUnit.MILLI.process(value), decimalPlaces) + " " + MeasurementUnit.MILLI.getName(isShort) + unitName;
        }
        if (value > MeasurementUnit.MEGA.value) {
            return ElectricInfo.roundDecimals(MeasurementUnit.MEGA.process(value), decimalPlaces) + " " + MeasurementUnit.MEGA.getName(isShort) + unitName;
        }
        if (value > MeasurementUnit.KILO.value) {
            return ElectricInfo.roundDecimals(MeasurementUnit.KILO.process(value), decimalPlaces) + " " + MeasurementUnit.KILO.getName(isShort) + unitName;
        }
        return ElectricInfo.roundDecimals(value, decimalPlaces) + " " + unitName;
    }

    public static String getDisplay(double value, ElectricUnit unit) {
        return ElectricInfo.getDisplay(value, unit, 2, false);
    }

    public static String getDisplayShort(double value, ElectricUnit unit) {
        return ElectricInfo.getDisplay(value, unit, 2, true);
    }

    public static String getDisplayShort(double value, ElectricUnit unit, int decimalPlaces) {
        return ElectricInfo.getDisplay(value, unit, decimalPlaces, true);
    }

    public static String getDisplaySimple(double value, ElectricUnit unit, int decimalPlaces) {
        if (value > 1.0) {
            if (decimalPlaces < 1) {
                return (int)value + " " + unit.getPlural();
            }
            return ElectricInfo.roundDecimals(value, decimalPlaces) + " " + unit.getPlural();
        }
        if (decimalPlaces < 1) {
            return (int)value + " " + unit.name;
        }
        return ElectricInfo.roundDecimals(value, decimalPlaces) + " " + unit.name;
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public static double roundDecimals(double d) {
        return ElectricInfo.roundDecimals(d, 2);
    }

    public static enum MeasurementUnit {
        MICRO("Micro", "mi", 1.0E-6),
        MILLI("Milli", "m", 0.001),
        KILO("Kilo", "k", 1000.0),
        MEGA("Mega", "M", 1000000.0);

        public String name;
        public String symbol;
        public double value;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private MeasurementUnit(double name) {
            void value;
            void symbol;
            this.name = (String)name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean isSymbol) {
            if (isSymbol) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double value) {
            return value / this.value;
        }
    }

    public static enum ElectricUnit {
        AMPERE("Amp", "I"),
        AMP_HOUR("Amp Hour", "Ah"),
        VOLTAGE("Volt", "V"),
        WATT("Watt", "W"),
        WATT_HOUR("Watt Hour", "Wh"),
        RESISTANCE("Ohm", "R"),
        CONDUCTANCE("Siemen", "S"),
        JOULES("Joule", "J");

        public String name;
        public String symbol;

        /*
         * WARNING - void declaration
         */
        private ElectricUnit() {
            void symbol;
            void name;
            this.name = name;
            this.symbol = symbol;
        }

        public String getPlural() {
            return this.name + "s";
        }
    }
}

