/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.signals.AbstractPair;
import railcraft.common.api.signals.IControllerTile;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SignalReceiver;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.RailcraftPacket;

public class PacketPairUpdate
extends RailcraftPacket {
    private AbstractPair pairing;
    private RailcraftPacket.PacketType packetType;

    public PacketPairUpdate(RailcraftPacket.PacketType packetType) {
        this.packetType = packetType;
    }

    public PacketPairUpdate(AbstractPair pairing) {
        this.pairing = pairing;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.pairing.getTile().l);
        data.writeInt(this.pairing.getTile().m);
        data.writeInt(this.pairing.getTile().n);
        Collection pairs = this.pairing.getPairs();
        data.writeByte(pairs.size());
        for (WorldCoordinate coord : pairs) {
            data.writeInt(coord.x);
            data.writeInt(coord.y);
            data.writeInt(coord.z);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStream data) throws IOException {
        yc world = Game.getWorld();
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        any tile = world.q(x, y, z);
        if (this.packetType == RailcraftPacket.PacketType.CONTROLLER_UPDATE) {
            if (tile instanceof IControllerTile) {
                this.pairing = ((IControllerTile)tile).getController();
            }
        } else if (this.packetType == RailcraftPacket.PacketType.RECEIVER_UPDATE && tile instanceof IReceiverTile) {
            this.pairing = ((IReceiverTile)tile).getReceiver();
        }
        if (this.pairing != null) {
            try {
                this.pairing.clearPairings();
            }
            catch (Throwable error) {
                Game.logErrorAPI("Railcraft", error);
            }
            int size = data.readByte();
            for (int i = 0; i < size; ++i) {
                this.pairing.addPair(data.readInt(), data.readInt(), data.readInt());
            }
        }
    }

    @Override
    public int getID() {
        if (this.pairing instanceof SignalController) {
            return RailcraftPacket.PacketType.CONTROLLER_UPDATE.ordinal();
        }
        if (this.pairing instanceof SignalReceiver) {
            return RailcraftPacket.PacketType.RECEIVER_UPDATE.ordinal();
        }
        return -1;
    }
}

