/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.misc;

import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.MiscTools;

public enum EnumColor {
    BLACK(0x2D2D2D),
    RED(10696757),
    GREEN(3755038),
    BROWN(6044196),
    BLUE(3424674),
    PURPLE(8667071),
    CYAN(3571870),
    LIGHT_GRAY(0x888888),
    GRAY(0x444444),
    PINK(15041952),
    LIME(4172342),
    YELLOW(13615665),
    LIGHT_BLUE(8362705),
    MAGENTA(0xFF64FF),
    ORANGE(16738816),
    WHITE(0xFFFFFF);

    public static final EnumColor[] VALUES;
    public static final String[] DYES;
    private final int color;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumColor() {
        void color;
        this.color = color;
    }

    public int getHexColor() {
        return this.color;
    }

    public static EnumColor fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return WHITE;
        }
        return VALUES[id];
    }

    public static EnumColor fromDye(String dyeTag) {
        for (int id = 0; id < DYES.length; ++id) {
            if (!DYES[id].equals(dyeTag)) continue;
            return VALUES[id];
        }
        return null;
    }

    public static EnumColor getRand() {
        return VALUES[MiscTools.getRand().nextInt(VALUES.length)];
    }

    public String getTag() {
        return "color." + this.name().replace("_", ".").toLowerCase();
    }

    public String getBasicTag() {
        return this.name().replace("_", ".").toLowerCase();
    }

    public String getTranslatedName() {
        return RailcraftLanguage.translate(this.getTag());
    }

    public String getDye() {
        return DYES[this.ordinal()];
    }

    public String toString() {
        String s = this.name().replace("_", " ");
        String[] words = s.split(" ");
        StringBuilder b = new StringBuilder();
        for (String word : words) {
            b.append(word.charAt(0)).append(word.substring(1).toLowerCase()).append(" ");
        }
        return b.toString().trim();
    }

    static {
        VALUES = EnumColor.values();
        DYES = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    }
}

