/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.craftguide;

import java.text.DecimalFormat;
import java.util.List;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.SlotType;

public class FloatChanceSlot
extends ItemSlot {
    private String formatString = " (###.###% chance)";

    public FloatChanceSlot(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public FloatChanceSlot(int x, int y, int width, int height, boolean drawQuantity) {
        super(x, y, width, height, drawQuantity);
    }

    @Override
    public void draw(Renderer renderer, int x, int y, Object[] data, int dataIndex, boolean isMouseOver) {
        implementation.draw(this, renderer, x, y, this.stack(data, dataIndex), isMouseOver);
    }

    @Override
    public List getTooltip(int x, int y, Object[] data, int dataIndex) {
        if (data[dataIndex] == null || this.stack(data, dataIndex) == null) {
            return implementation.getTooltip(this, null);
        }
        List tooltip = implementation.getTooltip(this, this.stack(data, dataIndex));
        float probability = ((Float)((Object[])data[dataIndex])[1]).floatValue();
        tooltip.set(0, (String)tooltip.get(0) + new DecimalFormat(this.formatString).format(probability));
        return tooltip;
    }

    @Override
    public boolean matches(ItemFilter search, Object[] data, int dataIndex, SlotType type) {
        return implementation.matches(this, search, this.stack(data, dataIndex), type);
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
        return implementation.getClickedFilter(x, y, this.stack(data, dataIndex));
    }

    private Object stack(Object[] data, int dataIndex) {
        return data[dataIndex] != null ? ((Object[])data[dataIndex])[0] : null;
    }

    public FloatChanceSlot setFormatString(String format) {
        this.formatString = format;
        return this;
    }
}

