/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.modules;

import java.io.File;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import railcraft.common.core.Railcraft;
import railcraft.common.modules.ModuleAutomation;
import railcraft.common.modules.ModuleChunkLoading;
import railcraft.common.modules.ModuleCore;
import railcraft.common.modules.ModuleEnergy;
import railcraft.common.modules.ModuleExtras;
import railcraft.common.modules.ModuleFactory;
import railcraft.common.modules.ModuleForestry;
import railcraft.common.modules.ModuleIC2;
import railcraft.common.modules.ModuleLocomotives;
import railcraft.common.modules.ModuleSeasonal;
import railcraft.common.modules.ModuleSignals;
import railcraft.common.modules.ModuleStructures;
import railcraft.common.modules.ModuleTrack;
import railcraft.common.modules.ModuleTracksHighSpeed;
import railcraft.common.modules.ModuleTracksReinforced;
import railcraft.common.modules.ModuleTracksWood;
import railcraft.common.modules.ModuleTrain;
import railcraft.common.modules.ModuleTransport;
import railcraft.common.modules.ModuleWorld;
import railcraft.common.modules.RailcraftModule;
import railcraft.common.util.misc.Game;

public abstract class ModuleManager {
    public static final String MODULE_CONFIG_FILE_NAME = "modules.cfg";
    public static final String CATEGORY_MODULES = "modules";
    private static Map modules = new EnumMap(Module.class);
    private static Set loadedModules = EnumSet.noneOf(Module.class);
    private static Set unloadedModules = EnumSet.noneOf(Module.class);

    public static void preInit() {
        ModuleManager.registerModule(Module.CORE, new ModuleCore());
        ModuleManager.registerModule(Module.AUTOMATION, new ModuleAutomation());
        ModuleManager.registerModule(Module.SIGNALS, new ModuleSignals());
        ModuleManager.registerModule(Module.STRUCTURES, new ModuleStructures());
        ModuleManager.registerModule(Module.EXTRAS, new ModuleExtras());
        ModuleManager.registerModule(Module.FACTORY, new ModuleFactory());
        ModuleManager.registerModule(Module.TRANSPORT, new ModuleTransport());
        ModuleManager.registerModule(Module.TRACKS, new ModuleTrack());
        ModuleManager.registerModule(Module.TRACKS_HIGHSPEED, new ModuleTracksHighSpeed());
        ModuleManager.registerModule(Module.TRACKS_WOOD, new ModuleTracksWood());
        ModuleManager.registerModule(Module.TRACKS_REINFORCED, new ModuleTracksReinforced());
        ModuleManager.registerModule(Module.IC2, new ModuleIC2());
        ModuleManager.registerModule(Module.FORESTRY, new ModuleForestry());
        ModuleManager.registerModule(Module.ENERGY, new ModuleEnergy());
        ModuleManager.registerModule(Module.WORLD, new ModuleWorld());
        ModuleManager.registerModule(Module.CHUNK_LOADING, new ModuleChunkLoading());
        ModuleManager.registerModule(Module.SEASONAL, new ModuleSeasonal());
        ModuleManager.registerModule(Module.TRAIN, new ModuleTrain());
        ModuleManager.registerModule(Module.LOCOMOTIVES, new ModuleLocomotives());
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        Configuration config = new Configuration(new File(Railcraft.getMod().getConfigFolder(), MODULE_CONFIG_FILE_NAME));
        config.load();
        config.addCustomCategoryComment(CATEGORY_MODULES, "Disabling these modules can greatly change how the mod functions.\nFor example, disabling the Train Module will prevent you from linking carts.\nDisabling the World Module will disable all world gen.\nDisabling the Energy Module will remove the energy requirement from machines, but will only do so if Forestry or Buildcraft are not installed.");
        config.categories.remove("block");
        config.categories.remove("item");
        config.categories.remove("general");
        for (Module m : Module.values()) {
            if (m == Module.CORE || ModuleManager.isEnabled(config, m)) {
                RailcraftModule instance = (RailcraftModule)modules.get((Object)m);
                if (instance.canModuleLoad()) {
                    loadedModules.add(m);
                    continue;
                }
                unloadedModules.add(m);
                instance.printLoadError();
                continue;
            }
            unloadedModules.add(m);
            Game.log(Level.FINER, "Module disabled: {0}", new Object[]{m});
        }
        config.save();
        Locale.setDefault(locale);
        for (Module m : loadedModules) {
            ModuleManager.preInit(m);
        }
    }

    public static void init() {
        for (Module m : loadedModules) {
            ModuleManager.initFirst(m);
        }
        for (Module m : loadedModules) {
            ModuleManager.initSecond(m);
        }
    }

    public static void postInit() {
        for (Module m : loadedModules) {
            ModuleManager.postInit(m);
        }
        for (Module m : unloadedModules) {
            ModuleManager.postInitNotLoaded(m);
        }
    }

    private static boolean isEnabled(Configuration config, Module m) {
        boolean defaultValue = true;
        Property prop = config.get(CATEGORY_MODULES, m.toString().toLowerCase().replace('_', '.'), defaultValue);
        return Boolean.valueOf(prop.value);
    }

    public static boolean isModuleLoaded(Module module) {
        return loadedModules.contains((Object)module);
    }

    private static void registerModule(Module module, RailcraftModule instance) {
        modules.put(module, instance);
    }

    private static void preInit(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("preInit", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Pre-Init Start: {0}", instance);
                instance.preInit();
                Game.log(Level.FINER, "Pre-Init Complete: {0}", instance);
            }
        }
    }

    private static void initFirst(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("initFirst", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Init-First Start: {0}", instance);
                instance.initFirst();
                Game.log(Level.FINER, "Init-First Complete: {0}", instance);
            }
        }
    }

    private static void initSecond(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("initSecond", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Init-Second Start: {0}", instance);
                instance.initSecond();
                Game.log(Level.FINER, "Init-Second Complete: {0}", instance);
            }
        }
    }

    private static void postInit(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("postInit", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Post-Init Start: {0}", instance);
                instance.postInit();
                Game.log(Level.FINER, "Post-Init Complete: {0}", instance);
            }
        }
    }

    private static void postInitNotLoaded(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("postInitNotLoaded", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Disabled-Init Start: {0}", instance);
                instance.postInitNotLoaded();
                Game.log(Level.FINER, "Disabled-Init Complete: {0}", instance);
            }
        }
    }

    public static enum Module {
        CORE,
        FACTORY,
        EXTRAS,
        TRACKS,
        TRACKS_HIGHSPEED,
        TRACKS_WOOD,
        TRACKS_REINFORCED,
        SIGNALS,
        STRUCTURES,
        AUTOMATION,
        TRANSPORT,
        IC2,
        FORESTRY,
        ENERGY,
        WORLD,
        CHUNK_LOADING,
        SEASONAL,
        TRAIN,
        LOCOMOTIVES;

    }
}

