/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.util.List;
import java.util.Random;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.tracks.RailTools;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.tracks.TrackSpeed;
import railcraft.common.carts.CartUtils;
import railcraft.common.carts.EntityTunnelBore;
import railcraft.common.carts.LinkageManager;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.misc.Vec2D;

public final class MinecartHooks
implements IMinecartCollisionHandler {
    protected static float DRAG_FACTOR_GROUND = 0.5f;
    protected static float DRAG_FACTOR_AIR = 0.99999f;
    protected static float OPTIMAL_DISTANCE = 1.28f;
    protected static float COEF_SPRING = 0.2f;
    protected static float COEF_SPRING_PLAYER = 0.5f;
    protected static float COEF_RESTITUTION = 0.2f;
    protected static float COEF_DAMPING = 0.4f;
    protected static float ENTITY_REDUCTION = 0.25f;
    protected static float CART_LENGTH = 1.22f;
    protected static float CART_WIDTH = 0.98f;
    protected static float COLLISION_EXPANSION = 0.2f;
    protected static int MAX_INTERACT_DIST_SQ = 25;
    private Random rand = new Random();
    private static MinecartHooks instance;

    private MinecartHooks() {
    }

    public static MinecartHooks getInstance() {
        if (instance == null) {
            instance = new MinecartHooks();
        }
        return instance;
    }

    public void onEntityCollision(py cart, lq other) {
        int mountPrevention;
        if (Game.isNotHost(cart.p) || other == cart.n || other.L) {
            return;
        }
        LinkageManager lm = LinkageManager.getInstance(cart.p);
        py link = lm.getLinkedCartA(cart);
        if (link != null && (link == other || other == link.n)) {
            return;
        }
        link = lm.getLinkedCartB(cart);
        if (link != null && (link == other || other == link.n)) {
            return;
        }
        boolean isLiving = other instanceof md;
        boolean isPlayer = other instanceof qx;
        if (isLiving && !isPlayer && cart.canBeRidden() && !(other instanceof pi) && cart.w * cart.w + cart.y * cart.y > 0.001 && cart.n == null && other.o == null && (mountPrevention = cart.getEntityData().e("MountPrevention")) <= 0) {
            other.a((lq)cart);
        }
        int i = ke.c((double)cart.t);
        int j = ke.c((double)cart.u);
        int k = ke.c((double)cart.v);
        int id = cart.p.a(i, j, k);
        if (isLiving && RailcraftBlocks.getBlockElevator() != null && id == RailcraftBlocks.getBlockElevator().cm) {
            return;
        }
        Vec2D cartPos = new Vec2D(cart.t, cart.v);
        Vec2D otherPos = new Vec2D(other.t, other.v);
        Vec2D unit = Vec2D.subtract(otherPos, cartPos);
        unit.normalize();
        double distance = cart.d(other);
        double depth = distance - (double)OPTIMAL_DISTANCE;
        double forceX = 0.0;
        double forceZ = 0.0;
        if (depth < 0.0) {
            double spring = isPlayer ? (double)COEF_SPRING_PLAYER : (double)COEF_SPRING;
            double penaltyX = spring * depth * unit.getX();
            double penaltyZ = spring * depth * unit.getY();
            forceX += penaltyX;
            forceZ += penaltyZ;
            if (!isPlayer) {
                double impulseX = unit.getX();
                double impulseZ = unit.getY();
                impulseX *= -(1.0 + (double)COEF_RESTITUTION);
                impulseZ *= -(1.0 + (double)COEF_RESTITUTION);
                Vec2D cartVel = new Vec2D(cart.w, cart.y);
                Vec2D otherVel = new Vec2D(other.w, other.y);
                double dot = Vec2D.subtract(otherVel, cartVel).dotProduct(unit);
                impulseX *= dot;
                impulseZ *= dot;
                forceX -= (impulseX *= 0.5);
                forceZ -= (impulseZ *= 0.5);
            }
        }
        if (other instanceof py) {
            py otherCart = (py)other;
            if (!(cart.isPoweredCart() && !otherCart.isPoweredCart() || RailTools.isCartLockedDown(cart))) {
                cart.g(forceX, 0.0, forceZ);
            }
            if (!(otherCart.isPoweredCart() && !cart.isPoweredCart() || RailTools.isCartLockedDown(otherCart))) {
                other.g(-forceX, 0.0, -forceZ);
            }
        } else {
            Vec2D cartVel = new Vec2D(cart.w + forceX, cart.y + forceZ);
            Vec2D otherVel = new Vec2D(other.w - forceX, other.y - forceZ);
            double dot = Vec2D.subtract(otherVel, cartVel).dotProduct(unit);
            double dampX = (double)COEF_DAMPING * dot * unit.getX();
            double dampZ = (double)COEF_DAMPING * dot * unit.getY();
            forceX += dampX;
            forceZ += dampZ;
            if (!isPlayer) {
                other.g(-forceX, 0.0, -forceZ);
            }
            if (!RailTools.isCartLockedDown(cart)) {
                cart.g(forceX, 0.0, forceZ);
            }
        }
    }

    public aoe getCollisionBox(py cart, lq other) {
        if (other instanceof px && RailcraftConfig.doCartsCollideWithItems()) {
            return other.D;
        }
        if (other instanceof qx) {
            return other.M() ? other.D : null;
        }
        return null;
    }

    public aoe getMinecartCollisionBox(py cart) {
        return this.getMinecartCollisionBox(cart, COLLISION_EXPANSION);
    }

    private aoe getMinecartCollisionBox(py cart, float expand) {
        double yaw = Math.toRadians(cart.z);
        double diff = (double)(CART_LENGTH - CART_WIDTH) / 2.0 + (double)expand;
        double x = diff * Math.abs(Math.cos(yaw));
        double z = diff * Math.abs(Math.sin(yaw));
        return cart.D.b(x, (double)expand, z);
    }

    public aoe getBoundingBox(py cart) {
        if (cart == null) {
            return null;
        }
        if (RailcraftConfig.areCartsSolid()) {
            return cart.D;
        }
        return null;
    }

    private void land(py cart) {
        cart.getEntityData().a("Launched", 0);
        cart.setMaxSpeedAirLateral(py.defaultMaxSpeedAirLateral);
        cart.setMaxSpeedAirVertical(py.defaultMaxSpeedAirVertical);
        cart.setDragAir(py.defaultDragAir);
    }

    @ForgeSubscribe
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        byte elevator;
        int mountPrevention;
        py cart = event.minecart;
        bq data = cart.getEntityData();
        int x = (int)event.x;
        int y = (int)event.y;
        int z = (int)event.z;
        int id = cart.p.a(x, y, z);
        int launched = data.e("Launched");
        if (alr.e((int)id)) {
            cart.S = 0.0f;
            if (cart.n != null) {
                cart.n.S = 0.0f;
            }
            if (launched > 1) {
                this.land(cart);
            }
        } else if (launched == 1) {
            data.a("Launched", 2);
            cart.setCanUseRail(true);
        } else if (launched > 1 && (cart.E || cart.a(agi.q))) {
            this.land(cart);
        }
        if ((mountPrevention = data.e("MountPrevention")) > 0) {
            data.a("MountPrevention", --mountPrevention);
        }
        if ((elevator = data.c("elevator")) > 0) {
            elevator = (byte)(elevator - 1);
            data.a("elevator", elevator);
        }
        if (data.n("explode")) {
            cart.getEntityData().a("explode", false);
            CartUtils.explodeCart(cart);
        }
        if (data.n("HighSpeed")) {
            if (CartUtils.cartVelocityIsLessThan(cart, 0.39f)) {
                data.a("HighSpeed", false);
            } else if (!TrackSpeed.isTrackHighSpeedCapable(cart.p, x, y, z)) {
                CartUtils.explodeCart(cart);
            }
        }
        cart.w = Math.copySign(Math.min(Math.abs(cart.w), 9.5), cart.w);
        cart.x = Math.copySign(Math.min(Math.abs(cart.x), 9.5), cart.x);
        cart.y = Math.copySign(Math.min(Math.abs(cart.y), 9.5), cart.y);
    }

    @ForgeSubscribe
    public void onMinecartEntityCollision(MinecartCollisionEvent event) {
        List carts;
        py cart = event.minecart;
        lq other = event.collider;
        if (other == cart.n) {
            return;
        }
        this.testHighSpeedCollision(cart, other);
        int i = ke.c((double)cart.t);
        int j = ke.c((double)cart.u);
        int k = ke.c((double)cart.v);
        if (py.getCollisionHandler() != this && other instanceof md && RailcraftBlocks.getBlockElevator() != null && cart.p.a(i, j, k) == RailcraftBlocks.getBlockElevator().cm && other.D.b < cart.D.e) {
            other.d(0.0, cart.D.e - other.D.b, 0.0);
            other.E = true;
        }
        if (MiscTools.getRand().nextFloat() < 0.001f && (carts = CartTools.getMinecartsAt(cart.p, i, j, k, 0.0f)).size() > 5) {
            this.primeToExplode(cart);
        }
    }

    private void testHighSpeedCollision(py cart, lq other) {
        boolean highSpeed = cart.getEntityData().n("HighSpeed");
        if (highSpeed) {
            LinkageManager lm = LinkageManager.getInstance(cart.p);
            if (other instanceof py && lm.areLinked(cart, (py)other)) {
                return;
            }
            py link = lm.getLinkedCartA(cart);
            if (link != null && other == link.n) {
                return;
            }
            link = lm.getLinkedCartB(cart);
            if (link != null && other == link.n) {
                return;
            }
            if (other instanceof py) {
                boolean otherHighSpeed = other.getEntityData().n("HighSpeed");
                if (!otherHighSpeed || cart.w > 0.0 ^ other.w > 0.0 || cart.y > 0.0 ^ other.y > 0.0) {
                    this.primeToExplode(cart);
                }
            } else {
                this.primeToExplode(cart);
            }
        }
    }

    private void primeToExplode(py cart) {
        cart.getEntityData().a("explode", true);
    }

    @ForgeSubscribe
    public void onMinecartInteract(MinecartInteractEvent event) {
        py cart = event.minecart;
        qx player = event.player;
        if (CartTools.getCartOwner(cart).equals("[Railcraft]") || CartTools.getCartOwner(cart).equals("")) {
            CartTools.setCartOwner(cart, player);
        }
        if (!(cart instanceof EntityTunnelBore) && player.e((lq)cart) > (double)MAX_INTERACT_DIST_SQ) {
            event.setCanceled(true);
            return;
        }
        if (cart.L) {
            event.setCanceled(true);
            return;
        }
        if (cart.canBeRidden()) {
            if (cart.n != null && player.o != cart) {
                event.setCanceled(true);
                return;
            }
            if (player.o != null && player.o != cart) {
                event.setCanceled(true);
                return;
            }
            if (player.o != cart && player.g_()) {
                event.setCanceled(true);
                return;
            }
        }
        if (!player.n((lq)cart)) {
            event.setCanceled(true);
            return;
        }
    }
}

