/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import railcraft.common.api.carts.ILinkableCart;
import railcraft.common.api.carts.IMinecart;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.api.tracks.RailTools;
import railcraft.common.carts.LinkageManager;
import railcraft.common.modules.ModuleManager;
import railcraft.common.util.misc.Vec2D;

public class LinkageHandler {
    public static final String LINK_A_TIMER = "linkA_timer";
    public static final String LINK_B_TIMER = "linkB_timer";
    public static final double LINK_DRAG = 0.9;
    public static final float MAX_DISTANCE = 8.0f;
    private static final float STIFFNESS = 0.7f;
    private static final float HS_STIFFNESS = 0.7f;
    private static final float DAMPING = 0.4f;
    private static final float HS_DAMPING = 0.3f;
    private static final float FORCE_LIMITER = 6.0f;
    private static LinkageHandler instance;

    private LinkageHandler() {
    }

    public static LinkageHandler getInstance() {
        if (instance == null) {
            instance = new LinkageHandler();
        }
        return instance;
    }

    private float getOptimalDistance(py cart1, py cart2) {
        float dist = 0.0f;
        dist = cart1 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart1).getOptimalDistance(cart2)) : (dist += 0.78f);
        dist = cart2 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart2).getOptimalDistance(cart1)) : (dist += 0.78f);
        return dist;
    }

    private boolean canCartBeAdjustedBy(py cart1, py cart2) {
        if (cart1 == cart2) {
            return false;
        }
        if (cart1 instanceof ILinkableCart && !((ILinkableCart)cart1).canBeAdjusted(cart2)) {
            return false;
        }
        return !RailTools.isCartLockedDown(cart1);
    }

    protected void adjustVelocity(py cart1, py cart2, char link) {
        String timer = LINK_A_TIMER;
        if (link == 'B') {
            timer = LINK_B_TIMER;
        }
        if (cart1.p.u.h != cart2.p.u.h) {
            short count = cart1.getEntityData().d(timer);
            if ((count = (short)(count + 1)) > 200) {
                LinkageManager.getInstance(cart1.p).breakLink(cart1, cart2);
            }
            cart1.getEntityData().a(timer, count);
            return;
        }
        cart1.getEntityData().a(timer, (short)0);
        double dist = cart1.d((lq)cart2);
        if (dist > 8.0) {
            LinkageManager.getInstance(cart1.p).breakLink(cart1, cart2);
            return;
        }
        boolean adj1 = this.canCartBeAdjustedBy(cart1, cart2);
        boolean adj2 = this.canCartBeAdjustedBy(cart2, cart1);
        Vec2D cart1Pos = new Vec2D(cart1.t, cart1.v);
        Vec2D cart2Pos = new Vec2D(cart2.t, cart2.v);
        Vec2D unit = Vec2D.subtract(cart2Pos, cart1Pos);
        unit.normalize();
        float optDist = this.getOptimalDistance(cart1, cart2);
        double stretch = dist - (double)optDist;
        boolean highSpeed = cart1.getEntityData().n("HighSpeed");
        double stiffness = highSpeed ? (double)0.7f : (double)0.7f;
        double springX = stiffness * stretch * unit.getX();
        double springZ = stiffness * stretch * unit.getY();
        springX = this.limitForce(springX);
        springZ = this.limitForce(springZ);
        if (adj1) {
            cart1.w += springX;
            cart1.y += springZ;
        }
        if (adj2) {
            cart2.w -= springX;
            cart2.y -= springZ;
        }
        Vec2D cart1Vel = new Vec2D(cart1.w, cart1.y);
        Vec2D cart2Vel = new Vec2D(cart2.w, cart2.y);
        double dot = Vec2D.subtract(cart2Vel, cart1Vel).dotProduct(unit);
        double damping = highSpeed ? (double)0.3f : (double)0.4f;
        double dampX = damping * dot * unit.getX();
        double dampZ = damping * dot * unit.getY();
        dampX = this.limitForce(dampX);
        dampZ = this.limitForce(dampZ);
        if (adj1) {
            cart1.w += dampX;
            cart1.y += dampZ;
        }
        if (adj2) {
            cart2.w -= dampX;
            cart2.y -= dampZ;
        }
    }

    private float getTrainMaxSpeed(py cart) {
        LinkageManager lm = LinkageManager.getInstance(cart.p);
        py linkA = lm.getLinkedCartA(cart);
        py linkB = lm.getLinkedCartB(cart);
        float speed = cart.getMaxSpeedRail();
        if (cart instanceof IMinecart) {
            speed = ((IMinecart)cart).getCartMaxSpeed();
        }
        float min1 = speed;
        min1 = Math.min(min1, this.getTrainMaxSpeedRecursive(linkA, cart));
        float min2 = speed;
        min2 = Math.min(min2, this.getTrainMaxSpeedRecursive(linkB, cart));
        return Math.min(min1, min2);
    }

    private float getTrainMaxSpeedRecursive(py cart, py prev) {
        if (cart == null) {
            return Float.MAX_VALUE;
        }
        LinkageManager lm = LinkageManager.getInstance(cart.p);
        py linkA = lm.getLinkedCartA(cart);
        py linkB = lm.getLinkedCartB(cart);
        float speed = cart.getMaxSpeedRail();
        if (cart instanceof IMinecart) {
            speed = ((IMinecart)cart).getCartMaxSpeed();
        }
        float min1 = speed;
        if (linkA != prev) {
            min1 = Math.min(min1, this.getTrainMaxSpeedRecursive(linkA, cart));
        }
        float min2 = speed;
        if (linkB != prev) {
            min2 = Math.min(min2, this.getTrainMaxSpeedRecursive(linkB, cart));
        }
        return Math.min(min1, min2);
    }

    private void setTrainMaxSpeed(py cart, float trainSpeed) {
        LinkageManager lm = LinkageManager.getInstance(cart.p);
        py linkA = lm.getLinkedCartA(cart);
        py linkB = lm.getLinkedCartB(cart);
        this.setTrainMaxSpeedRecursive(linkA, cart, trainSpeed);
        this.setTrainMaxSpeedRecursive(linkB, cart, trainSpeed);
        if (cart instanceof IMinecart) {
            ((IMinecart)cart).setTrainSpeed(trainSpeed);
        } else {
            cart.setMaxSpeedRail(trainSpeed);
        }
    }

    private void setTrainMaxSpeedRecursive(py cart, py prev, float trainSpeed) {
        if (cart == null) {
            return;
        }
        LinkageManager lm = LinkageManager.getInstance(cart.p);
        py linkA = lm.getLinkedCartA(cart);
        py linkB = lm.getLinkedCartB(cart);
        if (linkA != prev) {
            this.setTrainMaxSpeedRecursive(linkA, cart, trainSpeed);
        }
        if (linkB != prev) {
            this.setTrainMaxSpeedRecursive(linkB, cart, trainSpeed);
        }
        if (cart instanceof IMinecart) {
            ((IMinecart)cart).setTrainSpeed(trainSpeed);
        } else {
            cart.setMaxSpeedRail(trainSpeed);
        }
    }

    private double limitForce(double force) {
        return Math.copySign(Math.min(Math.abs(force), 6.0), force);
    }

    @ForgeSubscribe
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        py link_B;
        py cart = event.minecart;
        LinkageManager lm = LinkageManager.getInstance(cart.p);
        if (cart.L) {
            lm.breakLinks(cart);
            lm.removeLinkageId(cart);
            return;
        }
        lm.getLinkageId(cart);
        int launched = cart.getEntityData().e("Launched");
        if (launched > 0) {
            return;
        }
        if (this.isOnElevator(cart)) {
            return;
        }
        boolean linked = false;
        py link_A = lm.getLinkedCartA(cart);
        if (link_A != null) {
            launched = link_A.getEntityData().e("Launched");
            if (link_A.L) {
                lm.breakLinkA(cart);
                lm.removeLinkageId(link_A);
            } else if (launched <= 0 && !this.isOnElevator(link_A)) {
                linked = true;
                this.adjustVelocity(cart, link_A, 'A');
            }
        }
        if ((link_B = lm.getLinkedCartB(cart)) != null) {
            launched = link_B.getEntityData().e("Launched");
            if (link_B.L) {
                lm.breakLinkB(cart);
                lm.removeLinkageId(link_B);
            } else if (launched <= 0 && !this.isOnElevator(link_B)) {
                linked = true;
                this.adjustVelocity(cart, link_B, 'B');
            }
        }
        if (linked && ModuleManager.isModuleLoaded(ModuleManager.Module.LOCOMOTIVES)) {
            cart.w *= 0.9;
            cart.y *= 0.9;
        }
        if (link_A == null && link_B != null || link_A != null && link_B == null) {
            float trainSpeed = this.getTrainMaxSpeed(cart);
            this.setTrainMaxSpeed(cart, trainSpeed);
        } else if (link_A == null && link_B == null) {
            this.setTrainMaxSpeed(cart, 1.2f);
        }
    }

    @ForgeSubscribe
    public void onMinecartInteract(MinecartInteractEvent event) {
        qx player = event.player;
        if (player.bS() != null && player.bS().b() instanceof IToolCrowbar) {
            event.setCanceled(true);
        }
    }

    private boolean isOnElevator(py cart) {
        byte elevator = cart.getEntityData().c("elevator");
        return elevator > 0;
    }
}

