/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.carts.EntityCartAnchor;
import railcraft.common.carts.EntityCartAnchorPersonal;
import railcraft.common.carts.EntityCartBasic;
import railcraft.common.carts.EntityCartChest;
import railcraft.common.carts.EntityCartEnergy;
import railcraft.common.carts.EntityCartFurnace;
import railcraft.common.carts.EntityCartGift;
import railcraft.common.carts.EntityCartPumpkin;
import railcraft.common.carts.EntityCartTNT;
import railcraft.common.carts.EntityCartTank;
import railcraft.common.carts.EntityCartTrackRelayer;
import railcraft.common.carts.EntityCartUndercutter;
import railcraft.common.carts.EntityCartWork;
import railcraft.common.carts.EntityLocomotiveSteam;
import railcraft.common.carts.ItemCartAnchor;

public enum EnumCart {
    BASIC(1, 135, EntityCartBasic.class, null),
    CHEST(2, 151, EntityCartChest.class, new ur(amq.ax)),
    FURNACE(3, 167, EntityCartFurnace.class, new ur(amq.aE)),
    TNT(4, 193, EntityCartTNT.class, new ur(amq.ap)),
    TANK(5, 192, EntityCartTank.class, new ur(amq.P, 8)),
    BATBOX(6, 198, EntityCartEnergy.class, null),
    MFE(6, 199, EntityCartEnergy.class, null),
    MFSU(6, 200, EntityCartEnergy.class, null),
    ANCHOR(7, 197, EntityCartAnchor.class, null),
    WORK(8, 196, EntityCartWork.class, new ur(amq.aB)),
    TRACK_RELAYER(9, 195, EntityCartTrackRelayer.class, null),
    UNDERCUTTER(10, 194, EntityCartUndercutter.class, null),
    PUMPKIN(11, 201, EntityCartPumpkin.class, new ur(amq.bd)),
    GIFT(12, 202, EntityCartGift.class, null),
    ANCHOR_PERSONAL(13, 203, EntityCartAnchorPersonal.class, null),
    LOCO_STEAM(30, 0, EntityLocomotiveSteam.class, null);

    private final int icon;
    private final Class type;
    private final byte id;
    private ur contents = null;
    private ur cartItem;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumCart(Class id, ur icon) {
        void contents;
        void type;
        this.id = (byte)id;
        this.icon = (int)icon;
        this.type = type;
        this.contents = contents;
    }

    public byte getId() {
        return this.id;
    }

    public int getIconIndex() {
        return this.icon;
    }

    public String getTag() {
        return "cart." + this.name().toLowerCase().replace('_', '.');
    }

    public String getItemTag() {
        return "rc.item.cart." + this.name().toLowerCase().replace('_', '.');
    }

    public Class getCartClass() {
        return this.type;
    }

    public void setContents(ur stack) {
        this.contents = stack.l();
    }

    public ur getContents() {
        switch (this) {
            case TANK: {
                if (!EnumMachineBeta.TANK_IRON_GAUGE.isEnabled()) break;
                return EnumMachineBeta.TANK_IRON_GAUGE.getItem();
            }
        }
        if (this.contents == null) {
            return null;
        }
        return this.contents.l();
    }

    public py makeCart(ur stack, yc world, double i, double j, double k) {
        switch (this) {
            case CHEST: {
                return new EntityCartChest(world, i, j, k);
            }
            case FURNACE: {
                return new EntityCartFurnace(world, i, j, k);
            }
            case TNT: {
                return new EntityCartTNT(world, i, j, k);
            }
            case TANK: {
                EntityCartTank cart = new EntityCartTank(world, i, j, k);
                ur filter = EntityCartTank.getFilterFromCartItem(stack);
                cart.setFilter(filter);
                return cart;
            }
            case BATBOX: {
                EntityCartEnergy cart = new EntityCartEnergy(world, i, j, k);
                cart.a = 0;
                return cart;
            }
            case MFE: {
                EntityCartEnergy cart = new EntityCartEnergy(world, i, j, k);
                cart.a = 1;
                return cart;
            }
            case MFSU: {
                EntityCartEnergy cart = new EntityCartEnergy(world, i, j, k);
                cart.a = 2;
                return cart;
            }
            case ANCHOR: {
                EntityCartAnchor cart = new EntityCartAnchor(world, i, j, k);
                long fuel = ItemCartAnchor.getFuel(stack);
                cart.setAnchorFuel(fuel);
                return cart;
            }
            case ANCHOR_PERSONAL: {
                EntityCartAnchorPersonal cart = new EntityCartAnchorPersonal(world, i, j, k);
                long fuel = ItemCartAnchor.getFuel(stack);
                cart.setAnchorFuel(fuel);
                return cart;
            }
            case WORK: {
                return new EntityCartWork(world, i, j, k);
            }
            case TRACK_RELAYER: {
                return new EntityCartTrackRelayer(world, i, j, k);
            }
            case UNDERCUTTER: {
                return new EntityCartUndercutter(world, i, j, k);
            }
            case PUMPKIN: {
                return new EntityCartPumpkin(world, i, j, k);
            }
            case GIFT: {
                return new EntityCartGift(world, i, j, k);
            }
            case LOCO_STEAM: {
                EntityLocomotiveSteam entity = new EntityLocomotiveSteam(world, i, j, k);
                entity.initEntityFromItem(stack);
                return entity;
            }
        }
        return new EntityCartBasic(world, i, j, k);
    }

    public ur getCartItem() {
        if (this.cartItem == null) {
            return null;
        }
        return this.cartItem.l();
    }

    public void setCartItem(ur cartItem) {
        this.cartItem = cartItem.l();
    }
}

