/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import railcraft.common.api.carts.CartBase;
import railcraft.common.api.carts.ICartRenderInterface;
import railcraft.common.api.carts.IExplosiveCart;
import railcraft.common.api.carts.IMinecartTextureProvider;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.IGuiReturnHandler;

public class EntityCartTNT
extends CartBase
implements IExplosiveCart,
IGuiReturnHandler,
ICartRenderInterface,
IMinecartTextureProvider {
    private static final String TEXTURE = "/railcraft/client/textures/carts/cart_wood.png";
    private static final byte FUSE_DATA_ID = 20;
    private static final byte BLAST_DATA_ID = 21;
    private static final byte PRIMED_DATA_ID = 22;
    private static final float BLAST_RADIUS_MULTIPLIER = 0.5f;
    private static final byte BLAST_RADIUS_MIN = 4;
    private static final byte BLAST_RADIUS_MAX = 12;
    public static final short MAX_FUSE = 500;
    public static final short MIN_FUSE = 0;
    private double prevMotionX;
    private double prevMotionZ;
    private boolean prevOnGround;
    private boolean prevOnRail;
    private short timeInAir = 0;

    public EntityCartTNT(yc world) {
        super(world);
    }

    public EntityCartTNT(yc world, double d, double d1, double d2) {
        this(world);
        this.b(d, d1 + (double)this.M, d2);
        this.w = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.q = d;
        this.r = d1;
        this.s = d2;
    }

    protected void a() {
        super.a();
        this.ag.a(20, (Object)80);
        this.ag.a(21, (Object)9);
        this.ag.a(22, (Object)0);
    }

    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ur(up.az));
            items.add(new ur(amq.ap));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    public void j_() {
        int k;
        int j;
        block8: {
            block7: {
                super.j_();
                if (this.w == 0.0 ^ this.prevMotionX == 0.0 && Math.abs(this.prevMotionX) > (double)0.4f && this.y == 0.0) break block7;
                boolean bl = this.y == 0.0;
                boolean bl2 = this.prevMotionZ == 0.0;
                if (!(bl ^ bl2 && Math.abs(this.prevMotionZ) > (double)0.4f && this.w == 0.0) && (!this.E || this.prevOnGround || this.prevOnRail || this.timeInAir <= 5)) break block8;
            }
            this.explode();
        }
        this.prevMotionX = this.w;
        this.prevMotionZ = this.y;
        this.prevOnGround = this.E;
        int i = ke.c((double)this.t);
        if (alr.e_((yc)this.p, (int)i, (int)((j = ke.c((double)this.u)) - 1), (int)(k = ke.c((double)this.v)))) {
            --j;
        }
        int id = this.p.a(i, j, k);
        this.prevOnRail = alr.e((int)id);
        this.timeInAir = !this.E && !this.prevOnRail ? (short)(this.timeInAir + 1) : (short)0;
        if (this.isPrimed()) {
            this.setFuse((short)(this.getFuse() - 1));
            if (this.getFuse() <= 0) {
                this.explode();
            } else {
                this.p.a("smoke", this.t, this.u + 0.8, this.v, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void explode() {
        if (Game.isHost(this.getWorld())) {
            this.p.a((lq)this, this.t, this.u, this.v, this.getBlastRadius(), true);
            this.x();
        }
    }

    @Override
    public boolean doInteract(qx player) {
        ur itemstack = player.bJ.g();
        if (itemstack != null) {
            if (itemstack.c == up.i.cj) {
                this.setPrimed(true);
                this.p.a((lq)this, "random.fuse", 1.0f, 1.0f);
            } else if (itemstack.c == up.K.cj) {
                player.bJ.a(player.bJ.c, 1);
                GuiHandler.openGui(EnumGui.CART_TNT_FUSE, player, this.p, (lq)this);
            } else if (itemstack.c == up.M.cj) {
                player.bJ.a(player.bJ.c, 1);
                GuiHandler.openGui(EnumGui.CART_TNT_BLAST, player, this.p, (lq)this);
            }
        }
        return true;
    }

    protected double getDrag() {
        return 0.991999979019165;
    }

    public int k_() {
        return 0;
    }

    public boolean isStorageCart() {
        return false;
    }

    public boolean canBeRidden() {
        return false;
    }

    public String b() {
        return "TNTcart";
    }

    @Override
    public boolean isPrimed() {
        return this.ag.a(22) != 0;
    }

    @Override
    public void setPrimed(boolean p) {
        this.ag.b(22, (Object)(p ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0)));
    }

    @Override
    public int getFuse() {
        return this.ag.b(20);
    }

    @Override
    public void setFuse(int f) {
        f = (short)Math.max(f, 0);
        f = (short)Math.min(f, 500);
        this.ag.b(20, (Object)((short)f));
    }

    protected byte getMinBlastRadius() {
        return 4;
    }

    protected byte getMaxBlastRadius() {
        return 12;
    }

    @Override
    public float getBlastRadius() {
        return (float)this.ag.a(21) * 0.5f;
    }

    @Override
    public void setBlastRadius(float b) {
        b /= 0.5f;
        b = Math.max(b, (float)this.getMinBlastRadius());
        b = Math.min(b, (float)this.getMaxBlastRadius());
        this.ag.b(21, (Object)((byte)b));
    }

    protected void b(bq data) {
        super.b(data);
        data.a("Fuse", (short)this.getFuse());
        data.a("blastRadius", this.ag.a(21));
        data.a("Primed", this.isPrimed());
    }

    protected void a(bq data) {
        super.a(data);
        this.setFuse(data.d("Fuse"));
        this.setBlastRadius(data.c("blastRadius"));
        this.setPrimed(data.n("Primed"));
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.getFuse());
        data.writeByte(this.ag.a(21));
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.setFuse(data.readShort());
        this.setBlastRadius(data.readByte());
    }

    @Override
    public yc getWorld() {
        return this.p;
    }

    @Override
    public amq getBlock() {
        return amq.ap;
    }

    @Override
    public int getBlockMetadata() {
        return 0;
    }

    @Override
    public String getTextureFile() {
        return TEXTURE;
    }
}

