/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import railcraft.common.api.carts.CartTools;
import railcraft.common.api.tracks.ITrackSwitch;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.EnumTrackMeta;
import railcraft.common.blocks.tracks.TrackSwitchBase;

public class TrackWye
extends TrackSwitchBase {
    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.WYE;
    }

    @Override
    public int getTextureIndex() {
        int texture = this.getTrackType().getTextureIndex();
        if (this.isSwitched()) {
            ++texture;
        }
        return texture;
    }

    @Override
    public int getBasicRailMetadata(py cart) {
        int meta = this.tileEntity.p();
        if (cart != null) {
            if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                meta = this.isMirrored() ? (this.isSwitched() ? EnumTrackMeta.WEST_NORTH_CORNER.ordinal() : EnumTrackMeta.WEST_SOUTH_CORNER.ordinal()) : (this.isSwitched() ? EnumTrackMeta.EAST_SOUTH_CORNER.ordinal() : EnumTrackMeta.EAST_NORTH_CORNER.ordinal());
            } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
                meta = this.isMirrored() ? (this.isSwitched() ? EnumTrackMeta.EAST_NORTH_CORNER.ordinal() : EnumTrackMeta.WEST_NORTH_CORNER.ordinal()) : (this.isSwitched() ? EnumTrackMeta.WEST_SOUTH_CORNER.ordinal() : EnumTrackMeta.EAST_SOUTH_CORNER.ordinal());
            }
        }
        return meta;
    }

    @Override
    protected boolean shouldLockSwitch() {
        int x = this.tileEntity.l;
        int y = this.tileEntity.m;
        int z = this.tileEntity.n;
        int meta = this.tileEntity.p();
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = this.isMirrored() ? --x : ++x;
        } else if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isMirrored() ? ++z : --z;
        }
        return CartTools.isMinecartOnRailAt(this.getWorld(), x, y, z, 0.3f);
    }

    @Override
    protected boolean shouldSpringSwitch() {
        int x = this.tileEntity.l;
        int y = this.tileEntity.m;
        int z = this.tileEntity.n;
        int meta = this.tileEntity.p();
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = this.isMirrored() ? ++x : --x;
        } else if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isMirrored() ? --z : ++z;
        }
        return CartTools.isMinecartOnRailAt(this.getWorld(), x, y, z, 0.3f);
    }

    @Override
    public ITrackSwitch.ArrowDirection getRedSignDirection() {
        if (EnumTrackMeta.EAST_WEST.isEqual(this.tileEntity.p())) {
            if (this.isSwitched()) {
                if (this.isMirrored()) {
                    return ITrackSwitch.ArrowDirection.WEST;
                }
                return ITrackSwitch.ArrowDirection.EAST;
            }
            if (this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.EAST;
            }
            return ITrackSwitch.ArrowDirection.WEST;
        }
        if (this.isSwitched()) {
            if (this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.NORTH;
            }
            return ITrackSwitch.ArrowDirection.SOUTH;
        }
        if (this.isMirrored()) {
            return ITrackSwitch.ArrowDirection.SOUTH;
        }
        return ITrackSwitch.ArrowDirection.NORTH;
    }

    @Override
    public ITrackSwitch.ArrowDirection getWhiteSignDirection() {
        if (EnumTrackMeta.EAST_WEST.isEqual(this.tileEntity.p())) {
            if (this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.NORTH;
            }
            return ITrackSwitch.ArrowDirection.SOUTH;
        }
        if (this.isMirrored()) {
            return ITrackSwitch.ArrowDirection.EAST;
        }
        return ITrackSwitch.ArrowDirection.WEST;
    }
}

