/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.api.tracks.ITrackSwitch;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.EnumTrackMeta;
import railcraft.common.blocks.tracks.TrackSwitchBase;

public class TrackSwitch
extends TrackSwitchBase
implements ITrackReversable {
    private boolean reversed;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SWITCH;
    }

    @Override
    public int getTextureIndex() {
        int texture = this.getTrackType().getTextureIndex();
        if (this.reversed) {
            texture += 2;
        }
        if (this.isSwitched()) {
            ++texture;
        }
        return texture;
    }

    @Override
    public int getBasicRailMetadata(py cart) {
        int meta = this.tileEntity.p();
        if (cart != null && this.isSwitched()) {
            if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                meta = this.isMirrored() ? (this.reversed ? EnumTrackMeta.WEST_SOUTH_CORNER.ordinal() : EnumTrackMeta.WEST_NORTH_CORNER.ordinal()) : (this.reversed ? EnumTrackMeta.EAST_NORTH_CORNER.ordinal() : EnumTrackMeta.EAST_SOUTH_CORNER.ordinal());
            } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
                meta = this.isMirrored() ? (this.reversed ? EnumTrackMeta.WEST_NORTH_CORNER.ordinal() : EnumTrackMeta.EAST_NORTH_CORNER.ordinal()) : (this.reversed ? EnumTrackMeta.EAST_SOUTH_CORNER.ordinal() : EnumTrackMeta.WEST_SOUTH_CORNER.ordinal());
            }
        }
        return meta;
    }

    @Override
    protected boolean shouldLockSwitch() {
        int x = this.tileEntity.l;
        int y = this.tileEntity.m;
        int z = this.tileEntity.n;
        int meta = this.tileEntity.p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isReversed() != this.isMirrored() ? ++z : --z;
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = !this.isReversed() != this.isMirrored() ? ++x : --x;
        }
        return CartTools.isMinecartOnRailAt(this.getWorld(), x, y, z, 0.3f);
    }

    @Override
    protected boolean shouldSpringSwitch() {
        int x = this.tileEntity.l;
        int y = this.tileEntity.m;
        int z = this.tileEntity.n;
        int meta = this.tileEntity.p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            x = this.isMirrored() ? --x : ++x;
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            z = this.isMirrored() ? --z : ++z;
        }
        return CartTools.isMinecartOnRailAt(this.getWorld(), x, y, z, 0.3f);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Reversed", this.reversed);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.n("Reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.reversed = data.readBoolean();
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public ITrackSwitch.ArrowDirection getRedSignDirection() {
        if (this.tileEntity.p() == 1) {
            if (this.isSwitched()) {
                if (this.isMirrored()) {
                    return ITrackSwitch.ArrowDirection.NORTH;
                }
                return ITrackSwitch.ArrowDirection.SOUTH;
            }
            if (this.isReversed() != this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.WEST;
            }
            return ITrackSwitch.ArrowDirection.EAST;
        }
        if (this.isSwitched()) {
            if (this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.EAST;
            }
            return ITrackSwitch.ArrowDirection.WEST;
        }
        if (this.isReversed() != this.isMirrored()) {
            return ITrackSwitch.ArrowDirection.NORTH;
        }
        return ITrackSwitch.ArrowDirection.SOUTH;
    }

    @Override
    public ITrackSwitch.ArrowDirection getWhiteSignDirection() {
        if (this.tileEntity.p() == 1) {
            if (this.isSwitched()) {
                return ITrackSwitch.ArrowDirection.EAST_WEST;
            }
            return ITrackSwitch.ArrowDirection.NORTH_SOUTH;
        }
        if (this.isSwitched()) {
            return ITrackSwitch.ArrowDirection.NORTH_SOUTH;
        }
        return ITrackSwitch.ArrowDirection.EAST_WEST;
    }
}

