/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.carts.IExplosiveCart;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackReinforced;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.network.IGuiReturnHandler;

public class TrackPriming
extends TrackReinforced
implements ITrackPowered,
IGuiReturnHandler {
    private boolean powered = false;
    private short fuse = (short)80;
    public static final short MAX_FUSE = 500;
    public static final short MIN_FUSE = 0;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.PRIMING;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public int getTextureIndex() {
        if (!this.isPowered()) {
            return this.getTrackType().getTextureIndex() + 1;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public boolean blockActivated(qx player) {
        IToolCrowbar crowbar;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            GuiHandler.openGui(EnumGui.TRACK_PRIMING, player, this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(py cart) {
        if (this.isPowered() && cart instanceof IExplosiveCart) {
            IExplosiveCart tnt = (IExplosiveCart)cart;
            tnt.setFuse(this.fuse);
            tnt.setPrimed(true);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeShort(this.fuse);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.fuse = data.readShort();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void writeToNBT(bq data) {
        super.writeToNBT(data);
        data.a("powered", this.powered);
        data.a("fuse", this.getFuse());
    }

    @Override
    public void readFromNBT(bq data) {
        super.readFromNBT(data);
        this.powered = data.n("powered");
        this.setFuse(data.d("fuse"));
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.fuse);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.fuse = data.readShort();
    }

    public short getFuse() {
        return this.fuse;
    }

    public void setFuse(short f) {
        f = (short)Math.max(f, 0);
        this.fuse = f = (short)Math.min(f, 500);
    }
}

