/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SimpleSignalReceiver;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.IAspectActionManager;
import railcraft.common.blocks.signals.TileSwitchBase;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileSwitchMotor
extends TileSwitchBase
implements IAspectActionManager,
IGuiReturnHandler,
IReceiverTile {
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.b(), this);
    private int update = MiscTools.getRand().nextInt();
    private boolean[] switchOnAspects = new boolean[SignalAspect.values().length];
    private boolean switchAspect;

    public TileSwitchMotor() {
        this.switchOnAspects[SignalAspect.RED.ordinal()] = true;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.SWITCH_MOTOR;
    }

    @Override
    public boolean blockActivated(int side, qx player) {
        IToolCrowbar crowbar;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.b()).canWhack(player, current, this.l, this.m, this.n)) {
            GuiHandler.openGui(EnumGui.SWITCH_MOTOR, player, this.k, this.l, this.m, this.n);
            crowbar.onWhack(player, current, this.l, this.m, this.n);
            return true;
        }
        return false;
    }

    @Override
    public void g() {
        super.g();
        if (Game.isNotHost(this.k)) {
            this.receiver.tickClient();
            return;
        }
        this.receiver.tickServer();
        ++this.update;
        boolean active = this.isSwitchAspect();
        if (this.switchAspect != active) {
            this.switchAspect = active;
            this.switchTrack(this.switchAspect || this.isPowered());
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        boolean power = this.isBeingPowered(amq.ay.cm == blockId);
        if (this.isPowered() != power) {
            this.setPowered(power);
            this.switchTrack(this.switchAspect || this.isPowered());
        }
    }

    @Override
    public boolean canConnectRedstone(int dir) {
        return true;
    }

    private boolean isBeingPowered(boolean testRedstone) {
        return this.k.A(this.l, this.m, this.n) || this.k.B(this.l, this.m, this.n) || testRedstone && this.isRedstonePowered();
    }

    private boolean isSwitchAspect() {
        return this.switchOnAspects[this.receiver.getAspect().ordinal()];
    }

    @Override
    public void b(bq data) {
        super.b(data);
        byte[] array = new byte[this.switchOnAspects.length];
        for (int i = 0; i < this.switchOnAspects.length; ++i) {
            array[i] = (byte)(this.switchOnAspects[i] ? 1 : 0);
        }
        data.a("PowerOnAspect", array);
        data.a("switchAspect", this.switchAspect);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        if (data.b("PowerOnAspect")) {
            byte[] array = data.j("PowerOnAspect");
            for (int i = 0; i < this.switchOnAspects.length; ++i) {
                this.switchOnAspects[i] = array[i] == 1;
            }
        }
        this.switchAspect = data.n("switchAspect");
        this.receiver.readFromNBT(data);
        if (data.b("ControllerX")) {
            int cx = data.e("ControllerX");
            int cy = data.e("ControllerY");
            int cz = data.e("ControllerZ");
            this.receiver.registerLegacyController(cx, cy, cz);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
        this.writeGuiData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.readGuiData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        int bits = 0;
        for (int i = 0; i < this.switchOnAspects.length; ++i) {
            bits = (byte)(bits | (this.switchOnAspects[i] ? 1 : 0) << i);
        }
        data.writeByte(bits);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        byte bits = data.readByte();
        for (int bit = 0; bit < this.switchOnAspects.length; ++bit) {
            this.switchOnAspects[bit] = (bits >> bit & 1) == 1;
        }
    }

    @Override
    public boolean doesActionOnAspect(SignalAspect aspect) {
        return this.switchOnAspects[aspect.ordinal()];
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        this.switchOnAspects[aspect.ordinal()] = trigger;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }
}

