/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SimpleSignalReceiver;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.IDualHeadSignal;
import railcraft.common.blocks.signals.Signals;
import railcraft.common.blocks.signals.TileSignalBlockSignal;
import railcraft.common.util.misc.Game;

public class TileSignalDualHeadBlockSignal
extends TileSignalBlockSignal
implements IReceiverTile,
IDualHeadSignal {
    private boolean prevBlinkState;
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.b(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.DUAL_HEAD_BLOCK_SIGNAL;
    }

    @Override
    public void g() {
        super.g();
        if (Game.isNotHost(this.k)) {
            this.receiver.tickClient();
            if (this.update % 4 == 0 && this.receiver.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.k.c(yo.b, this.getX(), this.getY(), this.getZ());
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (!this.receiver.isPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.sendUpdateToClient();
    }

    @Override
    public void setBlockBoundsBasedOnState(ym world, int i, int j, int k) {
        this.getBlock().a(0.15f, 0.0f, 0.15f, 0.85f, 1.0f, 0.85f);
    }

    @Override
    public aoe getSelectedBoundingBoxFromPool(yc world, int i, int j, int k) {
        return aoe.a().a((double)((float)i + 0.15f), (double)j, (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    @Override
    public aoe getCollisionBoundingBoxFromPool(yc world, int i, int j, int k) {
        return aoe.a().a((double)((float)i + 0.15f), (double)j, (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.receiver.readFromNBT(data);
        if (data.b("ControllerX")) {
            int cx = data.e("ControllerX");
            int cy = data.e("ControllerY");
            int cz = data.e("ControllerZ");
            this.receiver.registerLegacyController(cx, cy, cz);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
    }

    @Override
    public int getLightValue() {
        if (Signals.isAspectLit(this.getTopAspect()) || Signals.isAspectLit(this.getBottomAspect())) {
            return 5;
        }
        return 0;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getTopAspect() {
        return this.getSignalAspect();
    }

    @Override
    public SignalAspect getBottomAspect() {
        return this.receiver.getAspect();
    }
}

