/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.beta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.liquids.LiquidFilter;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import railcraft.common.util.inventory.EnumItemType;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class TileBoilerFireboxSolid
extends TileBoilerFirebox
implements ISidedInventory,
INeedsFuel {
    private static final int SLOT_BURN = 2;
    private static final int SLOT_FUEL_A = 3;
    private static final int SLOT_FUEL_B = 4;
    private static final int SLOT_FUEL_C = 5;
    private la invBurn = new InventoryMapper(this, 2, 1);
    private la invStock = new InventoryMapper(this, 3, 3);
    private la invFuel = new InventoryMapper(this, 2, 4);
    private ur bucket = new ur(up.aw);
    private boolean testNearbyChests = true;
    private List nearbyChests = new ArrayList();

    public TileBoilerFireboxSolid() {
        super(6);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.BOILER_FIREBOX_SOLID;
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.BOILER_SOLID, player, this.k, mBlock.l, mBlock.m, mBlock.n);
            return true;
        }
        return false;
    }

    @Override
    protected void process() {
        InvTools.moveOneItem(this.invStock, this.invBurn);
        InvTools.moveOneItem(this.invBurn, this.invWaterOutput, this.bucket);
    }

    @Override
    public void g() {
        block2: {
            la nearby;
            super.g();
            if (Game.isNotHost(this.getWorld())) {
                return;
            }
            TileBoilerFireboxSolid mBlock = (TileBoilerFireboxSolid)this.getMasterBlock();
            if (mBlock == null) break block2;
            Iterator i$ = this.getNearbyChests().iterator();
            while (i$.hasNext() && InvTools.moveOneItem(nearby = (la)i$.next(), mBlock.invStock, EnumItemType.FUEL) == null) {
            }
        }
    }

    private List getNearbyChests() {
        if (this.testNearbyChests) {
            this.testNearbyChests = false;
            this.nearbyChests.clear();
            for (int side = 2; side < 6; ++side) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                la inv = InvTools.getInventoryFromSide(this.k, this.l, this.m, this.n, dir, null, TileBoilerFirebox.class);
                if (inv == null) continue;
                this.nearbyChests.add(inv);
            }
        }
        return this.nearbyChests;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        super.onNeighborBlockChange(id);
        this.testNearbyChests = true;
    }

    @Override
    protected float getMoreFuel() {
        ur fuel = this.a(2);
        int burn = MiscTools.getItemBurnTime(fuel);
        if (burn > 0) {
            this.a(2, InvTools.depleteItem(fuel));
        }
        return burn;
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 2;
            }
        }
        return 4;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (stack == null) {
            return 0;
        }
        if (MiscTools.getItemBurnTime(stack) > 0) {
            ur remainder;
            la inv = this.invFuel;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.a;
            }
            return stack.a - remainder.a;
        }
        if (LiquidManager.getInstance().isFilledContainer(stack) && LiquidManager.getInstance().containsLiquid(stack, LiquidFilter.WATER)) {
            ur remainder;
            la inv = this.invWaterInput;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.a;
            }
            return stack.a - remainder.a;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la inv = this.invWaterOutput;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }

    @Override
    public boolean needsFuel() {
        TileBoilerFireboxSolid mBlock = (TileBoilerFireboxSolid)this.getMasterBlock();
        if (mBlock != null) {
            int amount = InvTools.countItems(mBlock.invFuel);
            return amount < 64;
        }
        return false;
    }
}

