/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.blocks.machine.beta.ISteamUser;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.items.RailcraftPartItems;
import railcraft.common.liquids.LiquidItems;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.FilteredTank;
import railcraft.common.plugins.buildcraft.triggers.INeedsMaintenance;
import railcraft.common.plugins.ic2.IC2Plugin;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.StandaloneInventory;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IDisableable;

public class TileSteamTurbine
extends TileMultiBlock
implements IEnergySource,
ITankContainer,
IDisableable,
INeedsMaintenance,
ISteamUser {
    private static final int DAMAGE_CHANCE = 200;
    private static final int IC2_OUTPUT = 100;
    private static final float UE_WATTS = 5000.0f;
    private static final float UE_VOLTAGE = 120.0f;
    private static final int BC_OUTPUT = 64;
    private static final int STEAM_USAGE = 320;
    private static final List patterns = new ArrayList();
    private static final ur sampleRotor = RailcraftPartItems.getTurbineRotor();
    private final StandaloneInventory inv = new StandaloneInventory(1, this);
    public float output;
    private final LiquidStack waterFilter = new LiquidStack(amq.E, 2);
    private final LiquidStack steamFilter = LiquidItems.getSteamLiquid();
    protected final TankManager tankManager = new TankManager();
    public static final int TANK_STEAM = 0;
    public static final int TANK_WATER = 1;
    private boolean needsInit = true;
    private int disabled;
    private byte gaugeState = 0;
    private float energy;
    private IConductor[] conductors = new IConductor[6];
    private final ElectricityPack uePack = new ElectricityPack(41.66666793823242, 120.0);

    public TileSteamTurbine() {
        super(patterns);
        this.tankManager.addTank(new FilteredTank(4000, this.steamFilter));
        FilteredTank tank = new FilteredTank(4000, this.waterFilter);
        tank.setTankPressure(1);
        this.tankManager.addTank(tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.TURBINE;
    }

    @Override
    public void g() {
        super.g();
        if (Game.isHost(this.getWorld())) {
            if (this.needsInit) {
                IC2Plugin.addTileToNet(this);
                this.grabConductors();
                this.needsInit = false;
            }
            if (this.isMaster()) {
                ur rotor;
                LiquidStack steam;
                boolean addedEnergy = false;
                if (this.energy < 64.0f && (steam = this.tankManager.drain(0, 320, false)) != null && steam.amount >= 320 && InvTools.isItemEqual(rotor = this.inv.a(0), sampleRotor)) {
                    addedEnergy = true;
                    this.energy += 64.0f;
                    this.tankManager.drain(0, 320, true);
                    if (this.k.t.nextInt(4) != 0) {
                        this.tankManager.fill(1, this.waterFilter, true);
                    }
                    if (this.k.t.nextInt(200) == 0) {
                        this.inv.a(0, InvTools.damageItem(rotor, 1));
                    }
                }
                this.output = (float)(((double)this.output * 49.0 + (addedEnergy ? 100.0 : 0.0)) / 50.0);
            }
            if (this.getPatternMarker() == 'W') {
                byte prevGaugeState = this.gaugeState;
                float out = this.getOutput();
                this.gaugeState = out < 30.0f ? (byte)0 : (out < 70.0f ? (byte)1 : (byte)2);
                if (prevGaugeState != this.gaugeState) {
                    this.sendUpdateToClient();
                }
            }
            if (IC2Plugin.isIC2Installed() && this.hasEnergy()) {
                float extra = IC2Plugin.emitEnergy(this, 100);
                this.removeEnergy((100.0f - extra) / 100.0f * 64.0f);
            }
            for (int side = 0; side < 6; ++side) {
                if (this.conductors[side] == null) continue;
                if (this.hasEnergy()) {
                    ElectricityNetwork network = this.conductors[side].getNetwork();
                    ElectricityPack request = network.getRequest(new any[0]);
                    if (request.getWatts() >= this.uePack.getWatts()) {
                        network.startProducing(this, this.uePack);
                        this.removeEnergy(64.0f);
                        continue;
                    }
                    double ratio = request.getWatts() / this.uePack.getWatts();
                    network.startProducing(this, new ElectricityPack(41.66666793823242 * ratio, 120.0));
                    this.removeEnergy((float)(64.0 * ratio));
                    continue;
                }
                this.conductors[side].getNetwork().stopProducing(this);
            }
        }
    }

    private void onRemove() {
        ElectricityConnections.unregisterConnector(this);
        if (!this.needsInit) {
            IC2Plugin.removeTileFromNet(this);
            this.needsInit = true;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.onRemove();
    }

    public void s() {
        super.s();
        ElectricityConnections.registerConnector(this, EnumSet.allOf(ForgeDirection.class));
    }

    @Override
    public void w_() {
        super.w_();
        this.onRemove();
    }

    private void grabConductors() {
        for (int side = 0; side < 6; ++side) {
            any tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, ForgeDirection.getOrientation((int)side));
            this.conductors[side] = tile instanceof IConductor ? (IConductor)tile : null;
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        super.onNeighborBlockChange(id);
        this.grabConductors();
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
        this.tankManager.getTank(0).setLiquid(null);
        this.tankManager.getTank(1).setLiquid(null);
        InvTools.dropInventory(this.inv, this.k, this.l, this.m, this.n);
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory(this.inv, this.k, this.l, this.m, this.n);
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.TURBINE, player, this.k, mBlock.l, mBlock.m, mBlock.n);
            return true;
        }
        return false;
    }

    public boolean hasEnergy() {
        return this.getEnergy() >= 64.0f;
    }

    public void removeEnergy(float amount) {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.energy -= amount;
            if (mBlock.energy < 0.0f) {
                mBlock.energy = 0.0f;
            }
        }
    }

    public float getEnergy() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock == null) {
            return 0.0f;
        }
        return mBlock.energy;
    }

    public float getOutput() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock == null) {
            return 0.0f;
        }
        return mBlock.output;
    }

    @Override
    public int getBlockTexture(int side) {
        if (this.isStructureValid()) {
            int patIndex = patterns.indexOf(this.getPattern());
            if (side == 0 || side == 1) {
                if (patIndex == 0) {
                    return EnumMachineAlpha.TURBINE.getTexture(10);
                }
                return EnumMachineAlpha.TURBINE.getTexture(0);
            }
            if (this.getPatternMarker() == 'W') {
                return EnumMachineAlpha.TURBINE.getTexture(11 + this.gaugeState);
            }
            if (patIndex == 0) {
                switch (side) {
                    case 2: {
                        if (this.getPatternPositionY() == 2) {
                            if (this.getPatternPositionX() == 2) {
                                return EnumMachineAlpha.TURBINE.getTexture(6);
                            }
                            return EnumMachineAlpha.TURBINE.getTexture(7);
                        }
                        if (this.getPatternPositionX() == 2) {
                            return EnumMachineAlpha.TURBINE.getTexture(8);
                        }
                        return EnumMachineAlpha.TURBINE.getTexture(9);
                    }
                    case 3: {
                        if (this.getPatternPositionY() == 2) {
                            if (this.getPatternPositionX() == 1) {
                                return EnumMachineAlpha.TURBINE.getTexture(6);
                            }
                            return EnumMachineAlpha.TURBINE.getTexture(7);
                        }
                        if (this.getPatternPositionX() == 1) {
                            return EnumMachineAlpha.TURBINE.getTexture(8);
                        }
                        return EnumMachineAlpha.TURBINE.getTexture(9);
                    }
                }
            } else {
                switch (side) {
                    case 4: {
                        if (this.getPatternPositionY() == 2) {
                            if (this.getPatternPositionZ() == 1) {
                                return EnumMachineAlpha.TURBINE.getTexture(6);
                            }
                            return EnumMachineAlpha.TURBINE.getTexture(7);
                        }
                        if (this.getPatternPositionZ() == 1) {
                            return EnumMachineAlpha.TURBINE.getTexture(8);
                        }
                        return EnumMachineAlpha.TURBINE.getTexture(9);
                    }
                    case 5: {
                        if (this.getPatternPositionY() == 2) {
                            if (this.getPatternPositionZ() == 2) {
                                return EnumMachineAlpha.TURBINE.getTexture(6);
                            }
                            return EnumMachineAlpha.TURBINE.getTexture(7);
                        }
                        if (this.getPatternPositionZ() == 2) {
                            return EnumMachineAlpha.TURBINE.getTexture(8);
                        }
                        return EnumMachineAlpha.TURBINE.getTexture(9);
                    }
                }
            }
        }
        return EnumMachineAlpha.TURBINE.getTexture(0);
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.inv.writeToNBT("rotor", data);
        this.tankManager.writeTanksToNBT(data);
        data.a("energy", this.energy);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.inv.readFromNBT("rotor", data);
        this.tankManager.readTanksFromNBT(data);
        this.energy = data.g("energy");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.gaugeState);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte gs = data.readByte();
        if (gs != this.gaugeState) {
            this.gaugeState = gs;
            this.markBlockForUpdate();
        }
    }

    @Override
    public int getMaxEnergyOutput() {
        return 128;
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return !this.needsInit;
    }

    public StandaloneInventory getInventory() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inv;
        }
        return this.inv;
    }

    public TankManager getTankManager() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(1, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.fill(tankIndex, resource, doFill);
        }
        return 0;
    }

    public ILiquidTank[] getTanks(ForgeDirection side) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return new ILiquidTank[]{new LiquidTank(0)};
    }

    public ILiquidTank getTank(ForgeDirection side, LiquidStack type) {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        TankManager tMan = this.tankManager;
        if (mBlock != null) {
            tMan = mBlock.tankManager;
        }
        switch (side) {
            case DOWN: {
                return tMan.getTank(1);
            }
        }
        return tMan.getTank(0);
    }

    @Override
    public void onDisable(int duration) {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.disabled = duration;
        }
    }

    @Override
    public boolean isDisabled() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.disabled <= 0;
        }
        return true;
    }

    @Override
    public boolean needsMaintenance() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            ur rotor = mBlock.inv.a(0);
            if (rotor == null) {
                return true;
            }
            if (!InvTools.isItemEqual(rotor, sampleRotor)) {
                return true;
            }
            if ((double)rotor.j() / (double)rotor.k() > 0.75) {
                return true;
            }
        }
        return false;
    }

    static {
        char[][][] map1 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map1));
        char[][][] map2 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'W', 'W', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map2));
    }
}

