/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMachineItem;
import railcraft.common.blocks.machine.alpha.EntityAIMateBreeding;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.inventory.EnumItemType;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.ITileExtraDataHandler;
import railcraft.common.util.network.PacketTileExtraData;

public class TileFeedStation
extends TileMachineItem
implements ITileExtraDataHandler {
    private static final int AREA = 3;
    private static final int MIN_FEED_INTERVAL = 128;
    private static final int FEED_VARIANCE = 256;
    private static final byte ANIMALS_PER_FOOD = 2;
    private static final Random rand = MiscTools.getRand();
    private int update;
    private int feedTime;
    private byte feedCounter;
    private boolean powered;

    public TileFeedStation() {
        super(1);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.FEED_STATION;
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.FEED_STATION, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public int getBlockTexture(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void g() {
        super.g();
        ++this.update;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ur feed = this.a(0);
        if (this.update % 32 == 0 && (feed == null || feed.a < feed.d())) {
            la inv;
            List chests = InvTools.getAdjacentInventories(this.k, this.l, this.m, this.n);
            Iterator i$ = chests.iterator();
            while (i$.hasNext() && InvTools.moveOneItem(inv = (la)i$.next(), (la)this, EnumItemType.FEED) == null) {
            }
        }
        feed = this.a(0);
        --this.feedTime;
        if (!this.powered && feed != null && feed.a > 0 && this.feedTime <= 0) {
            this.feedTime = 128 + rand.nextInt(256);
            aoe box = aoe.a().a((double)this.l, (double)(this.m - 1), (double)this.n, (double)(this.l + 1), (double)(this.m + 3), (double)(this.n + 1));
            box = box.b(3.0, 0.0, 3.0);
            List animals = this.k.a(ox.class, box);
            for (ox target : animals) {
                if (!target.c(this.a(0)) || !this.feedAnimal(target)) continue;
                if (this.feedCounter <= 0) {
                    this.a(0, InvTools.depleteItem(feed));
                    this.feedCounter = (byte)2;
                }
                this.feedCounter = (byte)(this.feedCounter - 1);
                this.sendFeedPacket(target);
                break;
            }
        }
    }

    public void sendFeedPacket(ox animal) {
        try {
            PacketTileExtraData pkt = new PacketTileExtraData(this);
            DataOutputStream data = pkt.getDataStream();
            data.writeInt(animal.k);
            PacketDispatcher.sendPacketToAllAround((double)this.l, (double)this.m, (double)this.n, (double)80.0, (int)this.k.u.h, (ef)pkt.getPacket());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdatePacket(DataInputStream data) throws IOException {
        lq e = this.k.a(data.readInt());
        if (e instanceof ox) {
            this.feedAnimal((ox)e);
        }
    }

    private boolean feedAnimal(ox animal) {
        if (animal == null) {
            return false;
        }
        try {
            if (animal.b() == 0 && !animal.r()) {
                if (Game.isHost(this.k)) {
                    EntityAIMateBreeding.modifyAI(animal);
                }
                animal.d = 600;
                animal.b(null);
                for (int i = 0; i < 7; ++i) {
                    double d = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    this.k.a("heart", animal.t + (double)(rand.nextFloat() * animal.N * 2.0f) - (double)animal.N, animal.u + 0.5 + (double)(rand.nextFloat() * animal.O), animal.v + (double)(rand.nextFloat() * animal.N * 2.0f) - (double)animal.N, d, d1, d2);
                }
                return true;
            }
        }
        catch (Throwable ex) {
            Game.log(Level.SEVERE, "Feed Station encountered error, {0}", ex);
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        this.powered = this.k.A(this.l, this.m, this.n) || this.k.B(this.l, this.m, this.n);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.powered = data.n("powered");
        this.feedCounter = data.c("feedCounter");
        this.update = MiscTools.getRand().nextInt();
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("powered", this.powered);
        data.a("feedCounter", this.feedCounter);
    }
}

