/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import buildcraft.api.inventory.ISpecialInventory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.api.crafting.IBlastFurnaceRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.TileMultiBlockOven;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.items.RailcraftToolItems;
import railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class TileBlastFurnace
extends TileMultiBlockOven
implements ISidedInventory,
ISpecialInventory,
INeedsFuel {
    private static final int FUEL_PER_TICK = 5;
    private static final int COOK_STEP_LENGTH = 8;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_OUTPUT = 2;
    private static final List patterns = new ArrayList();
    public int burnTime = 0;
    public int currentItemBurnTime = 0;
    private int finishedAt;
    private final la invFuel = new InventoryMapper(this, 1, 1);
    private final la invInput = new InventoryMapper(this, 0, 1);
    private final la invOutput = new InventoryMapper(this, 2, 1);

    public TileBlastFurnace() {
        super("gui.blast.furnace", 3, patterns);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.BLAST_FURNACE;
    }

    @Override
    public int getBlockTexture(int side) {
        if (this.getPatternMarker() == 'W' && this.isStructureValid()) {
            if (this.isBurning()) {
                return this.getMachineType().getTexture(7);
            }
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(0);
    }

    @Override
    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        int id = this.k.a(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (id == RailcraftBlocks.getBlockMachineAlpha().cm && this.k.h(i, j, k) == this.p()) break;
                return true;
            }
            case 'B': 
            case 'W': {
                if (id != RailcraftBlocks.getBlockMachineAlpha().cm || this.k.h(i, j, k) != this.p()) break;
                return true;
            }
            case 'A': {
                if (!this.k.c(i, j, k) && this.k.g(i, j, k) != agi.i) break;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
        this.cookTime = 0;
        this.burnTime = 0;
        this.currentItemBurnTime = 0;
    }

    @Override
    public int getTotalCookTime() {
        ur input = this.a(0);
        IBlastFurnaceRecipe recipe = RailcraftCraftingManager.blastFurnace.getRecipe(input);
        if (recipe != null) {
            return recipe.getCookTime();
        }
        return 1;
    }

    @Override
    public int getBurnProgressScaled(int i) {
        if (this.burnTime <= 0 || this.currentItemBurnTime <= 0) {
            return 0;
        }
        int scale = this.burnTime * i / this.currentItemBurnTime;
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    private void setLavaIdle() {
        int xLava = this.l + 1;
        int yLava = this.m + 1;
        int zLava = this.n + 1;
        if (this.k.a(xLava, yLava, zLava) == 0) {
            this.k.c(xLava, yLava, zLava, amq.G.cm, 7);
        }
    }

    private void setLavaBurn() {
        int xLava = this.l + 1;
        int yLava = this.m + 1;
        int zLava = this.n + 1;
        if (this.k.a(xLava, yLava, zLava) == 0) {
            this.k.c(xLava, yLava, zLava, amq.F.cm, 1);
        }
        if (this.k.a(xLava, ++yLava, zLava) == 0) {
            this.k.c(xLava, yLava, zLava, amq.F.cm, 1);
        }
    }

    private void destroyLava() {
        int xLava = this.l + 1;
        int yLava = this.m + 2;
        int zLava = this.n + 1;
        if (this.k.g(xLava, yLava, zLava) == agi.i) {
            this.k.b(xLava, yLava, zLava, 0);
        }
        if (this.k.g(xLava, --yLava, zLava) == agi.i) {
            this.k.b(xLava, yLava, zLava, 0);
        }
    }

    @Override
    public void g() {
        super.g();
        if (Game.isHost(this.getWorld()) && this.isMaster()) {
            int prevBurnTime = this.burnTime;
            if (this.update > this.finishedAt + 8 + 5 && this.cookTime <= 0) {
                this.setCooking(false);
            }
            this.burnTime = this.burnTime >= 5 ? (this.burnTime -= 5) : 0;
            if (this.isBurning()) {
                this.setLavaBurn();
            } else {
                this.setLavaIdle();
            }
            ur input = this.a(0);
            if (input != null && input.a > 0) {
                ur output = this.a(2);
                IBlastFurnaceRecipe recipe = RailcraftCraftingManager.blastFurnace.getRecipe(input);
                if (recipe != null && recipe.isRoomForOutput(output)) {
                    int itemBurnTime;
                    ur fuel;
                    if (this.burnTime <= 10 && (fuel = this.a(1)) != null && (fuel.b() == up.m && fuel.j() == 1 || InvTools.isItemEqual(fuel, RailcraftToolItems.getCoalCoke())) && (itemBurnTime = MiscTools.getItemBurnTime(fuel)) > 0) {
                        this.burnTime = this.currentItemBurnTime = itemBurnTime + this.burnTime;
                        this.a(1, 1);
                    }
                    if (this.update % 8 == 0 && this.isBurning()) {
                        this.cookTime += 8;
                        this.setCooking(true);
                        if (this.cookTime >= recipe.getCookTime()) {
                            this.cookTime = 0;
                            this.finishedAt = this.update;
                            if (output == null) {
                                this.a(2, recipe.getOutput());
                            } else {
                                output.a += recipe.getOutputStackSize();
                            }
                            this.a(0, 1);
                        }
                        this.sendUpdateToClient();
                    }
                } else {
                    this.cookTime = 0;
                    this.setCooking(false);
                }
            } else {
                this.cookTime = 0;
                this.setCooking(false);
            }
            if (prevBurnTime == 0 ^ this.burnTime == 0) {
                this.sendUpdateToClient();
            }
        }
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return 1;
        }
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null) {
            GuiHandler.openGui(EnumGui.BLAST_FURNACE, player, this.k, masterBlock.l, masterBlock.m, masterBlock.n);
            return true;
        }
        return false;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("burnTime", this.burnTime);
        data.a("currentItemBurnTime", this.currentItemBurnTime);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.burnTime = data.e("burnTime");
        this.currentItemBurnTime = data.e("currentItemBurnTime");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.burnTime);
        data.writeInt(this.currentItemBurnTime);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.burnTime = data.readInt();
        this.currentItemBurnTime = data.readInt();
    }

    @Override
    public boolean needsFuel() {
        ur fuel = this.a(1);
        return fuel == null || fuel.a < 8;
    }

    @Override
    public boolean isBurning() {
        TileBlastFurnace mBlock = (TileBlastFurnace)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.burnTime > 0;
        }
        return false;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (!this.isStructureValid()) {
            return 0;
        }
        if (stack == null) {
            return 0;
        }
        if (stack.c == up.m.cj && stack.j() == 1 || InvTools.isItemEqual(stack, RailcraftToolItems.getCoalCoke())) {
            ur remaining;
            la inv = this.invFuel;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remaining = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.a;
            }
            return stack.a - remaining.a;
        }
        if (RailcraftCraftingManager.blastFurnace.getRecipe(stack) != null) {
            ur remaining;
            la inv = this.invInput;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remaining = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.a;
            }
            return stack.a - remaining.a;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur output = this.a(2);
        ur newStack = null;
        if (output != null) {
            int stackSize;
            newStack = output.l();
            newStack.a = stackSize = Math.min(output.a, maxItemCount);
            if (doRemove) {
                this.a(2, stackSize);
            }
        }
        if (newStack == null) {
            return new ur[0];
        }
        return new ur[]{newStack};
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'B', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

