/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.detector.TileDetectorFilter;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.gui.util.IMultiButtonState;
import railcraft.common.gui.util.MultiButtonController;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankToolkit;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileDetectorTank
extends TileDetectorFilter
implements IGuiReturnHandler {
    private final MultiButtonController buttonController = MultiButtonController.getController(0, ButtonState.values());

    public TileDetectorTank() {
        super(1);
    }

    public MultiButtonController getButtonController() {
        return this.buttonController;
    }

    public LiquidStack getFilterLiquid() {
        ur filter = this.getFilters().a(0);
        if (filter != null) {
            return LiquidManager.getInstance().getLiquidInContainer(filter);
        }
        return null;
    }

    @Override
    public boolean testForCarts() {
        List carts = CartTools.getMinecartsOnAllSides(this.k, this.l, this.m, this.n, 0.2f);
        for (py cart : carts) {
            if (!(cart instanceof ITankContainer)) continue;
            TankToolkit tank = new TankToolkit((ITankContainer)cart);
            boolean liquidMatches = false;
            LiquidStack filterLiquid = this.getFilterLiquid();
            LiquidStack tankLiquid = tank.drain(ForgeDirection.UNKNOWN, 1, false);
            if (filterLiquid == null) {
                liquidMatches = true;
            } else if (filterLiquid.isLiquidEqual(tankLiquid)) {
                liquidMatches = true;
            } else if (tank.canPutLiquid(ForgeDirection.UNKNOWN, filterLiquid)) {
                liquidMatches = true;
            }
            boolean quantityMatches = false;
            ButtonState state = (ButtonState)this.buttonController.getButtonState();
            block0 : switch (state) {
                case VOID: {
                    quantityMatches = true;
                    break;
                }
                case EMPTY: {
                    if (filterLiquid != null && tank.isTankEmpty(filterLiquid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.areTanksEmpty()) break;
                    quantityMatches = true;
                    break;
                }
                case NOT_EMPTY: {
                    if (filterLiquid != null && tank.getLiquidQty(filterLiquid) > 0) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.isLiquidInTank()) break;
                    quantityMatches = true;
                    break;
                }
                case FULL: {
                    if (filterLiquid != null && tank.isTankFull(filterLiquid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.areTanksFull()) break;
                    quantityMatches = true;
                    break;
                }
                default: {
                    float level = filterLiquid != null ? tank.getLiquidLevel(filterLiquid) : tank.getLiquidLevel();
                    switch (state) {
                        case QUARTER: {
                            quantityMatches = level >= 0.25f;
                            break block0;
                        }
                        case HALF: {
                            quantityMatches = level >= 0.5f;
                            break block0;
                        }
                        case MOST: {
                            quantityMatches = level >= 0.75f;
                            break block0;
                        }
                        case LESS_THAN_QUARTER: {
                            quantityMatches = level < 0.25f;
                            break block0;
                        }
                        case LESS_THAN_HALF: {
                            quantityMatches = level < 0.5f;
                            break block0;
                        }
                        case LESS_THAN_MOST: {
                            quantityMatches = level < 0.75f;
                            break block0;
                        }
                        case LESS_THAN_FULL: {
                            quantityMatches = level < 1.0f;
                        }
                    }
                }
            }
            return liquidMatches && quantityMatches;
        }
        return false;
    }

    @Override
    public boolean blockActivated(qx player) {
        GuiHandler.openGui(EnumGui.DETECTOR_TANK, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("state", (byte)this.buttonController.getCurrentState());
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.buttonController.setCurrentState(data.c("state"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.buttonController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.buttonController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.buttonController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.buttonController.setCurrentState(data.readByte());
    }

    public static enum ButtonState implements IMultiButtonState
    {
        VOID("L = ?"),
        EMPTY("L = 0%"),
        NOT_EMPTY("L > 0%"),
        FULL("L = 100%"),
        QUARTER("L >= 25%"),
        HALF("L >= 50%"),
        MOST("L >= 75%"),
        LESS_THAN_QUARTER("L < 25%"),
        LESS_THAN_HALF("L < 50%"),
        LESS_THAN_MOST("L < 75%"),
        LESS_THAN_FULL("L < 100%");

        private final String label;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ButtonState() {
            void label;
            this.label = label;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }
}

