/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.detector;

import ic2.api.IWrenchable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.carts.IExplosiveCart;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.RailcraftTileEntity;
import railcraft.common.blocks.detector.BlockDetector;
import railcraft.common.carts.EntityCartEnergy;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.misc.SafeNBTWrapper;

public class TileDetector
extends RailcraftTileEntity
implements IWrenchable {
    public static final float SENSITIVITY = 0.2f;
    public ForgeDirection direction = ForgeDirection.UP;
    public boolean powered = false;
    private int update = MiscTools.getRand().nextInt();

    @Override
    public String b() {
        return RailcraftLanguage.translate(BlockDetector.getBlockNameFromMetadata(this.p()));
    }

    public List getCarts() {
        return CartTools.getMinecartsOnAllSides(this.k, this.l, this.m, this.n, 0.2f);
    }

    public boolean testForCarts() {
        block10: {
            List carts;
            int meta;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block9: {
                                    meta = this.p();
                                    carts = this.getCarts();
                                    if (meta == BlockDetector.Detector.ANY.ordinal()) {
                                        return !carts.isEmpty();
                                    }
                                    if (meta != BlockDetector.Detector.EMPTY.ordinal()) break block9;
                                    for (py cart : carts) {
                                        if (!cart.canBeRidden() || cart.n != null) continue;
                                        return true;
                                    }
                                    break block10;
                                }
                                if (meta != BlockDetector.Detector.MOB.ordinal()) break block11;
                                for (py cart : carts) {
                                    if (cart.n == null || !(cart.n instanceof qe)) continue;
                                    return true;
                                }
                                break block10;
                            }
                            if (meta != BlockDetector.Detector.POWERED.ordinal()) break block12;
                            for (py cart : carts) {
                                if (!cart.isPoweredCart()) continue;
                                return true;
                            }
                            break block10;
                        }
                        if (meta != BlockDetector.Detector.PLAYER.ordinal()) break block13;
                        for (py cart : carts) {
                            if (!(cart.n instanceof qx)) continue;
                            return true;
                        }
                        break block10;
                    }
                    if (meta != BlockDetector.Detector.EXPLOSIVE.ordinal()) break block14;
                    for (py cart : carts) {
                        if (!(cart instanceof IExplosiveCart)) continue;
                        return true;
                    }
                    break block10;
                }
                if (meta != BlockDetector.Detector.ENERGY.ordinal()) break block15;
                for (py cart : carts) {
                    if (!(cart instanceof EntityCartEnergy)) continue;
                    return true;
                }
                break block10;
            }
            if (meta != BlockDetector.Detector.AGE.ordinal()) break block10;
            for (py cart : carts) {
                if (cart.n instanceof ln) {
                    ln ageable = (ln)cart.n;
                    return !ageable.h_();
                }
                if (cart.n == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean blockActivated(qx player) {
        return false;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("direction", (byte)this.direction.ordinal());
        data.a("powered", this.powered);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.direction = ForgeDirection.getOrientation((int)safe.getByte("direction"));
        this.powered = data.n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    public boolean canUpdate() {
        return true;
    }

    public void g() {
        boolean cartDetected;
        ++this.update;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if ((this.updateInterval() == 0 || this.update % this.updateInterval() == 0) && (cartDetected = this.testForCarts()) != this.powered) {
            this.powered = cartDetected;
            this.sendUpdateToClient();
            this.k.h(this.l, this.m, this.n, RailcraftBlocks.getBlockDetector().cm);
            MiscTools.notifyBlocksOfNeighborChangeOnSide(this.k, this.l, this.m, this.n, RailcraftBlocks.getBlockDetector().cm, this.direction);
        }
    }

    protected short updateInterval() {
        return 0;
    }

    @Override
    public boolean wrenchCanSetFacing(qx player, int side) {
        return this.direction != ForgeDirection.getOrientation((int)side);
    }

    @Override
    public void setFacing(short facing) {
        this.direction = ForgeDirection.getOrientation((int)facing);
        this.sendUpdateToClient();
    }

    @Override
    public short getFacing() {
        return (short)this.direction.ordinal();
    }

    @Override
    public boolean wrenchCanRemove(qx entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public short getId() {
        return (short)this.p();
    }

    public void onBlockRemoval() {
    }

    @Override
    public ur getWrenchDrop(qx entityPlayer) {
        return (ur)this.getBlock().getBlockDropped(this.k, this.l, this.m, this.n, this.p(), 0).get(0);
    }
}

