/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;
import railcraft.client.render.ICombinedRenderer;
import railcraft.client.render.RenderTools;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.aesthetics.post.BlockPost;
import railcraft.common.blocks.signals.BlockSignal;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.TileSignalBase;
import railcraft.common.util.misc.Game;

public class RenderSignal
implements ICombinedRenderer {
    private EnumSignal structure;
    private SignalAspect defaultAspect;

    public RenderSignal(EnumSignal structure, SignalAspect defaultAspect) {
        this.structure = structure;
        this.defaultAspect = defaultAspect;
    }

    @Override
    public void renderBlock(bbb renderblocks, ym iBlockAccess, int i, int j, int k, amq block) {
        float temp;
        BlockSignal blockStructure = (BlockSignal)block;
        TileSignalBase tile = (TileSignalBase)iBlockAccess.q(i, j, k);
        if (tile == null) {
            return;
        }
        float pix = 0.0625f;
        float f = 6.0f * pix;
        float f1 = 10.0f * pix;
        amq below = amq.p[iBlockAccess.a(i, j - 1, k)];
        yc world = Game.getWorld();
        if (BlockPost.connectPostAt(world, i, j - 1, k, ForgeDirection.UP) || below != null && below.isBlockSolidOnSide(Game.getWorld(), i, j - 1, k, ForgeDirection.UP)) {
            this.structure.setUseAltTextures(true);
            this.structure.setAltTextureIndex(240);
            blockStructure.a(f, 0.0f, f, f1, 15.0f * pix, f1);
            RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
            this.structure.setUseAltTextures(false);
        }
        f = 3.0f * pix;
        f1 = 13.0f * pix;
        blockStructure.a(f, 6.0f * pix, f, f1, 1.0f, f1);
        this.structure.setUseAltTextures(true);
        this.structure.setUseOffsetTextureOnSide(tile.getFacing().ordinal(), 16);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        if (tile.getSignalAspect().isBlinkAspect() && !SignalAspect.isBlinkOn()) {
            this.structure.setUseOffsetTextureOnSide(tile.getFacing().ordinal(), 2 + SignalAspect.OFF.getTextureOffset());
            RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        } else {
            this.structure.setUseOffsetTextureOnSide(tile.getFacing().ordinal(), 2 + tile.getSignalAspect().getTextureOffset());
            RenderTools.renderBlockSideWithBrightness(renderblocks, (ym)world, block, i, j, k, tile.getFacing().ordinal(), 210);
        }
        this.structure.setUseAltTextures(false);
        if (tile.getFacing().ordinal() == 2 || tile.getFacing().ordinal() == 3) {
            temp = 13.0f * pix;
            if (tile.getFacing().ordinal() == 2) {
                temp = pix;
            }
            blockStructure.a(6.0f * pix, 13.0f * pix, temp, 10.0f * pix, 14.0f * pix, temp + 2.0f * pix);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
            blockStructure.a(5.0f * pix, 10.0f * pix, temp, 6.0f * pix, 14.0f * pix, temp + 2.0f * pix);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
            blockStructure.a(10.0f * pix, 10.0f * pix, temp, 11.0f * pix, 14.0f * pix, temp + 2.0f * pix);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
        } else if (tile.getFacing().ordinal() == 4 || tile.getFacing().ordinal() == 5) {
            temp = 13.0f * pix;
            if (tile.getFacing().ordinal() == 4) {
                temp = pix;
            }
            blockStructure.a(temp, 13.0f * pix, 6.0f * pix, temp + 2.0f * pix, 14.0f * pix, 10.0f * pix);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
            blockStructure.a(temp, 10.0f * pix, 5.0f * pix, temp + 2.0f * pix, 14.0f * pix, 6.0f * pix);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
            blockStructure.a(temp, 10.0f * pix, 10.0f * pix, temp + 2.0f * pix, 14.0f * pix, 11.0f * pix);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
        }
        boolean flag1 = false;
        boolean flag2 = false;
        if (BlockPost.connectPostAt(world, i - 1, j, k, ForgeDirection.EAST) || BlockPost.connectPostAt(world, i + 1, j, k, ForgeDirection.WEST)) {
            flag1 = true;
        }
        if (BlockPost.connectPostAt(world, i, j, k - 1, ForgeDirection.SOUTH) || BlockPost.connectPostAt(world, i, j, k + 1, ForgeDirection.NORTH)) {
            flag2 = true;
        }
        boolean flag3 = BlockPost.connectPostAt(world, i - 1, j, k, ForgeDirection.EAST);
        boolean flag4 = BlockPost.connectPostAt(world, i + 1, j, k, ForgeDirection.WEST);
        boolean flag5 = BlockPost.connectPostAt(world, i, j, k - 1, ForgeDirection.SOUTH);
        boolean flag6 = BlockPost.connectPostAt(world, i, j, k + 1, ForgeDirection.NORTH);
        if (!flag1 && !flag2) {
            flag1 = true;
        }
        f = 0.4375f;
        f1 = 0.5625f;
        float f2 = 11.0f * pix;
        float f3 = 14.0f * pix;
        float f4 = flag3 ? 0.0f : f;
        float f5 = flag4 ? 1.0f : f1;
        float f6 = flag5 ? 0.0f : f;
        float f7 = flag6 ? 1.0f : f1;
        this.structure.setUseAltTextures(true);
        this.structure.setAltTextureIndex(240);
        if (flag1) {
            blockStructure.a(f4, f2, f, f5, f3, f1);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
        }
        if (flag2) {
            blockStructure.a(f, f2, f6, f1, f3, f7);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
        }
        f2 = 5.0f * pix;
        f3 = 8.0f * pix;
        if (flag1) {
            blockStructure.a(f4, f2, f, f5, f3, f1);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
        }
        if (flag2) {
            blockStructure.a(f, f2, f6, f1, f3, f7);
            RenderTools.renderStandardBlock(renderblocks, (amq)blockStructure, i, j, k);
        }
        this.structure.setUseAltTextures(false);
        blockStructure.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void renderItem(bbb renderblocks, ur item, IItemRenderer.ItemRenderType renderType) {
        BlockSignal blockStructure = (BlockSignal)RailcraftBlocks.getBlockSignal();
        float pix = 0.0625f;
        float f = 6.0f * pix;
        float f1 = 10.0f * pix;
        this.structure.setUseAltTextures(true);
        this.structure.setAltTextureIndex(240);
        blockStructure.a(f, 0.0f, f, f1, 15.0f * pix, f1);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)blockStructure, this.structure.ordinal(), 1.0f);
        this.structure.setUseAltTextures(false);
        f = 3.0f * pix;
        f1 = 13.0f * pix;
        blockStructure.a(f, 6.0f * pix, f, f1, 1.0f, f1);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)blockStructure, this.structure.ordinal(), 1.0f);
        this.structure.setUseAltTextures(true);
        this.structure.setUseAltTextureOnSide(3, this.structure.getOffsetTexture(2 + this.defaultAspect.getTextureOffset()));
        RenderTools.renderBlockOnInventory(renderblocks, (amq)blockStructure, this.structure.ordinal(), 1.0f, 3);
        this.structure.setUseAltTextures(false);
        float temp = 13.0f * pix;
        blockStructure.a(6.0f * pix, 13.0f * pix, temp, 10.0f * pix, 14.0f * pix, temp + 2.0f * pix);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)blockStructure, this.structure.ordinal(), 1.0f);
        blockStructure.a(5.0f * pix, 10.0f * pix, temp, 6.0f * pix, 14.0f * pix, temp + 2.0f * pix);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)blockStructure, this.structure.ordinal(), 1.0f);
        blockStructure.a(10.0f * pix, 10.0f * pix, temp, 11.0f * pix, 14.0f * pix, temp + 2.0f * pix);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)blockStructure, this.structure.ordinal(), 1.0f);
        blockStructure.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

