/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import railcraft.client.gui.GuiTools;
import railcraft.client.gui.TileGui;
import railcraft.client.gui.buttons.GuiToggleButton;
import railcraft.client.gui.buttons.GuiToggleButtonSmall;
import railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import railcraft.common.gui.containers.ContainerItemLoader;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.PacketGuiReturn;

public class GuiLoaderItem
extends TileGui {
    private static final String FILTER_LABEL = RailcraftLanguage.translate("gui.filters");
    private static final String CART_FILTER_LABEL = RailcraftLanguage.translate("gui.filters.carts");
    private static final String BUFFER_LABEL = RailcraftLanguage.translate("gui.item.loader.buffer");
    private static final String WAIT_LABEL = RailcraftLanguage.translate("gui.item.loader.wait");
    private static final String TRANSFER_LABEL = RailcraftLanguage.translate("gui.item.loader.transfer");
    private static final String STOCK_LABEL = RailcraftLanguage.translate("gui.item.loader.stock");
    private static final String EXCESS_LABEL = RailcraftLanguage.translate("gui.item.loader.excess");
    private GuiToggleButtonSmall transfer;
    private GuiToggleButtonSmall stock;
    private GuiToggleButtonSmall excess;
    private final TileLoaderItemBase tile;
    private TileLoaderItemBase.EnumItemMode mode;
    private boolean wait;

    public GuiLoaderItem(qw inv, TileLoaderItemBase tile) {
        super(tile, new ContainerItemLoader(inv, tile), "/railcraft/client/textures/gui/gui_item_loader.png");
        this.tile = tile;
        this.mode = tile.getMode();
        this.wait = tile.cartShouldWait();
    }

    public void A_() {
        super.A_();
        if (this.tile == null) {
            return;
        }
        this.i.clear();
        int w = (this.g - this.b) / 2;
        int h = (this.h - this.c) / 2;
        this.i.add(new GuiToggleButtonSmall(0, w + 68, h + 62, 40, WAIT_LABEL, this.wait));
        this.transfer = new GuiToggleButtonSmall(1, w + 66, h + 45, 15, TRANSFER_LABEL, this.mode == TileLoaderItemBase.EnumItemMode.TRANSFER);
        this.stock = new GuiToggleButtonSmall(2, w + 81, h + 45, 15, STOCK_LABEL, this.mode == TileLoaderItemBase.EnumItemMode.STOCK);
        this.excess = new GuiToggleButtonSmall(3, w + 96, h + 45, 15, EXCESS_LABEL, this.mode == TileLoaderItemBase.EnumItemMode.EXCESS);
        this.i.add(this.transfer);
        this.i.add(this.stock);
        this.i.add(this.excess);
    }

    protected void b(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.l, this.tile.b(), 6);
        this.l.b(FILTER_LABEL, 18, 16, 0x404040);
        this.l.b(CART_FILTER_LABEL, 75, 16, 0x404040);
        this.l.b(BUFFER_LABEL, 126, 16, 0x404040);
    }

    private void updateMode() {
        this.transfer.active = this.mode == TileLoaderItemBase.EnumItemMode.TRANSFER;
        this.stock.active = this.mode == TileLoaderItemBase.EnumItemMode.STOCK;
        this.excess.active = this.mode == TileLoaderItemBase.EnumItemMode.EXCESS;
    }

    protected void a(atb guibutton) {
        if (this.tile == null) {
            return;
        }
        switch (guibutton.f) {
            case 0: {
                ((GuiToggleButton)guibutton).active = this.wait = !this.wait;
                break;
            }
            case 1: {
                this.mode = TileLoaderItemBase.EnumItemMode.TRANSFER;
                this.updateMode();
                break;
            }
            case 2: {
                this.mode = TileLoaderItemBase.EnumItemMode.STOCK;
                this.updateMode();
                break;
            }
            case 3: {
                this.mode = TileLoaderItemBase.EnumItemMode.EXCESS;
                this.updateMode();
            }
        }
    }

    public void b() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.setCartShouldWait(this.wait);
            this.tile.setMode(this.mode);
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
        }
    }
}

