/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import extrabiomes.Extrabiomes;
import extrabiomes.blocks.BlockAutumnLeaves;
import extrabiomes.blocks.BlockCatTail;
import extrabiomes.blocks.BlockCustomFlower;
import extrabiomes.blocks.BlockCustomLog;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.blocks.BlockCustomTallGrass;
import extrabiomes.blocks.BlockGreenLeaves;
import extrabiomes.blocks.BlockLeafPile;
import extrabiomes.blocks.BlockQuarterLog;
import extrabiomes.blocks.BlockRedRock;
import extrabiomes.blocks.GenericTerrainBlock;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.handlers.SaplingBonemealEventHandler;
import extrabiomes.handlers.SaplingFuelHandler;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.items.ItemCatTail;
import extrabiomes.items.ItemCustomGreenLeaves;
import extrabiomes.items.ItemCustomLeaves;
import extrabiomes.items.ItemFlower;
import extrabiomes.items.ItemGrass;
import extrabiomes.items.ItemRedRock;
import extrabiomes.items.ItemSapling;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.lib.ModuleControlSettings;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.summa.worldgen.CatTailGenerator;
import extrabiomes.module.summa.worldgen.FlowerGenerator;
import extrabiomes.module.summa.worldgen.LeafPileGenerator;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.renderers.RenderQuarterLog;
import extrabiomes.utility.MultiItemBlock;

public abstract class BlockHandler {
    private static void createAutumnLeaves() {
        int blockID = BlockSettings.AUTUMNLEAVES.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockAutumnLeaves block = new BlockAutumnLeaves(blockID, 3, agi.j, false);
        block.b("extrabiomes.autumnleaves").b(true).c(0.2f).h(1).a(amq.g).r().setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((amq)block, ItemCustomLeaves.class);
        proxy.registerOreInAllSubblocks("treeLeaves", (amq)block);
        proxy.setBurnProperties(block.cm, 30, 60);
        Element.LEAVES_AUTUMN_BROWN.set(new ur((amq)block, 1, BlockAutumnLeaves.BlockType.BROWN.metadata()));
        Element.LEAVES_AUTUMN_ORANGE.set(new ur((amq)block, 1, BlockAutumnLeaves.BlockType.ORANGE.metadata()));
        Element.LEAVES_AUTUMN_PURPLE.set(new ur((amq)block, 1, BlockAutumnLeaves.BlockType.PURPLE.metadata()));
        Element.LEAVES_AUTUMN_YELLOW.set(new ur((amq)block, 1, BlockAutumnLeaves.BlockType.YELLOW.metadata()));
        ur stack = new ur((amq)block, 1, -1);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    public static void createBlocks() {
        BlockHandler.createAutumnLeaves();
        BlockHandler.createCattail();
        BlockHandler.createCrackedSand();
        BlockHandler.createFlower();
        BlockHandler.createGrass();
        BlockHandler.createGreenLeaves();
        BlockHandler.createLeafPile();
        BlockHandler.createRedRock();
        BlockHandler.createSapling();
        BlockHandler.createLogs();
    }

    private static void createCattail() {
        int blockID = BlockSettings.CATTAIL.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCatTail block = new BlockCatTail(blockID, 79, agi.k);
        block.b("extrabiomes.cattail").c(0.0f).a(amq.g).setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((amq)block, ItemCatTail.class);
        proxy.registerOre("reedTypha", (amq)block);
        Element.CATTAIL.set(new ur((amq)block));
        proxy.registerWorldGenerator(new CatTailGenerator(block.cm));
    }

    private static void createCrackedSand() {
        int blockID = BlockSettings.CRACKEDSAND.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        GenericTerrainBlock block = new GenericTerrainBlock(blockID, 0, agi.e);
        block.b("extrabiomes.crackedsand").c(1.2f).a(amq.h).setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel(block, "pickaxe", 0);
        proxy.registerBlock(block);
        proxy.registerOre("sandCracked", (amq)block);
        ur stack = new ur((amq)block);
        Element.CRACKEDSAND.set(stack);
        BiomeHelper.addTerrainBlockstoBiome(BiomeSettings.WASTELAND, block.cm, block.cm);
        ForestryModHelper.addToDiggerBackpack(stack);
        FacadeHelper.addBuildcraftFacade(block.cm);
    }

    private static void createFlower() {
        int blockID = BlockSettings.FLOWER.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomFlower block = new BlockCustomFlower(blockID, 32, agi.k);
        block.b("extrabiomes.flower").b(true).c(0.0f).a(amq.g).setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock(block, ItemFlower.class);
        Element.AUTUMN_SHRUB.set(new ur((amq)block, 1, BlockCustomFlower.BlockType.AUTUMN_SHRUB.metadata()));
        Element.HYDRANGEA.set(new ur((amq)block, 1, BlockCustomFlower.BlockType.HYDRANGEA.metadata()));
        Element.FLOWER_ORANGE.set(new ur((amq)block, 1, BlockCustomFlower.BlockType.ORANGE.metadata()));
        Element.FLOWER_PURPLE.set(new ur((amq)block, 1, BlockCustomFlower.BlockType.PURPLE.metadata()));
        Element.FLOWER_WHITE.set(new ur((amq)block, 1, BlockCustomFlower.BlockType.WHITE.metadata()));
        Element.ROOT.set(new ur((amq)block, 1, BlockCustomFlower.BlockType.ROOT.metadata()));
        Element.TINY_CACTUS.set(new ur((amq)block, 1, BlockCustomFlower.BlockType.TINY_CACTUS.metadata()));
        Element.TOADSTOOL.set(new ur((amq)block, 1, BlockCustomFlower.BlockType.TOADSTOOL.metadata()));
        ForestryModHelper.addToForesterBackpack(new ur((amq)block, 1, -1));
        ForestryModHelper.registerBasicFlower(Element.HYDRANGEA.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_ORANGE.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_PURPLE.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_WHITE.get());
        proxy.registerWorldGenerator(new FlowerGenerator(block.cm));
    }

    private static void createGrass() {
        int blockID = BlockSettings.GRASS.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomTallGrass block = new BlockCustomTallGrass(blockID, 48, agi.l);
        block.b("extrabiomes.tallgrass").c(0.0f).a(amq.g).setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((amq)block, ItemGrass.class);
        proxy.setBurnProperties(block.cm, 60, 100);
        Element.GRASS_BROWN.set(new ur((amq)block, 1, BlockCustomTallGrass.BlockType.BROWN.metadata()));
        Element.GRASS_DEAD.set(new ur((amq)block, 1, BlockCustomTallGrass.BlockType.DEAD.metadata()));
        Element.GRASS_BROWN_SHORT.set(new ur((amq)block, 1, BlockCustomTallGrass.BlockType.SHORT_BROWN.metadata()));
        Element.GRASS_DEAD_TALL.set(new ur((amq)block, 1, BlockCustomTallGrass.BlockType.DEAD_TALL.metadata()));
        Element.GRASS_DEAD_YELLOW.set(new ur((amq)block, 1, BlockCustomTallGrass.BlockType.DEAD_YELLOW.metadata()));
        ur grassStack = Element.GRASS_BROWN.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.MOUNTAINRIDGE.getBiome(), (abm)new ach(grassStack.c, grassStack.j()), 100);
        grassStack = Element.GRASS_BROWN_SHORT.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.MOUNTAINRIDGE.getBiome(), (abm)new ach(grassStack.c, grassStack.j()), 100);
        grassStack = Element.GRASS_DEAD.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (abm)new ach(grassStack.c, grassStack.j()), 90);
        grassStack = Element.GRASS_DEAD_YELLOW.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (abm)new ach(grassStack.c, grassStack.j()), 90);
        grassStack = Element.GRASS_DEAD_TALL.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (abm)new ach(grassStack.c, grassStack.j()), 35);
    }

    private static void createGreenLeaves() {
        int blockID = BlockSettings.GREENLEAVES.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockGreenLeaves block = new BlockGreenLeaves(blockID, 80, agi.j, false);
        block.b("extrabiomes.greenleaves").b(true).c(0.2f).h(1).a(amq.g).r().setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((amq)block, ItemCustomGreenLeaves.class);
        proxy.registerOreInAllSubblocks("treeLeaves", (amq)block);
        proxy.setBurnProperties(block.cm, 30, 60);
        Element.LEAVES_ACACIA.set(new ur((amq)block, 1, BlockGreenLeaves.BlockType.ACACIA.metadata()));
        Element.LEAVES_FIR.set(new ur((amq)block, 1, BlockGreenLeaves.BlockType.FIR.metadata()));
        Element.LEAVES_REDWOOD.set(new ur((amq)block, 1, BlockGreenLeaves.BlockType.REDWOOD.metadata()));
        ur stack = new ur((amq)block, 1, -1);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    private static void createLeafPile() {
        int blockID = BlockSettings.LEAFPILE.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockLeafPile block = new BlockLeafPile(blockID, 64, agi.l);
        block.b("extrabiomes.leafpile").c(0.0f).b(true).a(amq.g).setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock(block);
        proxy.setBurnProperties(block.cm, 30, 60);
        Element.LEAFPILE.set(new ur((amq)block));
        proxy.registerWorldGenerator(new LeafPileGenerator(block.cm));
    }

    private static void createLogs() {
        BlockHandler.createWood();
        BlockHandler.createQuarterLogs();
    }

    private static void createQuarterLogs() {
        int blockIDNW = BlockSettings.QUARTERLOG0.getID();
        int blockIDNE = BlockSettings.QUARTERLOG1.getID();
        int blockIDSW = BlockSettings.QUARTERLOG2.getID();
        int blockIDSE = BlockSettings.QUARTERLOG3.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockIDNE <= 0 || blockIDNW <= 0 || blockIDSE <= 0 || blockIDSW <= 0) {
            return;
        }
        BlockQuarterLog blockNW = new BlockQuarterLog(blockIDNW, 144, BlockQuarterLog.BarkOn.NW);
        BlockQuarterLog blockNE = new BlockQuarterLog(blockIDNE, 144, BlockQuarterLog.BarkOn.NE);
        BlockQuarterLog blockSW = new BlockQuarterLog(blockIDSW, 144, BlockQuarterLog.BarkOn.SW);
        BlockQuarterLog blockSE = new BlockQuarterLog(blockIDSE, 144, BlockQuarterLog.BarkOn.SE);
        for (amq amq2 : new amq[]{blockNW, blockNE, blockSW, blockSE}) {
            amq2.b("extrabiomes.log.quarter").a(amq.e).r().c(2.0f).b(amq.M.a(null) * 5.0f).setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
            CommonProxy proxy = Extrabiomes.proxy;
            proxy.setBlockHarvestLevel(amq2, "axe", 0);
            proxy.registerBlock(amq2, MultiItemBlock.class);
            proxy.registerOre("logWood", new ur(amq2, 1, -1));
            proxy.registerEventHandler(amq2);
            proxy.setBurnProperties(amq2.cm, 5, 5);
        }
        Element.LOG_HUGE_FIR_NW.set(new ur((amq)blockNW, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_NE.set(new ur((amq)blockNE, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_SW.set(new ur((amq)blockSW, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_SE.set(new ur((amq)blockSE, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_OAK_NW.set(new ur((amq)blockNW, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_NE.set(new ur((amq)blockNE, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_SW.set(new ur((amq)blockSW, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_SE.set(new ur((amq)blockSE, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_REDWOOD_NW.set(new ur((amq)blockNW, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_NE.set(new ur((amq)blockNE, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_SW.set(new ur((amq)blockSW, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_SE.set(new ur((amq)blockSE, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        BlockQuarterLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderQuarterLog()));
        for (BlockQuarterLog.BlockType blockType : BlockQuarterLog.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(blockSE.cm, blockType.metadata());
        }
    }

    private static void createRedRock() {
        int blockID = BlockSettings.REDROCK.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockRedRock block = new BlockRedRock(blockID, 2, agi.e);
        block.b("extrabiomes.redrock").c(1.5f).b(2.0f).setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel(block, "pickaxe", 0);
        proxy.registerBlock(block, ItemRedRock.class);
        Element.RED_ROCK.set(new ur((amq)block, 1, BlockRedRock.BlockType.RED_ROCK.metadata()));
        Element.RED_COBBLE.set(new ur((amq)block, 1, BlockRedRock.BlockType.RED_COBBLE.metadata()));
        Element.RED_ROCK_BRICK.set(new ur((amq)block, 1, BlockRedRock.BlockType.RED_ROCK_BRICK.metadata()));
        Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockActiveEvent(block));
        BiomeHelper.addTerrainBlockstoBiome(BiomeSettings.MOUNTAINRIDGE, block.cm, block.cm);
        ForestryModHelper.addToDiggerBackpack(new ur((amq)block, 1, -1));
        for (BlockRedRock.BlockType type : BlockRedRock.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(block.cm, type.metadata());
        }
    }

    private static void createSapling() {
        Element[] forestrySaplings;
        int blockID = BlockSettings.SAPLING.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomSapling block = new BlockCustomSapling(blockID, 16);
        block.b("extrabiomes.sapling").c(0.0f).a(amq.g).r().setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((amq)block, ItemSapling.class);
        proxy.registerOreInAllSubblocks("treeSapling", (amq)block);
        Element.SAPLING_ACACIA.set(new ur((amq)block, 1, BlockCustomSapling.BlockType.ACACIA.metadata()));
        Element.SAPLING_AUTUMN_BROWN.set(new ur((amq)block, 1, BlockCustomSapling.BlockType.BROWN.metadata()));
        Element.SAPLING_AUTUMN_ORANGE.set(new ur((amq)block, 1, BlockCustomSapling.BlockType.ORANGE.metadata()));
        Element.SAPLING_AUTUMN_PURPLE.set(new ur((amq)block, 1, BlockCustomSapling.BlockType.PURPLE.metadata()));
        Element.SAPLING_AUTUMN_YELLOW.set(new ur((amq)block, 1, BlockCustomSapling.BlockType.YELLOW.metadata()));
        Element.SAPLING_FIR.set(new ur((amq)block, 1, BlockCustomSapling.BlockType.FIR.metadata()));
        Element.SAPLING_REDWOOD.set(new ur((amq)block, 1, BlockCustomSapling.BlockType.REDWOOD.metadata()));
        ur stack = new ur((amq)block, 1, -1);
        ForestryModHelper.registerSapling(stack);
        ForestryModHelper.addToForesterBackpack(stack);
        for (Element sapling : forestrySaplings = new Element[]{Element.SAPLING_ACACIA, Element.SAPLING_AUTUMN_BROWN, Element.SAPLING_AUTUMN_ORANGE, Element.SAPLING_AUTUMN_PURPLE, Element.SAPLING_AUTUMN_YELLOW, Element.SAPLING_FIR}) {
            ForestryModHelper.registerGermling(sapling.get());
        }
        proxy.registerEventHandler(new SaplingBonemealEventHandler(block));
        proxy.registerFuelHandler(new SaplingFuelHandler(block.cm));
    }

    private static void createWood() {
        int blockID = BlockSettings.CUSTOMLOG.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomLog block = new BlockCustomLog(blockID, 97);
        block.b("extrabiomes.log").a(amq.e).r().c(2.0f).b(amq.M.a(null) * 5.0f).setTextureFile("/extrabiomes/extrabiomes.png").a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((amq)block, "axe", 0);
        proxy.registerBlock((amq)block, MultiItemBlock.class);
        proxy.registerOre("logWood", new ur((amq)block, 1, -1));
        proxy.registerEventHandler((Object)block);
        proxy.setBurnProperties(block.cm, 5, 5);
        Element.LOG_ACACIA.set(new ur((amq)block, 1, BlockCustomLog.BlockType.ACACIA.metadata()));
        Element.LOG_FIR.set(new ur((amq)block, 1, BlockCustomLog.BlockType.FIR.metadata()));
        ForestryModHelper.addToForesterBackpack(new ur((amq)block, 1, -1));
        for (BlockCustomLog.BlockType type : BlockCustomLog.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(block.cm, type.metadata());
        }
    }
}

