/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.textarea;

import de.matthiasmann.twl.textarea.Style;
import java.util.ArrayList;
import java.util.Iterator;

public interface TextAreaModel
extends Iterable<Element> {
    public void addCallback(Runnable var1);

    public void removeCallback(Runnable var1);

    public static class TableElement
    extends Element {
        private final int numColumns;
        private final int numRows;
        private final int cellSpacing;
        private final int cellPadding;
        private final TableCellElement[] cells;
        private final Style[] rowStyles;

        public TableElement(Style style, int numColumns, int numRows, int cellSpacing, int cellPadding) {
            super(style);
            if (numColumns < 0) {
                throw new IllegalArgumentException("numColumns");
            }
            if (numRows < 0) {
                throw new IllegalArgumentException("numRows");
            }
            this.numColumns = numColumns;
            this.numRows = numRows;
            this.cellSpacing = cellSpacing;
            this.cellPadding = cellPadding;
            this.cells = new TableCellElement[numRows * numColumns];
            this.rowStyles = new Style[numRows];
        }

        public int getNumColumns() {
            return this.numColumns;
        }

        public int getNumRows() {
            return this.numRows;
        }

        public int getCellPadding() {
            return this.cellPadding;
        }

        public int getCellSpacing() {
            return this.cellSpacing;
        }

        public TableCellElement getCell(int row, int column) {
            if (column < 0 || column >= this.numColumns) {
                throw new IndexOutOfBoundsException("column");
            }
            if (row < 0 || row >= this.numRows) {
                throw new IndexOutOfBoundsException("row");
            }
            return this.cells[row * this.numColumns + column];
        }

        public Style getRowStyle(int row) {
            return this.rowStyles[row];
        }

        public void setCell(int row, int column, TableCellElement cell) {
            if (column < 0 || column >= this.numColumns) {
                throw new IndexOutOfBoundsException("column");
            }
            if (row < 0 || row >= this.numRows) {
                throw new IndexOutOfBoundsException("row");
            }
            this.cells[row * this.numColumns + column] = cell;
        }

        public void setRowStyle(int row, Style style) {
            this.rowStyles[row] = style;
        }
    }

    public static class TableCellElement
    extends ContainerElement {
        private final int colspan;

        public TableCellElement(Style style) {
            this(style, 1);
        }

        public TableCellElement(Style style, int colspan) {
            super(style);
            this.colspan = colspan;
        }

        public int getColspan() {
            return this.colspan;
        }
    }

    public static class BlockElement
    extends ContainerElement {
        public BlockElement(Style style) {
            super(style);
        }
    }

    public static class OrderedListElement
    extends ContainerElement {
        private final int start;

        public OrderedListElement(Style style, int start) {
            super(style);
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }
    }

    public static class ListElement
    extends ContainerElement {
        public ListElement(Style style) {
            super(style);
        }
    }

    public static class LinkElement
    extends ContainerElement {
        private String href;

        public LinkElement(Style style, String href) {
            super(style);
            this.href = href;
        }

        public String getHREF() {
            return this.href;
        }

        public void setHREF(String href) {
            this.href = href;
        }
    }

    public static class ParagraphElement
    extends ContainerElement {
        public ParagraphElement(Style style) {
            super(style);
        }
    }

    public static class ContainerElement
    extends Element
    implements Iterable<Element> {
        protected final ArrayList<Element> children = new ArrayList();

        public ContainerElement(Style style) {
            super(style);
        }

        @Override
        public Iterator<Element> iterator() {
            return this.children.iterator();
        }

        public Element getElement(int index) {
            return this.children.get(index);
        }

        public int getNumElements() {
            return this.children.size();
        }

        public void add(Element element) {
            this.children.add(element);
        }
    }

    public static class WidgetElement
    extends Element {
        private final String widgetName;
        private final String widgetParam;

        public WidgetElement(Style style, String widgetName, String widgetParam) {
            super(style);
            this.widgetName = widgetName;
            this.widgetParam = widgetParam;
        }

        public String getWidgetName() {
            return this.widgetName;
        }

        public String getWidgetParam() {
            return this.widgetParam;
        }
    }

    public static class ImageElement
    extends Element {
        private final String imageName;
        private final String tooltip;

        public ImageElement(Style style, String imageName, String tooltip) {
            super(style);
            this.imageName = imageName;
            this.tooltip = tooltip;
        }

        public ImageElement(Style style, String imageName) {
            this(style, imageName, null);
        }

        public String getImageName() {
            return this.imageName;
        }

        public String getToolTip() {
            return this.tooltip;
        }
    }

    public static class TextElement
    extends Element {
        private String text;

        public TextElement(Style style, String text) {
            super(style);
            TextElement.notNull(text, "text");
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            TextElement.notNull(text, "text");
            this.text = text;
        }
    }

    public static abstract class Element {
        private Style style;

        protected Element(Style style) {
            Element.notNull(style, "style");
            this.style = style;
        }

        public Style getStyle() {
            return this.style;
        }

        public void setStyle(Style style) {
            Element.notNull(style, "style");
            this.style = style;
        }

        static void notNull(Object o, String name) {
            if (o == null) {
                throw new NullPointerException(name);
            }
        }
    }

    public static enum FloatPosition {
        NONE,
        LEFT,
        RIGHT;

    }

    public static enum Clear {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }

    public static enum VAlignment {
        TOP,
        MIDDLE,
        BOTTOM,
        FILL;

    }

    public static enum Display {
        INLINE,
        BLOCK;

    }

    public static enum HAlignment {
        LEFT,
        RIGHT,
        CENTER,
        JUSTIFY;

    }
}

