/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLTexture;
import de.matthiasmann.twl.renderer.lwjgl.TextureArea;
import org.lwjgl.opengl.GL11;

public class TextureAreaTiled
extends TextureArea {
    public TextureAreaTiled(LWJGLTexture texture, int x, int y, int width, int height, Color tintColor) {
        super(texture, x, y, width, height, tintColor);
    }

    TextureAreaTiled(TextureAreaTiled src, Color tintColor) {
        super(src, tintColor);
    }

    @Override
    public void draw(AnimationState as, int x, int y, int w, int h) {
        if (this.texture.bind(this.tintColor)) {
            int repeatCountX = w / this.width;
            int repeatCountY = h / this.height;
            if (repeatCountX < 10 || repeatCountY < 10) {
                this.drawRepeat(x, y, repeatCountX, repeatCountY);
            } else {
                this.drawRepeatCached(x, y, repeatCountX, repeatCountY);
            }
            int drawnX = repeatCountX * this.width;
            int drawnY = repeatCountY * this.height;
            int restWidth = w - drawnX;
            int restHeight = h - drawnY;
            if (restWidth > 0 || restHeight > 0) {
                GL11.glBegin((int)7);
                if (restWidth > 0 && repeatCountY > 0) {
                    this.drawClipped(x + drawnX, y, restWidth, this.height, 1, repeatCountY);
                }
                if (restHeight > 0) {
                    if (repeatCountX > 0) {
                        this.drawClipped(x, y + drawnY, this.width, restHeight, repeatCountX, 1);
                    }
                    if (restWidth > 0) {
                        this.drawClipped(x + drawnX, y + drawnY, restWidth, restHeight, 1, 1);
                    }
                }
                GL11.glEnd();
            }
        }
    }

    private void drawClipped(int x, int y, int width, int height, int repeatCountX, int repeatCountY) {
        float ctx0 = this.tx0;
        float cty0 = this.ty0;
        float ctx1 = this.tx1;
        float cty1 = this.ty1;
        if (this.width > 1) {
            ctx1 = ctx0 + (float)width / (float)this.texture.getTexWidth();
        }
        if (this.height > 1) {
            cty1 = cty0 + (float)height / (float)this.texture.getTexHeight();
        }
        while (repeatCountY-- > 0) {
            int y1 = y + height;
            int x0 = x;
            int cx = repeatCountX;
            while (cx-- > 0) {
                int x1 = x0 + width;
                GL11.glTexCoord2f((float)ctx0, (float)cty0);
                GL11.glVertex2i((int)x0, (int)y);
                GL11.glTexCoord2f((float)ctx0, (float)cty1);
                GL11.glVertex2i((int)x0, (int)y1);
                GL11.glTexCoord2f((float)ctx1, (float)cty1);
                GL11.glVertex2i((int)x1, (int)y1);
                GL11.glTexCoord2f((float)ctx1, (float)cty0);
                GL11.glVertex2i((int)x1, (int)y);
                x0 = x1;
            }
            y = y1;
        }
    }

    @Override
    public Image createTintedVersion(Color color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        Color newTintColor = this.tintColor.multiply(color);
        if (newTintColor.equals(this.tintColor)) {
            return this;
        }
        return new TextureAreaTiled(this, newTintColor);
    }
}

