/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractTableColumnHeaderModel;
import de.matthiasmann.twl.model.TableModel;
import de.matthiasmann.twl.utils.CallbackSupport;

public abstract class AbstractTableModel
extends AbstractTableColumnHeaderModel
implements TableModel {
    private TableModel.ChangeListener[] callbacks;

    @Override
    public Object getTooltipContent(int row, int column) {
        return null;
    }

    @Override
    public void addChangeListener(TableModel.ChangeListener listener) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, listener, TableModel.ChangeListener.class);
    }

    @Override
    public void removeChangeListener(TableModel.ChangeListener listener) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, listener);
    }

    protected boolean hasCallbacks() {
        return this.callbacks != null;
    }

    protected void fireRowsInserted(int idx, int count) {
        if (this.callbacks != null) {
            for (TableModel.ChangeListener cl : this.callbacks) {
                cl.rowsInserted(idx, count);
            }
        }
    }

    protected void fireRowsDeleted(int idx, int count) {
        if (this.callbacks != null) {
            for (TableModel.ChangeListener cl : this.callbacks) {
                cl.rowsDeleted(idx, count);
            }
        }
    }

    protected void fireRowsChanged(int idx, int count) {
        if (this.callbacks != null) {
            for (TableModel.ChangeListener cl : this.callbacks) {
                cl.rowsChanged(idx, count);
            }
        }
    }

    protected void fireColumnInserted(int idx, int count) {
        if (this.callbacks != null) {
            for (TableModel.ChangeListener cl : this.callbacks) {
                cl.columnInserted(idx, count);
            }
        }
    }

    protected void fireColumnDeleted(int idx, int count) {
        if (this.callbacks != null) {
            for (TableModel.ChangeListener cl : this.callbacks) {
                cl.columnDeleted(idx, count);
            }
        }
    }

    protected void fireColumnHeaderChanged(int column) {
        if (this.callbacks != null) {
            for (TableModel.ChangeListener cl : this.callbacks) {
                cl.columnHeaderChanged(column);
            }
        }
    }

    protected void fireCellChanged(int row, int column) {
        if (this.callbacks != null) {
            for (TableModel.ChangeListener cl : this.callbacks) {
                cl.cellChanged(row, column);
            }
        }
    }

    protected void fireAllChanged() {
        if (this.callbacks != null) {
            for (TableModel.ChangeListener cl : this.callbacks) {
                cl.allChanged();
            }
        }
    }
}

