/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.InfoWindow;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Table;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.model.TableModel;
import de.matthiasmann.twl.model.TableSelectionModel;

public class TableSearchWindow
extends InfoWindow
implements TableBase.KeyboardSearchHandler {
    private final TableSelectionModel selectionModel;
    private final EditField searchTextField;
    private final StringBuilder searchTextBuffer;
    private String searchText;
    private String searchTextLowercase;
    private Timer timer;
    private TableModel model;
    private int column;
    private int currentRow;
    private boolean searchStartOnly;

    public TableSearchWindow(Table table, TableSelectionModel selectionModel) {
        super(table);
        this.selectionModel = selectionModel;
        this.searchTextField = new EditField();
        this.searchTextBuffer = new StringBuilder();
        this.searchText = "";
        Label label = new Label("Search");
        label.setLabelFor(this.searchTextField);
        this.searchTextField.setReadOnly(true);
        DialogLayout l = new DialogLayout();
        l.setHorizontalGroup(l.createSequentialGroup().addWidget(label).addWidget(this.searchTextField));
        l.setVerticalGroup(l.createParallelGroup().addWidget(label).addWidget(this.searchTextField));
        this.add(l);
    }

    public Table getTable() {
        return (Table)this.getOwner();
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model, int column) {
        if (column < 0) {
            throw new IllegalArgumentException("column");
        }
        if (model != null && column >= model.getNumColumns()) {
            throw new IllegalArgumentException("column");
        }
        this.model = model;
        this.column = column;
        this.cancelSearch();
    }

    @Override
    public boolean isActive() {
        return this.isOpen();
    }

    @Override
    public void updateInfoWindowPosition() {
        this.adjustSize();
        this.setPosition(this.getOwner().getX(), this.getOwner().getBottom());
    }

    @Override
    public boolean handleKeyEvent(Event evt) {
        if (this.model == null) {
            return false;
        }
        if (evt.isKeyPressedEvent()) {
            switch (evt.getKeyCode()) {
                case 1: {
                    if (!this.isOpen()) break;
                    this.cancelSearch();
                    return true;
                }
                case 28: {
                    return false;
                }
                case 14: {
                    if (!this.isOpen()) break;
                    int length = this.searchTextBuffer.length();
                    if (length > 0) {
                        this.searchTextBuffer.setLength(length - 1);
                        this.updateText();
                    }
                    this.restartTimer();
                    return true;
                }
                case 200: {
                    if (!this.isOpen()) break;
                    this.searchDir(-1);
                    this.restartTimer();
                    return true;
                }
                case 208: {
                    if (!this.isOpen()) break;
                    this.searchDir(1);
                    this.restartTimer();
                    return true;
                }
                default: {
                    if (!evt.hasKeyCharNoModifiers()) break;
                    if (this.searchTextBuffer.length() == 0) {
                        this.currentRow = Math.max(0, this.getTable().getSelectionManager().getLeadRow());
                        this.searchStartOnly = true;
                    }
                    this.searchTextBuffer.append(evt.getKeyChar());
                    this.updateText();
                    this.restartTimer();
                    return true;
                }
            }
        }
        return false;
    }

    public void cancelSearch() {
        this.searchTextBuffer.setLength(0);
        this.updateText();
        this.closeInfo();
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        this.timer = gui.createTimer();
        this.timer.setDelay(3000);
        this.timer.setCallback(new Runnable(){

            @Override
            public void run() {
                TableSearchWindow.this.cancelSearch();
            }
        });
    }

    @Override
    protected void beforeRemoveFromGUI(GUI gui) {
        this.timer.stop();
        this.timer = null;
        super.beforeRemoveFromGUI(gui);
    }

    private void updateText() {
        this.searchText = this.searchTextBuffer.toString();
        this.searchTextLowercase = null;
        this.searchTextField.setText(this.searchText);
        if (this.searchText.length() >= 0 && this.model != null) {
            if (!this.isOpen() && this.openInfo()) {
                this.updateInfoWindowPosition();
            }
            this.updateSearch();
        }
    }

    private void restartTimer() {
        this.timer.stop();
        this.timer.start();
    }

    private void updateSearch() {
        int row;
        int numRows = this.model.getNumRows();
        if (numRows == 0) {
            return;
        }
        for (row = this.currentRow; row < numRows; ++row) {
            if (!this.checkRow(row)) continue;
            this.setRow(row);
            return;
        }
        if (this.searchStartOnly) {
            this.searchStartOnly = false;
        } else {
            numRows = this.currentRow;
        }
        for (row = 0; row < numRows; ++row) {
            if (!this.checkRow(row)) continue;
            this.setRow(row);
            return;
        }
        this.searchTextField.setErrorMessage("'" + this.searchText + "' not found");
    }

    private void searchDir(int dir) {
        int startRow;
        int numRows = this.model.getNumRows();
        if (numRows == 0) {
            return;
        }
        int row = startRow = TableSearchWindow.wrap(this.currentRow, numRows);
        while (true) {
            if (this.checkRow(row = TableSearchWindow.wrap(row + dir, numRows))) {
                this.setRow(row);
                return;
            }
            if (row != startRow) continue;
            if (!this.searchStartOnly) break;
            this.searchStartOnly = false;
        }
    }

    private void setRow(int row) {
        if (this.currentRow != row) {
            this.currentRow = row;
            this.getTable().scrollToRow(row);
            if (this.selectionModel != null) {
                this.selectionModel.setSelection(row, row);
            }
        }
        this.searchTextField.setErrorMessage(null);
    }

    private boolean checkRow(int row) {
        Object data = this.model.getCell(row, this.column);
        if (data == null) {
            return false;
        }
        String str = data.toString();
        if (this.searchStartOnly) {
            return str.regionMatches(true, 0, this.searchText, 0, this.searchText.length());
        }
        str = str.toLowerCase();
        if (this.searchTextLowercase == null) {
            this.searchTextLowercase = this.searchText.toLowerCase();
        }
        return str.contains(this.searchTextLowercase);
    }

    private static int wrap(int row, int numRows) {
        if (row < 0) {
            return numRows - 1;
        }
        if (row >= numRows) {
            return 0;
        }
        return row;
    }
}

