/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.TextWidget;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.model.ButtonModel;
import de.matthiasmann.twl.model.SimpleButtonModel;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.utils.TextUtil;

public class Button
extends TextWidget {
    public static final AnimationState.StateKey STATE_ARMED = AnimationState.StateKey.get("armed");
    public static final AnimationState.StateKey STATE_PRESSED = AnimationState.StateKey.get("pressed");
    public static final AnimationState.StateKey STATE_SELECTED = AnimationState.StateKey.get("selected");
    private final Runnable stateChangedCB = new Runnable(){

        @Override
        public void run() {
            Button.this.modelStateChanged();
        }
    };
    private ButtonModel model;
    private String themeText;
    private String text;
    private int mouseButton = 0;

    public Button() {
        this(null, false, null);
    }

    public Button(ButtonModel model) {
        this(null, false, model);
    }

    public Button(AnimationState animState) {
        this(animState, false, null);
    }

    public Button(AnimationState animState, boolean inherit) {
        this(animState, inherit, null);
    }

    public Button(String text) {
        this(null, false, null);
        this.setText(text);
    }

    public Button(AnimationState animState, ButtonModel model) {
        this(animState, false, model);
    }

    public Button(AnimationState animState, boolean inherit, ButtonModel model) {
        super(animState, inherit);
        if (model == null) {
            model = new SimpleButtonModel();
        }
        this.setModel(model);
        this.setCanAcceptKeyboardFocus(true);
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel model) {
        boolean isConnected;
        if (model == null) {
            throw new NullPointerException("model");
        }
        boolean bl = isConnected = this.getGUI() != null;
        if (this.model != null) {
            if (isConnected) {
                this.model.disconnect();
            }
            this.model.removeStateCallback(this.stateChangedCB);
        }
        this.model = model;
        this.model.addStateCallback(this.stateChangedCB);
        if (isConnected) {
            this.model.connect();
        }
        this.modelStateChanged();
        AnimationState as = this.getAnimationState();
        as.dontAnimate(STATE_ARMED);
        as.dontAnimate(STATE_PRESSED);
        as.dontAnimate(STATE_HOVER);
        as.dontAnimate(STATE_SELECTED);
    }

    @Override
    protected void widgetDisabled() {
        this.disarm();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.model.setEnabled(enabled);
    }

    public void addCallback(Runnable callback) {
        this.model.addActionCallback(callback);
    }

    public void removeCallback(Runnable callback) {
        this.model.removeActionCallback(callback);
    }

    public boolean hasCallbacks() {
        return this.model.hasActionCallbacks();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.updateText();
    }

    public int getMouseButton() {
        return this.mouseButton;
    }

    public void setMouseButton(int mouseButton) {
        if (mouseButton < 0 || mouseButton > 1) {
            throw new IllegalArgumentException("mouseButton");
        }
        this.mouseButton = mouseButton;
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeButton(themeInfo);
    }

    protected void applyThemeButton(ThemeInfo themeInfo) {
        this.themeText = themeInfo.getParameterValue("text", false, String.class);
        this.updateText();
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        if (this.model != null) {
            this.model.connect();
        }
    }

    @Override
    protected void beforeRemoveFromGUI(GUI gui) {
        if (this.model != null) {
            this.model.disconnect();
        }
        super.beforeRemoveFromGUI(gui);
    }

    @Override
    public int getMinWidth() {
        return Math.max(super.getMinWidth(), this.getPreferredWidth());
    }

    @Override
    public int getMinHeight() {
        return Math.max(super.getMinHeight(), this.getPreferredHeight());
    }

    protected final void doCallback() {
        this.getModel().fireActionCallback();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.disarm();
        }
    }

    protected void disarm() {
        this.model.setHover(false);
        this.model.setArmed(false);
        this.model.setPressed(false);
    }

    void modelStateChanged() {
        super.setEnabled(this.model.isEnabled());
        AnimationState as = this.getAnimationState();
        as.setAnimationState(STATE_SELECTED, this.model.isSelected());
        as.setAnimationState(STATE_HOVER, this.model.isHover());
        as.setAnimationState(STATE_ARMED, this.model.isArmed());
        as.setAnimationState(STATE_PRESSED, this.model.isPressed());
    }

    void updateText() {
        if (this.text == null) {
            super.setCharSequence(TextUtil.notNull(this.themeText));
        } else {
            super.setCharSequence(this.text);
        }
        this.invalidateLayout();
    }

    @Override
    protected boolean handleEvent(Event evt) {
        if (evt.isMouseEvent()) {
            boolean hover = evt.getType() != Event.Type.MOUSE_EXITED && this.isMouseInside(evt);
            this.model.setHover(hover);
            this.model.setArmed(hover && this.model.isPressed());
        }
        switch (evt.getType()) {
            case MOUSE_BTNDOWN: {
                if (evt.getMouseButton() != this.mouseButton) break;
                this.model.setPressed(true);
                this.model.setArmed(true);
                break;
            }
            case MOUSE_BTNUP: {
                if (evt.getMouseButton() != this.mouseButton) break;
                this.model.setPressed(false);
                this.model.setArmed(false);
                break;
            }
            case KEY_PRESSED: {
                switch (evt.getKeyCode()) {
                    case 28: 
                    case 57: {
                        if (!evt.isKeyRepeated()) {
                            this.model.setPressed(true);
                            this.model.setArmed(true);
                        }
                        return true;
                    }
                }
                break;
            }
            case KEY_RELEASED: {
                switch (evt.getKeyCode()) {
                    case 28: 
                    case 57: {
                        this.model.setPressed(false);
                        this.model.setArmed(false);
                        return true;
                    }
                }
                break;
            }
            case POPUP_OPENED: {
                this.model.setHover(false);
                break;
            }
            case MOUSE_WHEEL: {
                return false;
            }
        }
        if (super.handleEvent(evt)) {
            return true;
        }
        return evt.isMouseEvent();
    }
}

