/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.alg.MathHelper;
import codechicken.core.vec.BlockCoord;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.Vector3;
import java.util.List;

public class RayTracer {
    private Vector3 vec = new Vector3();
    private Vector3 vec2 = new Vector3();
    private Vector3 s_vec = new Vector3();
    private double s_dist;
    private int s_side;
    private IndexedCuboid6 c_cuboid;

    private void traceSide(int side, Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.vec.set(start);
        Vector3 hit = null;
        switch (side) {
            case 0: {
                hit = this.vec.XZintercept(end, cuboid.min.y);
                break;
            }
            case 1: {
                hit = this.vec.XZintercept(end, cuboid.max.y);
                break;
            }
            case 2: {
                hit = this.vec.XYintercept(end, cuboid.min.z);
                break;
            }
            case 3: {
                hit = this.vec.XYintercept(end, cuboid.max.z);
                break;
            }
            case 4: {
                hit = this.vec.YZintercept(end, cuboid.min.x);
                break;
            }
            case 5: {
                hit = this.vec.YZintercept(end, cuboid.max.x);
            }
        }
        if (hit == null) {
            return;
        }
        switch (side) {
            case 0: 
            case 1: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
            case 2: 
            case 3: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y)) break;
                return;
            }
            case 4: 
            case 5: {
                if (MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
        }
        double dist = this.vec2.set(hit).subtract(start).magSquared();
        if (dist < this.s_dist) {
            this.s_side = side;
            this.s_dist = dist;
            this.s_vec.set(this.vec);
        }
    }

    public aoh rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.s_dist = Double.MAX_VALUE;
        this.s_side = -1;
        int i = 0;
        while (i < 6) {
            this.traceSide(i, start, end, cuboid);
            ++i;
        }
        if (this.s_side < 0) {
            return null;
        }
        aoh mop = new aoh(0, 0, 0, this.s_side, this.s_vec.toVec3D());
        mop.a = null;
        return mop;
    }

    public aoh rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, BlockCoord pos) {
        aoh mop = this.rayTraceCuboid(start, end, cuboid);
        if (mop != null) {
            mop.a = aoi.a;
            mop.b = pos.x;
            mop.c = pos.y;
            mop.d = pos.z;
        }
        return mop;
    }

    public aoh rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, lq e) {
        aoh mop = this.rayTraceCuboid(start, end, cuboid);
        if (mop != null) {
            mop.a = aoi.b;
            mop.g = e;
        }
        return mop;
    }

    public aoh rayTraceCuboids(Vector3 start, Vector3 end, List cuboids) {
        double c_dist = Double.MAX_VALUE;
        aoh c_hit = null;
        for (IndexedCuboid6 cuboid : cuboids) {
            aoh mop = this.rayTraceCuboid(start, end, cuboid);
            if (mop == null || !(this.s_dist < c_dist)) continue;
            mop.subHit = cuboid.index;
            c_dist = this.s_dist;
            c_hit = mop;
            this.c_cuboid = cuboid;
        }
        return c_hit;
    }

    public aoh rayTraceCuboids(Vector3 start, Vector3 end, List cuboids, BlockCoord pos, amq block) {
        aoh mop = this.rayTraceCuboids(start, end, cuboids);
        if (mop != null) {
            mop.a = aoi.a;
            mop.b = pos.x;
            mop.c = pos.y;
            mop.d = pos.z;
            if (block != null) {
                this.c_cuboid.add(new Vector3(-pos.x, -pos.y, -pos.z)).setBlockBounds(block);
            }
        }
        return mop;
    }

    public static class IndexedCuboid6
    extends Cuboid6 {
        public int index;

        public IndexedCuboid6(int index, Cuboid6 cuboid) {
            super(cuboid);
            this.index = index;
        }
    }
}

