/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.util;

import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class Config {
    public static String getString(Configuration config, String name, String category, String defaultValue, String comment) {
        return Config.get((Configuration)config, (String)name, (String)category, (String)defaultValue, (String)comment).value;
    }

    public static boolean getBoolean(Configuration config, String name, String category, boolean defaultValue, String comment) {
        return Config.get(config, name, category, defaultValue, comment).getBoolean(false);
    }

    public static int getInt(Configuration config, String name, String category, int defaultValue, int minValue, int maxValue, String comment) {
        return Config.get(config, name, category, defaultValue, minValue, maxValue, comment).getInt(defaultValue);
    }

    public static float getFloat(Configuration config, String name, String category, float defaultValue, float minValue, float maxValue, String comment) {
        return Float.parseFloat(Config.get((Configuration)config, (String)name, (String)category, (float)defaultValue, (float)minValue, (float)maxValue, (String)comment).value);
    }

    public static Property get(Configuration config, String name, String category, String defaultValue, String comment) {
        Property prop = config.get(category, name, defaultValue);
        prop.comment = comment + " [default: " + defaultValue + "]";
        return prop;
    }

    public static Property get(Configuration config, String name, String category, boolean defaultValue, String comment) {
        Property prop = config.get(category, name, defaultValue);
        prop.comment = comment + " [default: " + defaultValue + "]";
        return prop;
    }

    public static Property get(Configuration config, String name, String category, int defaultValue, int minValue, int maxValue, String comment) {
        Property prop = config.get(category, name, defaultValue);
        prop.comment = comment + " [range: " + minValue + " ~ " + maxValue + ", default: " + defaultValue + "]";
        prop.value = Integer.toString(prop.getInt(defaultValue) < minValue ? minValue : (prop.getInt(defaultValue) > maxValue ? maxValue : prop.getInt(defaultValue)));
        return prop;
    }

    public static Property get(Configuration config, String name, String category, float defaultValue, float minValue, float maxValue, String comment) {
        Property prop = config.get(category, name, Float.toString(defaultValue));
        prop.comment = comment + " [range: " + minValue + " ~ " + maxValue + ", default: " + defaultValue + "]";
        try {
            prop.value = Float.toString(Float.parseFloat(prop.value) < minValue ? minValue : (Float.parseFloat(prop.value) > maxValue ? maxValue : Float.parseFloat(prop.value)));
        }
        catch (Exception e) {
            prop.value = "0";
            e.printStackTrace();
        }
        return prop;
    }
}

