/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.renderer;

import java.nio.FloatBuffer;
import java.util.Collections;
import lunatrius.schematica.Settings;
import lunatrius.schematica.renderer.RendererSchematicChunk;
import lunatrius.schematica.renderer.RendererSchematicChunkSorter;
import lunatrius.schematica.util.Vector3f;
import lunatrius.schematica.util.Vector3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RendererSchematicGlobal {
    private final Settings settings = Settings.instance();
    private final kh profiler;
    private final bbf frustrum;
    private final RendererSchematicChunkSorter rendererSchematicChunkSorter;
    private static final int quadBufferSize = 240;
    private final FloatBuffer quadColorBudder;
    private final FloatBuffer quadVertexBuffer;
    private int quadObjectCount;
    private static final int lineBufferSize = 240;
    private final FloatBuffer lineColorBuffer;
    private final FloatBuffer lineVertecBuffer;
    private int lineObjectCount;

    public RendererSchematicGlobal() {
        this.profiler = this.settings.minecraft.I;
        this.frustrum = new bbf();
        this.rendererSchematicChunkSorter = new RendererSchematicChunkSorter();
        this.quadColorBudder = BufferUtils.createFloatBuffer((int)960);
        this.quadVertexBuffer = BufferUtils.createFloatBuffer((int)720);
        this.quadObjectCount = -1;
        this.lineColorBuffer = BufferUtils.createFloatBuffer((int)960);
        this.lineVertecBuffer = BufferUtils.createFloatBuffer((int)720);
        this.lineObjectCount = -1;
    }

    @ForgeSubscribe
    public void onRender(RenderWorldLastEvent event) {
        ays player;
        if (this.settings.minecraft != null && (player = this.settings.minecraft.g) != null) {
            this.settings.playerPosition.x = (float)(player.T + (player.t - player.T) * (double)event.partialTicks);
            this.settings.playerPosition.y = (float)(player.U + (player.u - player.U) * (double)event.partialTicks);
            this.settings.playerPosition.z = (float)(player.V + (player.v - player.V) * (double)event.partialTicks);
            this.settings.rotationRender = (int)((player.z / 90.0f % 4.0f + 4.0f) % 4.0f);
            this.profiler.a("schematica");
            if (this.settings.isRenderingSchematic || this.settings.isRenderingGuide) {
                this.render();
            }
            this.profiler.b();
        }
    }

    void render() {
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glTranslatef((float)(-this.settings.getTranslationX()), (float)(-this.settings.getTranslationY()), (float)(-this.settings.getTranslationZ()));
        this.profiler.a("schematic");
        if (this.settings.isRenderingSchematic) {
            this.profiler.a("updateFrustrum");
            this.updateFrustrum();
            this.profiler.c("sortAndUpdate");
            if (RendererSchematicChunk.getCanUpdate()) {
                this.sortAndUpdate();
            }
            this.profiler.c("render");
            for (int pass = 0; pass < 3; ++pass) {
                for (RendererSchematicChunk renderer : this.settings.sortedRendererSchematicChunk) {
                    renderer.render(pass);
                }
            }
            this.profiler.b();
        }
        this.profiler.c("guide");
        this.quadObjectCount = 0;
        this.lineObjectCount = 0;
        this.quadColorBudder.clear();
        this.quadVertexBuffer.clear();
        this.lineColorBuffer.clear();
        this.lineVertecBuffer.clear();
        this.profiler.a("dataPrep");
        if (this.settings.isRenderingSchematic) {
            this.drawCuboidOutline(Vector3i.ZERO, new Vector3i(this.settings.schematic.width(), this.settings.schematic.height(), this.settings.schematic.length()), 0.75f, 0.0f, 0.75f, 0.25f);
        }
        if (this.settings.isRenderingGuide) {
            Vector3i start = null;
            Vector3i end = null;
            start = this.settings.pointMin.clone().sub(this.settings.offset);
            end = this.settings.pointMax.clone().sub(this.settings.offset).add(1);
            this.drawCuboidOutline(start, end, 0.0f, 0.75f, 0.0f, 0.25f);
            start = this.settings.pointA.clone().sub(this.settings.offset);
            end = start.clone().add(1);
            this.drawCuboidOutline(start, end, 0.75f, 0.0f, 0.0f, 0.25f);
            this.drawCuboidSurface(start, end, 0.75f, 0.0f, 0.0f, 0.25f);
            start = this.settings.pointB.clone().sub(this.settings.offset);
            end = start.clone().add(1);
            this.drawCuboidOutline(start, end, 0.0f, 0.0f, 0.75f, 0.25f);
            this.drawCuboidSurface(start, end, 0.0f, 0.0f, 0.75f, 0.25f);
        }
        if (this.quadObjectCount > 0 || this.lineObjectCount > 0) {
            this.quadColorBudder.flip();
            this.quadVertexBuffer.flip();
            this.lineColorBuffer.flip();
            this.lineVertecBuffer.flip();
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)1.5f);
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32886);
            this.profiler.c("quad");
            if (this.quadObjectCount > 0) {
                GL11.glColorPointer((int)4, (int)0, (FloatBuffer)this.quadColorBudder);
                GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)this.quadVertexBuffer);
                GL11.glDrawArrays((int)7, (int)0, (int)this.quadObjectCount);
            }
            this.profiler.c("line");
            if (this.lineObjectCount > 0) {
                GL11.glColorPointer((int)4, (int)0, (FloatBuffer)this.lineColorBuffer);
                GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)this.lineVertecBuffer);
                GL11.glDrawArrays((int)1, (int)0, (int)this.lineObjectCount);
            }
            this.profiler.b();
            GL11.glDisableClientState((int)32886);
            GL11.glDisableClientState((int)32884);
            GL11.glEnable((int)3553);
        }
        this.profiler.b();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void drawCuboidSurface(Vector3i a, Vector3i b, float red, float green, float blue, float alpha) {
        Vector3f zero = new Vector3f(a.x, a.y, a.z).sub(this.settings.blockDelta);
        Vector3f size = new Vector3f(b.x, b.y, b.z).add(this.settings.blockDelta);
        this.quadVertexBuffer.put(zero.x).put(zero.y).put(zero.z);
        this.quadVertexBuffer.put(zero.x).put(zero.y).put(size.z);
        this.quadVertexBuffer.put(zero.x).put(size.y).put(size.z);
        this.quadVertexBuffer.put(zero.x).put(size.y).put(zero.z);
        this.quadVertexBuffer.put(size.x).put(zero.y).put(size.z);
        this.quadVertexBuffer.put(size.x).put(zero.y).put(zero.z);
        this.quadVertexBuffer.put(size.x).put(size.y).put(zero.z);
        this.quadVertexBuffer.put(size.x).put(size.y).put(size.z);
        this.quadVertexBuffer.put(size.x).put(zero.y).put(zero.z);
        this.quadVertexBuffer.put(zero.x).put(zero.y).put(zero.z);
        this.quadVertexBuffer.put(zero.x).put(size.y).put(zero.z);
        this.quadVertexBuffer.put(size.x).put(size.y).put(zero.z);
        this.quadVertexBuffer.put(zero.x).put(zero.y).put(size.z);
        this.quadVertexBuffer.put(size.x).put(zero.y).put(size.z);
        this.quadVertexBuffer.put(size.x).put(size.y).put(size.z);
        this.quadVertexBuffer.put(zero.x).put(size.y).put(size.z);
        this.quadVertexBuffer.put(size.x).put(zero.y).put(zero.z);
        this.quadVertexBuffer.put(size.x).put(zero.y).put(size.z);
        this.quadVertexBuffer.put(zero.x).put(zero.y).put(size.z);
        this.quadVertexBuffer.put(zero.x).put(zero.y).put(zero.z);
        this.quadVertexBuffer.put(size.x).put(size.y).put(zero.z);
        this.quadVertexBuffer.put(zero.x).put(size.y).put(zero.z);
        this.quadVertexBuffer.put(zero.x).put(size.y).put(size.z);
        this.quadVertexBuffer.put(size.x).put(size.y).put(size.z);
        for (int i = 0; i < 24; ++i) {
            this.quadColorBudder.put(red).put(green).put(blue).put(alpha);
        }
        this.quadObjectCount += 24;
    }

    private void drawCuboidOutline(Vector3i a, Vector3i b, float red, float green, float blue, float alpha) {
        Vector3f zero = new Vector3f(a.x, a.y, a.z).sub(this.settings.blockDelta);
        Vector3f size = new Vector3f(b.x, b.y, b.z).add(this.settings.blockDelta);
        this.lineVertecBuffer.put(zero.x).put(zero.y).put(zero.z);
        this.lineVertecBuffer.put(zero.x).put(zero.y).put(size.z);
        this.lineVertecBuffer.put(zero.x).put(size.y).put(zero.z);
        this.lineVertecBuffer.put(zero.x).put(size.y).put(size.z);
        this.lineVertecBuffer.put(size.x).put(zero.y).put(zero.z);
        this.lineVertecBuffer.put(size.x).put(zero.y).put(size.z);
        this.lineVertecBuffer.put(size.x).put(size.y).put(zero.z);
        this.lineVertecBuffer.put(size.x).put(size.y).put(size.z);
        this.lineVertecBuffer.put(zero.x).put(zero.y).put(zero.z);
        this.lineVertecBuffer.put(size.x).put(zero.y).put(zero.z);
        this.lineVertecBuffer.put(zero.x).put(size.y).put(zero.z);
        this.lineVertecBuffer.put(size.x).put(size.y).put(zero.z);
        this.lineVertecBuffer.put(zero.x).put(zero.y).put(size.z);
        this.lineVertecBuffer.put(size.x).put(zero.y).put(size.z);
        this.lineVertecBuffer.put(zero.x).put(size.y).put(size.z);
        this.lineVertecBuffer.put(size.x).put(size.y).put(size.z);
        this.lineVertecBuffer.put(zero.x).put(zero.y).put(zero.z);
        this.lineVertecBuffer.put(zero.x).put(size.y).put(zero.z);
        this.lineVertecBuffer.put(size.x).put(zero.y).put(zero.z);
        this.lineVertecBuffer.put(size.x).put(size.y).put(zero.z);
        this.lineVertecBuffer.put(zero.x).put(zero.y).put(size.z);
        this.lineVertecBuffer.put(zero.x).put(size.y).put(size.z);
        this.lineVertecBuffer.put(size.x).put(zero.y).put(size.z);
        this.lineVertecBuffer.put(size.x).put(size.y).put(size.z);
        for (int i = 0; i < 24; ++i) {
            this.lineColorBuffer.put(red).put(green).put(blue).put(alpha);
        }
        this.lineObjectCount += 24;
    }

    void updateFrustrum() {
        this.frustrum.a((double)this.settings.getTranslationX(), (double)this.settings.getTranslationY(), (double)this.settings.getTranslationZ());
        for (RendererSchematicChunk rendererSchematicChunk : this.settings.sortedRendererSchematicChunk) {
            rendererSchematicChunk.isInFrustrum = this.frustrum.a(rendererSchematicChunk.getBoundingBox());
        }
    }

    void sortAndUpdate() {
        Collections.sort(this.settings.sortedRendererSchematicChunk, this.rendererSchematicChunkSorter);
        for (RendererSchematicChunk rendererSchematicChunk : this.settings.sortedRendererSchematicChunk) {
            if (!rendererSchematicChunk.getDirty()) continue;
            rendererSchematicChunk.updateRenderer();
            break;
        }
    }
}

